#!/bin/sh

# panic: kern_clock_gettime: 22
# cpuid = 1
# time = 1750181240
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01a6084ba0
# vpanic() at vpanic+0x136/frame 0xfffffe01a6084cd0
# panic() at panic+0x43/frame 0xfffffe01a6084d30
# kern_clock_nanosleep() at kern_clock_nanosleep+0x38f/frame 0xfffffe01a6084db0
# sys_clock_nanosleep() at sys_clock_nanosleep+0x49/frame 0xfffffe01a6084e00
# amd64_syscall() at amd64_syscall+0x169/frame 0xfffffe01a6084f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe01a6084f30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x8233d281a, rsp = 0x820bfb2b8, rbp = 0x820bfb2e0 ---
# KDB: enter: panic
# [ thread pid 26119 tid 104417 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x122a7b2(%rip)
# db> x/s version
# version: FreeBSD 15.0-CURRENT #1 ufs-n278031-3296ff02387b: Tue Jun 17 16:40:44 CEST 2025
# pho@mercat1.netperf.freebsd.org:/var/tmp/deviant3/sys/amd64/compile/PHO
# db> 

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=5eb7636bc26fcbd20412de35ec10944233b8577d
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+e17e46b1f0b65027b005@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <unistd.h>

int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  *(uint64_t*)0x200000000040 = 0x10000000000;
  *(uint64_t*)0x200000000048 = 0x4000000;
  syscall(SYS_clock_nanosleep, /*id=*/0x10ul, /*flags=TIMER_ABSTIME*/ 1ul,
          /*rqtp=*/0x200000000040ul, /*rmtp=*/0ul);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c || exit 1

work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
timeout 3m /tmp/$prog > /dev/null 2>&1

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core /tmp/$prog.?????? $work
exit 0
