#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 15; apic id = 23
# fault virtual address   = 0x10
# fault code              = supervisor read data, page not present
# instruction pointer     = 0x20:0xffffffff80de3833
# stack pointer           = 0x28:0xfffffe01398a8860
# frame pointer           = 0x28:0xfffffe01398a8880
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 2798 (syzkaller17)
# trap number             = 12
# panic: page fault
# cpuid = 15
# time = 1593500664
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01398a8510
# vpanic() at vpanic+0x182/frame 0xfffffe01398a8560
# panic() at panic+0x43/frame 0xfffffe01398a85c0
# trap_fatal() at trap_fatal+0x387/frame 0xfffffe01398a8620
# trap_pfault() at trap_pfault+0x99/frame 0xfffffe01398a8680
# trap() at trap+0x2a5/frame 0xfffffe01398a8790
# calltrap() at calltrap+0x8/frame 0xfffffe01398a8790
# --- trap 0xc, rip = 0xffffffff80de3833, rsp = 0xfffffe01398a8860, rbp = 0xfffffe01398a8880 ---
# sctp_find_ifa_in_ep() at sctp_find_ifa_in_ep+0x83/frame 0xfffffe01398a8880
# sctp_addr_mgmt_ep_sa() at sctp_addr_mgmt_ep_sa+0x56/frame 0xfffffe01398a88c0
# sctp_bindx_delete_address() at sctp_bindx_delete_address+0x9e/frame 0xfffffe01398a8910
# sctp_setopt() at sctp_setopt+0x2134/frame 0xfffffe01398a8990
# sctp_ctloutput() at sctp_ctloutput+0x173/frame 0xfffffe01398a89f0
# sosetopt() at sosetopt+0xed/frame 0xfffffe01398a8a50
# kern_setsockopt() at kern_setsockopt+0xac/frame 0xfffffe01398a8ab0
# sys_setsockopt() at sys_setsockopt+0x24/frame 0xfffffe01398a8ad0
# amd64_syscall() at amd64_syscall+0x159/frame 0xfffffe01398a8bf0
# fast_syscall_common() at fast_syscall_common+0x101/frame 0xfffffe01398a8bf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x80042813a, rsp = 0x7fffffffe538, rbp = 0x7fffffffe570 ---
# KDB: enter: panic
# [ thread pid 2798 tid 100249 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10c4cf6(%rip)
# db> x/s version
# version: FreeBSD 13.0-CURRENT #0 r362791: Tue Jun 30 08:57:50 CEST 2020
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
kldstat -v | grep -q sctp || kldload sctp.ko
cat > /tmp/syzkaller17.c <<EOF
// https://syzkaller.appspot.com/bug?id=a038e666f2e27a98b03aa605054c088e6ef2bb5d
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+f3a6fccfa6ae9d3ded29@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <unistd.h>

uint64_t r[1] = {0xffffffffffffffff};

int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  intptr_t res = 0;
  res = syscall(SYS_socket, 2ul, 5ul, 0x84);
  if (res != -1)
    r[0] = res;
  *(uint8_t*)0x200001c0 = 0x10;
  *(uint8_t*)0x200001c1 = 2;
  *(uint16_t*)0x200001c2 = htobe16(0x4e20);
  *(uint8_t*)0x200001c4 = 0xac;
  *(uint8_t*)0x200001c5 = 0x14;
  *(uint8_t*)0x200001c6 = 0;
  *(uint8_t*)0x200001c7 = 0xaa;
  *(uint8_t*)0x200001c8 = 0;
  *(uint8_t*)0x200001c9 = 0;
  *(uint8_t*)0x200001ca = 0;
  *(uint8_t*)0x200001cb = 0;
  *(uint8_t*)0x200001cc = 0;
  *(uint8_t*)0x200001cd = 0;
  *(uint8_t*)0x200001ce = 0;
  *(uint8_t*)0x200001cf = 0;
  *(uint64_t*)0x200001d0 = 0;
  *(uint64_t*)0x200001d8 = 0;
  *(uint64_t*)0x200001e0 = 0;
  *(uint64_t*)0x200001e8 = 0;
  *(uint64_t*)0x200001f0 = 0;
  *(uint64_t*)0x200001f8 = 0;
  *(uint64_t*)0x20000200 = 0;
  *(uint64_t*)0x20000208 = 0;
  *(uint64_t*)0x20000210 = 0;
  *(uint64_t*)0x20000218 = 0;
  *(uint64_t*)0x20000220 = 0;
  *(uint64_t*)0x20000228 = 0;
  *(uint64_t*)0x20000230 = 0;
  *(uint64_t*)0x20000238 = 0;
  *(uint64_t*)0x20000240 = 0;
  *(uint32_t*)0x20000248 = 0;
  *(uint32_t*)0x2000024c = 4;
  *(uint32_t*)0x20000250 = 0;
  *(uint32_t*)0x20000254 = 0;
  *(uint32_t*)0x20000258 = 0;
  *(uint16_t*)0x2000025c = 0;
  *(uint8_t*)0x2000025e = 0;
  syscall(SYS_setsockopt, r[0], 0x84, 0x8002, 0x200001c0ul, 0xa0ul);
  return 0;
}
EOF
mycc -o /tmp/syzkaller17 -Wall -Wextra -O0 /tmp/syzkaller17.c ||
    exit 1

(cd ../testcases/swap; ./swap -t 1m -i 20 -h > /dev/null 2>&1) &
start=`date +%s`
while pgrep -q swap; do
	(cd /tmp; timeout 1m ./syzkaller17)
	[ $((`date +%s` - start)) -ge 60 ] && break
done
pkill -9 syzkaller17
while pkill swap; do sleep 1; done
wait

rm -f /tmp/syzkaller17 /tmp/syzkaller17.c /tmp/syzkaller17.core
exit 0
