#!/bin/sh
#
# Copyright (c) 2010 Edward Tomasz Napierała <trasz@FreeBSD.org>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
#

# This shell script generates an input file for the "run" script, used
# to verify generation of trivial ACLs.

echo "$ touch f"
touch f

for s in `jot 7 0 7`; do
	for u in `jot 7 0 7`; do
		for g in `jot 7 0 7`; do
			for o in `jot 7 0 7`; do
				echo "$ chmod 0$s$u$g$o f"
				chmod "0$s$u$g$o" f
				echo "$ ls -l f | cut -d' ' -f1"
				ls -l f | cut -d' ' -f1 | sed 's/^/> /'
				echo "$ getfacl -q f"
				getfacl -q f | sed 's/^/> /'
			done
		done
	done
done

echo "$ rm f"
rm f

