# $NetBSD: directive-export-gmake.mk,v 1.10 2025/06/28 22:39:28 rillig Exp $
#
# Tests for the export directive (without leading dot), as in GNU make.

# The "export" directive only affects the environment of the make process
# and its child processes.  It does not affect the global variables or any
# other variables.
VAR=	before
export VAR=exported
.if ${VAR} != "before"
.  error
.endif

# Ensure that the name-value pair is actually exported.
.if ${:!echo "\$VAR"!} != "exported"
.  error
.endif

# This line looks like it would export 2 variables, but it doesn't.
# It only exports VAR and appends everything else as the variable value.
export VAR=exported VAR2=exported-as-well
.if ${:!echo "\$VAR"!} != "exported VAR2=exported-as-well"
.  error ${:!echo "\$VAR"!}
.endif

# Contrary to the usual variable assignments, spaces are significant
# after the '=' sign and are prepended to the value of the environment
# variable.
export VAR=  leading spaces
.if ${:!echo "\$VAR"!} != "  leading spaces"
.  error
.endif

# Contrary to the usual variable assignments, spaces are significant
# before the '=' sign and are appended to the name of the environment
# variable.
#
# Depending on the shell, environment variables with such exotic names
# may be silently discarded.  One such shell is dash, which is the default
# shell on Ubuntu and Debian.
export VAR =trailing space in varname
.if ${:!env | grep trailing || true!} != "VAR =trailing space in varname"
.  if ${:!env | grep trailing || true!} != "" # for dash
.    error
.  endif
.endif

# The right-hand side of the exported variable is expanded exactly once.
TWICE=	expanded twice
ONCE=	expanded once, leaving $${TWICE} as-is
export VAR=${ONCE}
.if ${:!echo "\$VAR"!} != "expanded once, leaving \${TWICE} as-is"
.  error
.endif

# Undefined variables are allowed on the right-hand side, they expand
# to an empty string, as usual.
export VAR=an ${UNDEF} variable
.if ${:!echo "\$VAR"!} != "an  variable"
.  error
.endif


# The body of the .for loop expands to 'export VAR=${:U1}', and the 'export'
# directive is only recognized if the line does not contain a ':', to allow
# 'export' to be a regular target.
.for value in 1
# XXX: The ':' in this line is inside an expression and should thus not be
# interpreted as a dependency operator.
# expect+1: Invalid line "export VAR=${:U1}", expanded to "export VAR=1"
export VAR=${value}
.endfor


# The 'export' directive expands expressions, but the expressions must not
# contain a ':', due to the overly strict parser.  The indirect expressions
# may contain a ':', though.
#
# As a side effect, this test demonstrates that the 'export' directive exports
# the environment variable immediately, other than the '.export' directive,
# which defers that action if the variable value contains a '$'.
INDIRECT_TZ=	${:UAmerica/Los_Angeles}
export TZ=${INDIRECT_TZ}
# expect+1: 16:00:00
.info ${%T:L:localtime=86400}


# The '=' must be present in the unexpanded line, it cannot be generated by
# an expression.
EQ=	=
# expect+1: Variable/Value missing from "export"
export EQ_VAR${EQ}eq-value
.if ${:!env!:MEQ_VAR=*}
.  error
.endif


# The variable name must be given directly, it is not expanded.  The name of
# the exported variable thus starts with a '$', and that name may be filtered
# out by the platform.
INDIRECT_NAME=	I_NAME
INDIRECT_VALUE=	indirect value
export ${INDIRECT_NAME}=${INDIRECT_VALUE}
.if ${:!env!:MI_NAME=*}
.  error
.endif
