#! /bin/sh
#
#  Make files.
#
#  Shell Skript zum Erzeugen aller djgpp port spezifischen Dateien.
#
#
#
#  Argumente:  keine
#              Alle Argumente muessen intern editiert werden.
#
#
#   FILE_NAME:  foobar    (Name der Bestandteil des Announcement-Dateinamens ist.  Bsp: foobar-announce.txt)
#
#


FILE_NAME="libpcre"
RELEASE_NUMBER="1"

cat > script.sed << EOS
/^##  START @AC_VERSION@/,/^##  END @AC_VERSION@/ {
  /^##  START @AC_VERSION@=2.69$/,/^##  END @AC_VERSION@=2.69$/!d
}
/^##  START @AC_VERSION@/d
/^##  END @AC_VERSION@/d
s/@PRODUCT_NAME@/PCRE/g
s/@PRODUCT_VER@/8.38/g
s/@NAME@/pcre/g
s/@VER@/838/g
s/@EXT@//g
s/@DIRECTORY@/8.38/g
s/@FILE_NAME@/${FILE_NAME}/g
s/@TIME_STAMP@/2016-03-07/g
s/@AC_VERSION@/2.69/g
/^:<#neue option teil.*#>$/d
/^:# Beginn[ ]*Zusaetzlich zu veraendernde Dateinamen.$/,/^:# Ende[ ]*Zusaetzlich zu veraendernde Dateinamen.$/ d
/^:# Beginn[ ]*Zusaetzlich zu veraendernde Dateien.$/,/^:# Ende[ ]*Zusaetzlich zu veraendernde Dateien.$/ d
EOS

if [ x"${RELEASE_NUMBER}" != x"1" ]; then
  cat >> script.sed << EOS
    s/@REL@/r${RELEASE_NUMBER}/g
    s/@RELEASE@/Release ${RELEASE_NUMBER} of the /
EOS
else
  cat >> script.sed << EOS
    s/@REL@//g
    s/@RELEASE@//
EOS
fi

FILES="config.bat config.sed fnchange.lst README ../${FILE_NAME}-announce.txt"
for FILE in $FILES; do
  if [ ! -f $FILE.orig ]; then
    mv -vf $FILE $FILE.orig
  fi
  sed -f script.sed $FILE.orig > $FILE
  if [ "x$FILE" != "xconfig.bat" ]; then
    dtou $FILE
  fi
done

rm -vf script.sed
