#! /bin/sh

#
#  Warning: not very carefully tested. Use at Your own risc.
#  Copy source original archives of gcc-2.95.3 and libg++-2.8.1.3
#  in this directory and edit them names is required (.tar.gz,.tgz,tar.bz2)
#  Also edit build directory if needed. 
#
#  The checking whether all is Ok with running gcc-patch/gcc-patch.sh
#  is not yet included. So be carefull.
#
top=`pwd`
gcc_archive=gcc-2.95.3.tar.gz
libgpp_archive=libg++-2.8.1.3.tar.gz
export gpc_archive=

is_error=false
include_chill=false
include_java=false

while ! test -z "$1" ; do
      case $1 in
           --gpc=*)
                   export gpc_archive=`echo $1 | sed -e 's,^\-\-gpc\=,,g'`
                   ;;
           --with_chill)
                   include_chill=true;
                   ;;   
           --without_chill)
                   include_chill=false;
                   ;;   
           --with_java)
                   include_java=true;
                   ;;   
           --without_java)
                   include_java=false;
                   ;;   
           --help)
                   echo 'makesrc.sh : Generates gcc-2.95.3 source archive for DJGPP'
                   echo ''
                   echo 'Command line:'
                   echo '  sh makesrc.sh [options]'
                   echo 'Following options are supported:'
                   echo '  --gpc=name          specifies name of GPC archive (in current directory)'
                   echo '  --with-chill        includes sources of CHILL compiler (off by default)'
                   echo '  --with-java         includes sources of GNU JAVA compiler (off by default)'
                   echo ''
                   echo 'JAVA and CHILL compilers are not tested for DJGPP and more'
                   echo 'likely are not working at all (so I left them out by default'
                   echo ''
                   exit 1
                   ;;
           *)
                   echo "Unknown option $1"
                   is_error=true;
                   ;;
      esac
      shift
done

$is_error && exit 1

unpack_source_archive ()
{
    echo Unpacking $top/$1 ...
    case $1 in
         *.tgz | *.tar.gz)
               ( cd $top/gnu && tar xzf $top/$1 )
               ;;
         *.tar.bz2)
               ( cd $top/gnu && tar xf $top/$1 --use=bzip2 )
               ;;
         [a-zA-Z0-9]*)
               false
               ;;
         *)
               true
               ;;
    esac
}

install -d $top/gnu
install -d $top/manifest

if ! [ -f $gcc_archive ]; then echo $gcc_archive not found; exit 1; fi

if ! [ -f $libgpp_archive ]; then echo $libgpp_archive not found; exit 1; fi

orig_gcc_dirname=`basename $gcc_archive | sed -e 's/[.]tgz//g' -e 's/[.]tar[.]gz//g' -e 's/[.]tar[.]bz2//g'`

case $orig_gcc_dirname in 
     *-2.95.[1-9][.-]test*)
          gcc_dirname=`echo $orig_gcc_dirname |\
          sed -e 's/[-\.]test[1-9]//g' -e 's/95\./95/g'` 
          ;;
     *-2.95.*)
          gcc_dirname=`echo $orig_gcc_dirname | sed -e 's/95\./95/g'`
          ;;
     *)
          conv_dirname=$orig_gcc_dirname
          ;;
esac;       

djsrc=`echo $gcc_dirname | sed -e 's/[-]//g' -e 's/[.]//g'`s

libgpp_dirname=`basename $libgpp_archive | sed -e 's/[.]tgz//g' -e 's/[.]tar[.]gz//g' -e 's/[.]tar[.]bz2//g'`

if ! test -z $gpc_archive ; then
   gpc_dirname=`basename $gpc_archive |\
                sed -e 's/\.tgz//g' -e 's/\.tar\.gz//g' -e 's/\.tar\.bz2//g'`
fi

if [ -d $top/gnu/$orig_gcc_dirname ]; then
   echo ERROR: Directory $top/$gcc_dirname already exists
   exit 1
fi

if [ -d $top/gnu/$gcc_dirname ]; then
   echo ERROR: Directory $top/$gcc_dirname already exists
   exit 1
fi

if [ -d $top/gnu/$libgpp_dirname ]; then
   echo ERROR: Directory $top/$libgpp_dirname already exists
   exit 1
fi
   
cd $top/gnu || exit 1;
echo "Unpacking sources ..."

unpack_source_archive $gcc_archive || exit 1

unpack_source_archive $libgpp_archive || exit 1

if ! test -z $gpc_archive ; then
   unpack_source_archive $gpc_archive
fi

mv -v $orig_gcc_dirname $gcc_dirname

( 
      cd $top/gnu/$libgpp_dirname &&\
      mv -fv * ../$gcc_dirname
)

rm -fr $top/gnu/$libgpp_dirname

if ! test -z $gpc_archive ; then
   (
      cd $top/gnu/$gpc_dirname &&\
      mv -fv * ../$gcc_dirname/gcc &&\
      ( 
         cd $top/gnu/$gcc_dirname/gcc && 
         patch -p1 <p/diffs/gcc-2.95.diff | tee $top/gpcpatch.lst; 
         if [ -f $top/gpcpatch.lst ] ; then
            gpc_upd_list=`cat $top/gpcpatch.lst | grep ^patching |\
                          sed -e 's/^patching\ file//g'`
            for f in $gpc_upd_list; do
                echo "dtou $top/gnu/$gcc_dirname/gcc/$f";
                dtou $top/gnu/$gcc_dirname/gcc/$f;                                                      
            done;
         fi
      )
   )
   rm -rf $top/gnu/$gpc_dirname
fi

echo Patching $gcc_dirname for DJGPP

export gccsrc=$top/gnu/$gcc_dirname;

( cd $top/gcc-patch && ( redir -eo ./gcc-patch.sh >../gcc-patch.log ) )

echo Building gcc source archive for DJGPP

if ! $include_chill ; then
   rm -rf $top/gnu/$gcc_dirname/gcc/ch
   rm -rf $top/gnu/$gcc_dirname/libchill
   rm -f $top/gnu/$gcc_dirname/install.djg/manifest/chil*.*
fi

if ! $include_java ; then
   rm -rf $top/gnu/$gcc_dirname/gcc/java
   rm -f $top/gnu/$gcc_dirname/install.djg/manifest/gcj*.*
fi

curr=`pwd`
cd $top
echo "${djsrc}.zip : ${orig_gcc_dirname} source archive (together with ${libgpp_dirname})" >manifest/${djsrc}.ver
rm -f manifest/${djsrc}.mft;
touch manifest/${djsrc}.mft;

(
      find gnu/${gcc_dirname} -not -type d
      find manifest -name ${djsrc}\*
) | grep -v [~]1 \
  | grep -v [.]orig \
  | sort \
  | sed -e 's,etc[/]hints,etc/HINTS,g' \
>manifest/${djsrc}.mft

cd $top || exit 1
rm -f ${djsrc}.zip
zip -9 ${djsrc}.zip @manifest/${djsrc}.mft >/dev/null

