/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#include "libsupp.h"
#include "dirstruc.h"

void
libsupp___set_need_fake_dot_dotdot(DIR *dir)
{
  int oerrno = errno;

  dir->need_fake_dot_dotdot = 0;
  if (IS_ROOT_DIR(dir->name))
  {    
    /* see if findfirst finds "." anyway */
    char dir_name[FILENAME_MAX + 1];

    APPEND_STAR_DOT_STAR(dir_name, dir->name);
    if (findfirst(dir_name, &dir->ff, FA_ARCH|FA_RDONLY|FA_DIREC)
	|| strcmp(dir->ff.ff_name, "."))
    {
      dir->need_fake_dot_dotdot = 2;

      /* Restore errno in certain cases. findfirst() will fail for empty
	 root directories on drives, but this should not be considered
	 an error. */
      if ((errno == ENOENT) || (errno == ENMFILE))
	errno = oerrno;
    }

    if (_USE_LFN && dir->ff.lfn_handle)
    {
      _lfn_find_close(dir->ff.lfn_handle);
      dir->ff.lfn_handle = 0;
    }
  }
}
