#! /bin/sh

echo "Output is in log.txt..."

{
#
#  Build library.
#

echo "Making the library..."
cd src
start_dir=$PWD
rm -f ./libsupp.a

cat > gcc.opt << _EOF
-MD
-O2
-mtune=i586
-march=i386
-Werror
-Wall
-Wbad-function-cast
-Wcast-qual
-Wmissing-declarations
-Wmissing-prototypes
-Wpointer-arith
-Wshadow
-Wstrict-prototypes
-Wwrite-strings
-Wundef
-Wcast-align
-Wsign-compare
-nostdinc
-iquote .
-iquote ../../include
-iquote ../../../include
-iquote ../../../../include
-isystem /dev/env/DJDIR/include
_EOF

gcc_opt="$start_dir/gcc.opt"
src_dirs=
for src_dir in $(find . -maxdepth 1 -mindepth 1 -type d -and -not -name 'include'); do
  cd $src_dir
  for src_dir in $(find . -type d); do
    if [ -n "$(find $src_dir -maxdepth 1 -mindepth 1 -type f -and -name '*.c')" ]; then
      src_dirs="$src_dirs $PWD${src_dir/.\///}"
    fi
  done
  cd ..
done
for src_dir in $src_dirs; do
  cd $src_dir
  c_files=$(echo ./*.c)
  for file in $c_files; do
    echo "compiling $file..."
    gcc @$gcc_opt -c $file || exit 1
  done
done
cd $start_dir
echo
obj_files=$(find . -type f -and -name '*.o')
ar vsq ./libsupp.a $obj_files || exit 1
rm -f $(find . -type f -and -name '*.d') $obj_files ./gcc.opt
cd ..


#
#  Build info docs.
#

echo
echo
echo "Making the info docs..."
cd doc
rm -f ./libsupp.info
makeinfo --no-split ./libsupp.txi
cd ..


#
#  Run the testsuite.
#

echo
echo
echo "Running the test..."
cd tests
gcc -Wall -g -O0 test.c -o test.exe ./../src/libsupp.a

if [ -f ./test.exe ] && [ -x ./test.exe ]; then
  ./test.exe
else
  echo "Test failed..."
  exit 1;
fi
cd ..


#
#  Install library, header and info docs.
#
echo
echo
if [ $# -gt 0 ]; then
  prefix=$(echo "${start_dir}" | sed "s|srcs/contrib/libsupp-[0-9.]*/src|libs|")
else
  prefix="./_build_"
fi
echo "Installing the products in" $prefix
mkdir -p ${prefix}/info
mv -f ./doc/libsupp.info ${prefix}/info/libsupp.info
mkdir -p ${prefix}/include
cp -f ./include/libsupp.h ${prefix}/include/libsupp.h
mkdir -p ${prefix}/lib
mv -f ./src/libsupp.a ${prefix}/lib/libsupp.a
} &> log.txt
