/* gtr3Structures.h - header to gtr3Structures.c
*/
#if !defined(__ENH2__) && !defined(__GTR3__) && !defined(__VPL3__) && !defined(VPL3) && !defined(__FLN1__) && !defined(__SPY3__)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef GTR3_GTR3STRUCTURES_H
#define GTR3_GTR3STRUCTURES_H
/*****************************************************************Includes*/
#include <vpl3/gators.h>
/******************************************************V2 Type definitions*/
typedef struct _GTR2_GatorType { // used for conversion from V2 to V3
  short ID;             // 00h; Gator's ID
  short damage;         // 02h; Gator's damage
  short owner;          // 04h; Gator's owner
  short xCoord, yCoord; // 06h; Gator's coodinats
  short isMini;         // 0Ah; Is it a MiniGate (-1 = true)
  short reserved1;      // 0Ch; not implemented
  char  fCode[3];       // 0Eh; FCode
  short reserved2;      // 11h; not implemented
  short reserved3;      // 13h; not implemented
} GTR2_GatorType;       // 15h.
#define sizeOfOldGatorRecord 21

typedef struct _GTR2_ConfigType {
  short configVersion;  // 00h; High byte, version number;
                        // 01h; low byte subversion number
  short minNeutronium;  // 02h; Amount of Ne needed for a Gator
  short minTritanium;   // 04h; Amount of Tr needed for a Gator
  short minDuranium;    // 06h; Amount of Du needed for a Gator
  short minMolybdenum;  // 08h; Amount of Mo needed for a Gator
  short minSupplies;    // 0Ah; Amount of Su needed for a Gator
  short miniNeutronium; // 0Ch; Amount of Ne needed for a MiniGate
  short miniTritanium;  // 0Eh; Amount of Tr needed for a MiniGate
  short miniDuranium;   // 10h; Amount of Du needed for a MiniGate
  short miniMolybdenum; // 12h; Amount of Mo needed for a MiniGate
  short miniSupplies;   // 14h; Amount of Su needed for a MiniGate
  short protect[99];    // 16h; Protection for ancient Gators
  short reserved1;      // D2h; not implemented
  short towGators;      // D4h; Allow TowGator mission?
  short stealGators;    // D6h; Allow StealGator mission?
  short scanGators;     // D8h; Allow ScanGator mission?
  short upgradeGate;    // DAh; Allow Gators to be upgraded?
  short maxShips;       // DCh; Maximum allowed ships in the host (usually 500 but 999 is also possible)
} GTR2_ConfigType;      // DEh.
#ifndef compatibleVersion
#define compatibleVersion    0x0208 // V3 is compatible with V2.08 and later..
#endif // compatibleVersion
#define sizeOfOldGatorConfigRecord 222
/******************************************************V3 Type definitions*/
typedef struct _gatorType {
  short ID;              // Gator's ID
  short owner;           // Gator's owner, 12 if ancient
  short xCoord;          // Gators location
  short yCoord;
  short damage;          // Damage
  bool  isMini;          // Zero if Gator, nonzero if MiniGate
  bool  isReceiving;     // Zero by default.
  bool  isArmed;
  bool  isProtected;
  short UFOID;           // ID in UFO database
  char  friendlyCode[3]; // Friendly code
  short lockedShip;      // Ship towing the Gator
  short lockedFuel;      // ship's fuel at lock-on time
  bool  isFoldable;      // zero by default
  bool  isFolded;
  short crew;            // size of on-board crew for deployable Gators
  byte  fuel;
} gatorType;
#define sizeOfGatorRecord 28

typedef struct _gatorConfigType {
  short configVersion;    // hexVersion
  short neutronium;       // minerals needed to build a Gator
  short tritanium;
  short duranium;
  short molybdenum;
  short supplies;
  short miniNeutronium;   // minerals needed to build a MiniGate
  short miniTritanium;
  short miniDuranium;
  short miniMolybdenum;
  short miniSupplies;
  short armNeutronium;    // minerals needed to arm a Gator
  short armTritanium;
  short armDuranium;
  short armMolybdenum;
  short armSupplies;
  short upgradeNeutronium;// minerals needed to upgrade a MiniGate
  short upgradeTritanium;
  short upgradeDuranium;
  short upgradeMolybdenum;
  short upgradeSupplies;
  short repairGatorSupplies;
  short repairMiniGateSupplies;
  short switchNeutronium;
  short deployableNeutronium;// minerals needed to build a deployable Gator
  short deployableTritanium;
  short deployableDuranium;
  short deployableMolybdenum;
  short deployableSupplies;
  bool  buildGators;      // allow new gators to be built?
  bool  buildMiniGates;   // allow new minigates to be built?
  bool  gatorsDecay;      // do Gators and MiniGates naturally decay?
  bool  attackGators;     // allow Gators and MiniGates to be attacked?
  bool  repairGators;     // allow Gators and MiniGates to be repaired?
  bool  randomizeGators;  // allow gator numbers to be randomized?
  bool  towGators;        // allow tow gator mission?
  bool  stealGators;      // allow stealing Gators?
  bool  scanGators;       // allow scanning Gators?
  bool  upgradeGate;      // allow upgrading MiniGates
  bool  directChunnel;    // allow directly chunneling to a Gator
  bool  modeSwitch;       // allow switching the MiniGate's mode
  bool  armedGators;      // allow gators to attack enemy ships
  bool  warpedShips;      // allow warped ships
  bool  linkShip;         // allow linked universes
  bool  deployableGators; // allow deployable Gators
  bool  mannedGators;     // allow manned Gators
  bool  fuelStorage;      // allow Gators to store fuel
  long  universeID;       // new since version 3.2.0: unique ID of the universe
} gatorConfigType;
#define sizeOfGatorConfigRecord 78
#define oldDefaultGatorConfig {hexVersion,  1000,   150,   450,  1500,   500, \
                                             500,   150,   450,   350,   250, \
                                             500,   250,   900,   275,   375, \
                                             500,   150,   450,   350,   250, \
                                               5,     3,    50,  true,  true, \
                                            true,  true,  true,  true, false, \
                                            true,  true,  true, false, false, \
                                           false, false, false}

typedef struct _shipUFOType {
  short UFOID;                        // ship's ID
  short owner;
  short speed;                        // Speed of ship
  short xDisplacement, yDisplacement; // Displacement next turn (tan(bearing) = xDis/yDis)
  short xCoord, yCoord;               // Location of ship (xCoord, yCoord)
  short hullClass;                    // Class of ship (index in HULLSPEC.DAT)
  char  name[20];                     // Name of ship
  short mass;                         // Ship's mass
  short damage;                       // not saved - set to zero each time
} shipUFOType;
#define sizeOfShipUFORecord 38

typedef struct _linkShipType {
  short ID;
  short owner;
  char  fCode[3];
  short speed;
  short xDisplacement, yDisplacement;
  short xCoord, yCoord;
  short engineTech;
  short hullClass;
  short beamTech;
  short nBeamWeapons;
  short nFighterBays;
  short torpTech;
  short nTorps;
  short nTubes;
  short mission;
  short primeEnemy;
  short damage;
  short crew;
  short colonists;
  char  name[20];
  short neutronium;
  short tritanium;
  short duranium;
  short molybdenum;
  short supplies;
  short megaCredits;
} linkShipType;
#define sizeOfLinkShipRecord 107

typedef enum {
  v_error = 0,  // an error occured while checking
  v_true = 1,   // all is well
  v_yellow = 2, // repaired
  v_red = 3     // destroyed - unrepairable
} valid;
/***************************************************GTR2 Structure support*/
bool GTR2_gtr2Buf(char *buffer, GTR2_GatorType *gator);
bool GTR2_buf2Gtr(GTR2_GatorType *gator, char *buffer);
bool GTR2_cfg2Buf(char *buffer, GTR2_ConfigType* config);
bool GTR2_buf2Cfg(GTR2_ConfigType* config, char *buffer);
/***************************************************GTR2 Structure support*/
bool gtr2Buf(char *buffer, gatorType *gator);
bool buf2Gtr(gatorType *gator, char *buffer);
bool cfg2Buf(char *buffer, gatorConfigType *config);
bool buf2Cfg(gatorConfigType *config, char *buffer);
bool spu2Buf(char *buffer, shipUFOType *shipUFO);
bool buf2Spu(shipUFOType *shipUFO, char *buffer);
bool lnk2Buf(char *buffer, linkShipType *linkShip);
bool buf2Lnk(linkShipType *linkShip, char *buffer);
/************************************************GTR3 Structure validators*/
valid validateGatorRecord(gatorType *gator, short record);
/****************************************************************Exploders*/
bool explodeGator(gatorType *gator);
bool explodeShip(shipRecordType *ship);
bool explodeShipUFO(shipUFOType *shipUFO);
/**************************************************************************/
#endif // GTR3_GTR3STRUCTURES_H
