/* gtr3FileDispatchers.h - header to gtr3FileDispatchers.c
*/
#if !defined(__ENH2__) && !defined(__GTR3__) && !defined(__VPL3__) && !defined(VPL3) && !defined(__FLN1__) && !defined(__SPY3__)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef GTR3_GTR3FILEDISPATCHERS
#define GTR3_GTR3FILEDISPATCHERS
/*****************************************************************Includes*/
#include <vpl3/gators.h>
#include <vpl3/gtr3Structures.h>
/******************************************************************Defines*/
// filenames used by GTR3
#define oldGatorDBName       "GATOR.HST"
#define oldGatorConfigName   "GATOR.CFG"
#define gatorDBName          "GATORS.HST"
#define gatorConfigName      "GATORS.CFG"
#define linkName             "LINK.HST"
#define shipUFOName          "SHIPUFO.HST"
/******************************************************************Globals*/
// files for GTR2
extern FILE *GTR2_gatorFile, *GTR2_configFile;
// files for GTR3
extern FILE *gatorFile,
            *gatorConfigFile,
            *shipUFOFile,
            *linkShipFile,
            *linkShipXYFile;
// buffers
extern gatorType *gatorTable;
/*************************************************************File finders*/
bool existGTR2GatorDB(void);
bool existGTR2GatorConfig(void);
bool existGTR3GatorDB(void);
bool existGTR3GatorConfig(void);
short readGTRVersion(void);
/********************************************************GTR2 File openers*/
bool openGTR2GatorDB(void);
bool openGTR2Config(void);
/*************************************************************GTR2 Closers*/
bool closeGTR2GatorDB(void);
bool closeGTR2Config(void);
/*************************************************************GTR2 readers*/
bool readGTR2GatorRecord(GTR2_GatorType *gator, short record);
bool readGTR2Config(GTR2_ConfigType *config);
/*************************************************************GTR2 writers*/
bool writeGTR2GatorRecord(GTR2_GatorType *gator, short record);
bool writeGTR2Config(GTR2_ConfigType *config);
/**************************************************GTR2 to GTR3 convertors*/
bool GTR2Gtr2GTR3Gtr(gatorType *gtr3, GTR2_GatorType *gtr2);
bool GTR2Cfg2GTR3Cfg(gatorConfigType *cfg3, GTR2_ConfigType *cfg2);
bool renameGTR2ConfigFile(void);
bool renameGTR2GatorDB(void);
/***************************************************GTR3 File initializers*/
bool initGatorDB(void);
bool initGatorConfig(void);
bool initShipUFODB(void);
bool initLinkShipDB(void);
/********************************************************GTR3 File openers*/
bool openGatorDB(void);
bool openGatorConfig(void);
bool openShipUFODB(void);
bool openLinkShipDB(void);
/*************************************************************GTR3 Closers*/
bool closeGatorDB(void);
bool closeGatorConfig(void);
bool closeShipUFODB(void);
bool closeLinkShipDB(void);
/*************************************************************GTR3 readers*/
bool getGatorRecord(gatorType *gator, short record);
bool readGatorRecord(gatorType *gator, short record);
bool readGatorConfig(gatorConfigType *config);
bool readShipUFORecord(shipUFOType *shipUFO, short record);
bool readLinkShipRecord(linkShipType *linkShip, short record);
/*************************************************************GTR3 writers*/
bool putGatorRecord(gatorType *gator, short record);
bool writeGatorRecord(gatorType *gator, short record);
bool writeGatorConfig(gatorConfigType *config);
bool writeShipUFORecord(shipUFOType *shipUFO, short record);
bool writeLinkShipRecord(linkShipType *linkShip, short record);
/**************************************************************************/
#endif // GTR3_GTR3FILEDISPATCHERS

