/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Basic objects, General use mecanisms
	CommandNos : 1100..1199
	File       : Include/Mecanism/Object.H
	Author     : Eric NICOLAS
	Overview   : Basic object : Events, Selection, Data exchange
	UpDate     : Apr 01, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _MECANISM_OBJECT_H_
#define _MECANISM_OBJECT_H_

extern short RegTObject;
extern char *IdentTObject;

// What's in Options

// :: Global
#define opDrawable       0x0001
#define opSelectable     0x0002
#define opChangeAreaWait 0x0004
#define opGetAllEvents   0x0008
#define opCSLoX          0x0010
#define opCSLoY          0x0020
#define opCSHiX          0x0040
#define opCSHiY          0x0080
#define opCSAll          0x00F0
// :: Standard Windows
#define opWinSizeable    0x0100
#define opWinCloseBox    0x0200
#define opWinMinimizeBox 0x0400
#define opWinMaximizeBox 0x0800
// :: Menus
#define opSeparator      0x1000
#define opMainMenu       0x2000
// :: EditLine
#define opEditBorder     0x4000

// What's in Status

// :: Global
#define sfMouseIn        0x0001
#define sfSelected       0x0002
#define sfDown           0x0004
#define sfVisible        0x0008
#define sfDisabled       0x0010
#define sfColorsOK       0x0020
#define sfModified       0x0040
// :: Menus
#define sfMenuChoiceDown 0x0080

// Global commands
#define cmSelect         1100
#define cmUnSelect       1101
// Standard FILE MENU commands
#define cmFileNew        1120
#define cmFileOpen       1121
#define cmFileSave       1122
#define cmFileSaveAs     1123
#define cmFileQuit       1124
#define cmQuit           1125

// ----- TObject

class TObject : public TAtom
{ DECLARE(TObject);
  public:
    long   ExitCode;
  protected:
    int    Status;
    int    Options;
    TEvent CurrentEvent;
  public:
  // Public Constructor
           TObject(void);
  // Creation / Destruction
           void Defaults(void);
  virtual  void InitAfterInsert(void);
  // Access to datas
           int      GetStatus(int StatusMask);
           void     SetStatus(int StatusMask);
           void     ClearStatus(int StatusMask);
           boolean  GetOptions(int OptionsMask);
           void     SetOptions(int OptionsMask);
           void     ClearOptions(int OptionsMask);
  // Events
  // :: Distributing events
          void     DealEvent(TEvent* Event);
          void     TreatEvent(TEvent *Event);
  virtual boolean  DispatchEvent(TEvent *Event);
  virtual void     HandleEvent(TEvent* Event);
  virtual void     GetEvent(TEvent* Event);
	       void     ClearEvent(TEvent *Event);
	       long     Exec(void);
  // :: Generating events
  virtual void     SetEvent(TEvent* Event);
	       void     SetCommand(long Command);
	       void     SetCommand(long Command, char  Info08b);
			 void     SetCommand(long Command, short Info16b);
			 void     SetCommand(long Command, long  Info32b);
	       void     SetCommand(long Command, void *InfoPtr);
  // :: Acting on events
  virtual boolean  KeyDown(int ScanCode, int Toggle);
  // Selections
  virtual void     Select(void);
  virtual void     UnSelect(void);
			 void     SelectNext(void);
			 void     SelectPrevious(void);
  virtual boolean  Focus(void);
  // Linked lists
			 TObject* First(void);
          TObject* Last(void);
          TObject* Next(void);
          TObject* Previous(void);
          TObject* Son(void);
          TObject* Father(void);
  virtual void     Insert(TAtom* A);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
  // Data exchange
  virtual void     SetData(void *Ptr);
  virtual void     GetData(void *Ptr);
  virtual long     DataSize(void);
};

// Command tables macro definitions

#define DECLARE_EVENTS_TABLE                                            \
  virtual boolean DispatchEvent(TEvent *Event)

#define DEFINE_EVENTS_TABLE(a,b)     												\
  boolean a::DispatchEvent(TEvent *Event)                               \
  { if (b::DispatchEvent(Event))                                        \
      return TRUE;                                                      \

#define END_EVENTS_TABLE                                                \
	 return FALSE; }

#define COMMAND(cmID,function)                                          \
	if ((Event->What==evCommand)&&(Event->Command==cmID))                \
	  return function();

#define MOUSELDOWN()                                                    \
   if (Event->What==evMouseLDown)                                       \
     return MouseLDown(Event->Where,Event->Buttons);

#define MOUSERDOWN()                                                    \
   if (Event->What==evMouseRDown)                                       \
     return MouseRDown(Event->Where,Event->Buttons);

#define MOUSELUP()                                                      \
   if (Event->What==evMouseLUp)                                         \
     return MouseLUp(Event->Where,Event->Buttons);

#define MOUSERUP()                                                      \
   if (Event->What==evMouseRUp)                                         \
     return MouseRUp(Event->Where,Event->Buttons);

#define MOUSEDBLCLK()                                                   \
   if (Event->What==evMouseDblClk)                                      \
     return MouseDblClk(Event->Where,Event->Buttons);

#define MOUSEMOVE()                                                     \
   if (Event->What==evMouseMove)                                        \
     return MouseMove(Event->Where,Event->Buttons);

#define MOUSETEST()                                                     \
   if (Event->What==evMouseTest)                                        \
     return MouseTest(Event->Where,Event->Buttons);

#define KEYDOWN()                                                       \
   if (Event->What==evKeyDown)                                          \
     return KeyDown(Event->ScanCode,Event->KbStat);

#define TOGGLE()                                                        \
   if (Event->What==evToggle)                                           \
     return Toggle(Event->KbStat);

#define TIME()                                                          \
   if (Event->What==evTime)                                             \
     return Time();

#define DATE()                                                          \
   if (Event->What==evDate)                                             \
     return Date();

#define AUTO()                                                          \
   if (Event->What==evAuto)                                             \
     return AutoEvt();

// Inline functions

inline TObject* TObject::First(void)
{ return (TObject*)(TAtom::First());
}

inline TObject* TObject::Last(void)
{ return (TObject*)(TAtom::Last());
}

inline TObject* TObject::Next(void)
{ return (TObject*)(TAtom::Next());
}

inline TObject* TObject::Previous(void)
{ return (TObject*)(TAtom::Previous());
}

inline TObject* TObject::Son(void)
{ return (TObject*)(TAtom::Son());
}

inline TObject* TObject::Father(void)
{ return (TObject*)(TAtom::Father());
}

inline int TObject::GetStatus(int StatusMask)
{ return (Status & StatusMask);
}

inline void TObject::SetStatus(int StatusMask)
{ Status|=StatusMask;
}

inline void TObject::ClearStatus(int StatusMask)
{ Status&=~StatusMask;
}

inline boolean TObject::GetOptions(int OptionsMask)
{ return (boolean)((Options & OptionsMask)!=0);
}

inline void TObject::SetOptions(int OptionsMask)
{ Options|=OptionsMask;
}

inline void TObject::ClearOptions(int OptionsMask)
{ Options&=~OptionsMask;
}

#endif // _MECANISM_OBJECT_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   28/02/96 :EN: A step to a good model of Creating/Destructing objects
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
** ------------------------------------------------------------------------*/
