// Associated include file : Graphics/Mapping.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"

// ===== Variables locales

void InitMapping()
{ }

void DoneMapping()
{ }

// ===== TScreenBitmap

DEFINE(TScreenBitmap);

short RegTScreenBitmap;
char *IdentTScreenBitmap = "TScreenBitmap";

// Public Constructors

TScreenBitmap::TScreenBitmap()
{ Defaults();
}

TScreenBitmap::TScreenBitmap(int Width, int Height)
{ Defaults();
  Init(Width,Height);
}

// Creation / Destruction

void TScreenBitmap::Defaults(void)
{ // Object identification
  Register=RegTScreenBitmap;
  Ident=IdentTScreenBitmap;
  // Other defaults values
  W=H=0;
  GC=NULL;
}

void TScreenBitmap::Init(int Width, int Height)
{ // Herited creations
  TAtom::Init();
  // New creations
  W=Width;
  H=Height;
  GetMemory();
}

void TScreenBitmap::Done()
{ // Herited destructions
  TAtom::Done();
  // New destructions
  FreeMemory();
}

// Memory managment

void TScreenBitmap::NewSize(int Width, int Height)
{ if ((W!=Width) || (H!=Height))
  { FreeMemory();
	 W=Width; H=Height;
	 GetMemory();
  }
}

void TScreenBitmap::FreeMemory(void)
{ if (GC!=NULL) GrDestroyContext(GC);
}

void TScreenBitmap::GetMemory(void)
{ GC=NULL;
  if (W*H) GC=GrCreateContext(W,H,NULL,NULL);
}

// Put bitmap on the screen

void TScreenBitmap::Draw(int Xs, int Ys, int Xd, int Yd, int Wd, int Hd)
{ GrBitBlt(NULL,Xd,Yd,GC,Xs,Ys,Xs+Wd-1,Ys+Hd-1,GrWRITE);
}

void TScreenBitmap::Draw(int X, int Y)
{ GrBitBlt(NULL,X,Y,GC,0,0,W-1,H-1,GrWRITE);
}

void TScreenBitmap::BeginDraw(void)
{ GrSetContext(GC);
}

void TScreenBitmap::EndDraw(void)
{ GrSetContext(NULL);
}

void TScreenBitmap::Read(TDisk *file)
{ TAtom::Read(file);
  //
  int Wr,Hr;
  ReadInt(file,&Wr);
  ReadInt(file,&Hr);
  NewSize(Wr,Hr);
}

void TScreenBitmap::Write(TDisk *file)
{ TAtom::Write(file);
  //
  WriteInt(file,W);
  WriteInt(file,H);
}

// ===== TMapping

short RegTMapping;
char *IdentTMapping = "TMapping";

DEFINE(TMapping);

TMapping::TMapping()
{ Defaults();
}

TMapping::TMapping(int Width, int Height, char *Description)
{ Defaults();
  Init(Width,Height,Description);
}

void TMapping::Defaults(void)
{ // Object Identifications
  Register=RegTMapping;
  Ident=IdentTMapping;
  // Other default values
  Descr=NULL;
}

void TMapping::Init(int Width, int Height, char *Description)
{ // Herited Creations
  TScreenBitmap::Init(Width,Height);
  // New Creations
  if (Descr!=NULL)
    if (Description!=NULL) memcpy(Descr,Description,W*H);
                      else memset(Descr,0,W*H);
}

void TMapping::FreeMemory(void)
{ TScreenBitmap::FreeMemory();
  //
  SafeDelete(Descr);
}

void TMapping::GetMemory(void)
{ TScreenBitmap::GetMemory();
  //
  int size=W*H;
  Descr=NULL;
  if (size) SafeNew(Descr,char[size]);
}

void TMapping::DoMapping(TColor *ColorTable)
{ if ((Descr!=NULL)&&(GC!=NULL))
  { int i,j;
    BeginDraw();
    for(j=0;j<H;j++)
      for(i=0;i<W;i++)
        GrPlot(i,j,ColorTable[Descr[i+j*W]]);
    EndDraw();
  }
}

void TMapping::SetColorGroup(char )
{ }

void TMapping::Read(TDisk *file)
{ TScreenBitmap::Read(file);
  file->Read(Descr,W*H);
}

void TMapping::Write(TDisk *file)
{ TScreenBitmap::Write(file);
  file->Write(Descr,W*H);
}

// ===== TSysIcone

short RegTSysIcone;
char *IdentTSysIcone = "TSysIcone";

DEFINE(TSysIcone);

TSysIcone::TSysIcone(void)
{ Defaults();
}

TSysIcone::TSysIcone(int Width, int Height, char *Description)
{ Defaults();
  Init(Width,Height,Description);
}

void TSysIcone::Defaults(void)
{ // Object Identification
  Register=RegTSysIcone;
  Ident=IdentTSysIcone;
  // Other default values
}

void TSysIcone::Init(int Width, int Height, char *Description)
{ // Herited creations
  TMapping::Init(Width,Height,Description);
  // New Creations
  DoMapping(NoSysColor);
}

void TSysIcone::Read(TDisk *file)
{ TMapping::Read(file);
  DoMapping(NoSysColor);
}

void TSysIcone::Write(TDisk *file)
{ TMapping::Write(file);
}

// ===== TMappingObject

short RegTMappingObject;
char *IdentTMappingObject = "TMappingObject";

DEFINE(TMappingObject);

TMappingObject::TMappingObject()
{ Defaults();
}

TMappingObject::TMappingObject(int X, int Y, TMapping *_Mapp, boolean _DeleteMapp)
{ Defaults();
  Init(X,Y,_Mapp,_DeleteMapp);
}

void TMappingObject::Defaults(void)
{ // Object identification
  Register=RegTMappingObject;
  Ident=IdentTMappingObject;
  // Other default values
  Mapp=NULL;
  DeleteMapp=FALSE;
}

void TMappingObject::Init(int X, int Y, TMapping *_Mapp, boolean _DeleteMapp)
{ // Herited Creations
  TZone::Init(X,Y,X+_Mapp->Width()-1,Y+_Mapp->Height()-1);
  // New Creations
  Mapp=_Mapp;
  DeleteMapp=_DeleteMapp;
}

void TMappingObject::Done(void)
{ if (Mapp!=NULL)
    if (DeleteMapp) delete Mapp;
  TZone::Done();
}

void TMappingObject::Draw(TRect )
{ if (Mapp!=NULL)
    Mapp->Draw(Corner.X(),Corner.Y());
}