// Associated include file : Drivers/Disk.H

#include "common/common.h"
#include "drivers/drivers.h"

void TDisk::Open(char* Name, int Acces)
{ char Buffer[300];
  FixPath(Buffer,Name,300);
  char Access[10];
  switch(Acces & (stCreate | stOpen))
  { case stCreate :
      strcpy(Access,"w");
      break;
    case stOpen :
      strcpy(Access,"r");
      break;
    default :
      Error=erDiskAccess_Open;
      return;
  }
  if (Acces & stTextMode) strcat(Access,"t");
                     else strcat(Access,"b");
  if ((FileHandle=fopen(Buffer,Access))==NULL) Error=erDiskAccess_Open;
}

void TDisk::Close(void)
{ if (!Error)
    if (fclose(FileHandle)) Error=erDiskAccess_Close;
}

void TDisk::Write(void* Buffer, int Size)
{ if (!Error)
    if (fwrite((char*)Buffer,1,Size,FileHandle)!=Size) Error=erDiskAccess_Write;
}

void TDisk::Read(void* Buffer, int Size)
{ if (!Error)
  { LastRead=fread((char*)Buffer,1,Size,FileHandle);
    if (LastRead!=Size)
      if (LastRead) Error=erDiskAccess_EOF;
				  else Error=erDiskAccess_Read;
  }
}

// ------------------------------------------------------------------------

long TDisk::Seek(long Depl, char Mode)
{ if (!Error)
    if (fseek(FileHandle,Depl,Mode))
    { Error=erDiskAccess_Seek;
      return 0L;
    }
    else return Depl;
  return 0L;
}

long TDisk::Position(void)
{ return ftell(FileHandle);
}

void TDisk::ReadLn(char *Buffer, int MaxLength)
{ if (!Error)
    if (fgets(Buffer,MaxLength,FileHandle)==NULL) Error=erDiskAccess_EOF;
    else
    { // Remove \n char from string
      char *P=strchr(Buffer,'\n');
      if (P!=NULL) *P=0;
    }
}

void TDisk::WriteLn(char *Buffer)
{ if (!Error) fprintf(FileHandle,"%s\n",Buffer);
}
