// Associated include file : Common/Basic.H

#include "common/common.h"
#include <time.h>
#include <ctype.h>

#ifdef _TURBOC_
  #include <alloc.h>
#endif

#ifdef _GNU_
  #ifndef _LINUX_
    #include <dpmi.h>
  #endif
#endif

#ifdef _MSDOS_
  #include <conio.h>
  #include <dos.h>
#endif

// Add the declaration for _fixpath which is declared in <dos.h> under
// DJGPP V2, but strangely is commented out.
#ifdef _DJGPP_
#ifdef _V2_
  extern "C" void _fixpath(const char *, char *);
#endif
#endif

// Global Vars

char   *ShortVersion  = "NoName";
char   *LongVersion   = "NoName Application. Please define ShortVersion & LongVersion !";
char   *SwordPath;
char   *AppPath;
char   *SwordVer      = "2.10";
char    PointChar     = ',';
boolean CursorIns     = TRUE;
char   *EndingMessage = "Thanks you for using SWORD, see you soon...";

// Local Vars

static char *Messages[1] =
		{ "Environement variable SWORDPATH missing"
		};

// Usefull Functions

//---------------------------------------------------------------------------
// ToAntiSlash

void ToAntiSlash(char *S)
{ char *P=S;
  while(*P)
  { if (*P=='/') *P='\\';
    P++;
  }
}

//---------------------------------------------------------------------------
// ToSlash

void ToSlash(char *S)
{ char *P=S;
  while(*P)
  { if (*P=='\\') *P='/';
	 P++;
  }
}

//---------------------------------------------------------------------------
// FixPath

void FixPath(char *Buffer, char *Path, int BufferLen)
{
#ifdef _TURBOC_
  ToAntiSlash(Path);
  _fullpath(Buffer,Path,BufferLen);
  ToSlash(Buffer);
#endif
#ifdef _DJGPP_
  _fixpath(Path,Buffer);
#endif
#ifdef _MSDOS_
  strlwr(Buffer);
#endif
}

//---------------------------------------------------------------------------
// Random

int Random(int Max)
{ 
#ifdef _SUNOS_
  return (int)((float)random()*Max/MaxInt);
#else
  return (int)((float)rand()*Max/RAND_MAX);
#endif
}

//---------------------------------------------------------------------------
// GetTime

#ifdef _SUNOS_
  #define CLOCKS_PER_SEC 1000000
#endif

long GetTime(void)
{ return (long)((float)clock()*100/CLOCKS_PER_SEC);
}

//---------------------------------------------------------------------------
// Delay

void Delay(long NCentSeconds)
{ long Dep=GetTime();
  do ;
  while(GetTime()-Dep<NCentSeconds);
}

//---------------------------------------------------------------------------
// Delay

void RemoveTABS(char *Str, int TabLength)
{ char Buffer[500];
  char TabFill[11]="          ";
  char *P=strchr(Str,'\t');
  TabFill[TabLength]=0;
  while(P!=NULL)
  { *P=0;
	 sprintf(Buffer,"%s%s%s",Str,TabFill,P+1);
	 strcpy(Str,Buffer);
	 P=strchr(Str,'\t');
  }
}

//---------------------------------------------------------------------------
// GetFreeMemory

void GetFreeMemory(unsigned long &PhysicalMemory, unsigned long &VirtualMemory)
{
#ifdef _TURBOC_
  PhysicalMemory=coreleft();
  VirtualMemory =0;
#endif
#ifdef _GNU_
  PhysicalMemory=_go32_dpmi_remaining_physical_memory();
  VirtualMemory =_go32_dpmi_remaining_virtual_memory(void);
#endif
}

//---------------------------------------------------------------------------
// strupr

#ifdef _UNIX_
  char *strupr(char *string)
  { char *P=string;
    while(*P)
    { *P=toupper(*P);
      P++;
    }
    return string;
  }
#endif

//---------------------------------------------------------------------------
// strlwr

#ifdef _UNIX_
  char *strlwr(char *string)
  { char *P=string;
    while(*P)
    { *P=tolower(*P);
      P++;
    }
    return string;
  }
#endif

// ===== Local Errors Handling ==============================================

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erSWORDPATHmissing:    MessageNo=0;   break;
	 default:
		return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

// ===== Init/Done de l'unit ===============================================

//---------------------------------------------------------------------------
// InitBasic

void InitBasic(char *Arg)
{ Debug("BEGIN: InitBasic\n");
  DebugIncrement();
  AddErrorHandler(ErrorMessages);
  //
  char *Tmp;
  SwordPath=(char*)SafeMAlloc(300);
  AppPath=(char*)SafeMAlloc(300);
  if (Error) ErrorViewer();
  Tmp=getenv("SWORDPATH");
  if (Tmp==NULL)
  { Error=erSWORDPATHmissing;
    ErrorViewer();
  }
  FixPath(SwordPath,Tmp,300);
  FixPath(AppPath,Arg,300);
  // Enleve eventuellement le / a la fin de SwordPath
  Tmp=SwordPath+strlen(SwordPath)-1;
  if (*Tmp=='/') *Tmp=0;
  // Enleve le nom de l'application a la fin de AppPath
  Tmp=AppPath+strlen(AppPath)-1;
  while(*Tmp!='/') Tmp--;
  *Tmp=0;
  // Affiche les infos d'initialisation
  printf("\n");
#ifdef _MSDOS_
  textattr(0x1E);clreol();
#endif
  printf("%s\n",LongVersion);
#ifdef _MSDOS_
  textattr(0x07);clreol();
#endif
  printf("\n");
  printf("##### S.W.O.R.D  V%s\n",SwordVer);
  printf("##### Copyright (C) 1993-1996 The SWORD Group\n");
  printf("##### %s version.\n",SYSTEM);
  printf("##### Library compiled on %s, at %s\n\n",__DATE__,__TIME__);
  printf("Paths to system areas : SwordPath      = %s\n",SwordPath);
  printf("                        AppPath        = %s\n",AppPath);
  // Sortie des infos sur le dbug pour trace.
  Debug("SwordPath      = %s\n",SwordPath);
  Debug("AppPath        = %s\n",AppPath);
  DebugDecrement();
  Debug("END: InitBasic\n");
}

//---------------------------------------------------------------------------
// DoneBasic

void DoneBasic(void)
{ SafeFree((void**)(&SwordPath));
  SafeFree((void**)(&AppPath));
  // Message de sortie
  printf(
  "                         -----------------------------\n"
  "                          S   .  W  .  O  .  R  .   D \n"
  "                          System  of Windows for  the \n"
  "                          ORganisation of the Desktop \n"
  "                         -----------------------------\n"
  "\n"
  "-------------------------------------------------------------------------------\n"
  "  For all informations :               Version : V%s Apr 1996\n"
  "    Eric NICOLAS                       Copyright (C) 1993-1996 The SWORD Group\n"
  "    11 Allee du parc G. Pompidou                                              \n"
  "    38100 GRENOBLE                                                            \n"
  "    FRANCE                             E-mail: nicolas@dsys.ceng.cea.fr       \n"
  "-------------------------------------------------------------------------------\n\n\n",
  SwordVer);
  printf("%s\n",EndingMessage);

  Debug("BASIC...     Closed.\n");
}
