/*************************************************************
 ******************    ===STEP3.EXE===    ********************
 *************************************************************
      Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> STEP3.H
 -> Declarations for the third tutorial step.
*/

#ifndef _step3_h
#define _step3_h

#include <tws/system.h>
#include <tws/menu.h>

#define ID_SEPERATOR    -1

#define ID_FILE_NEW     1
#define ID_FILE_EXIT    2

PopupMenuRes FileMenuRes[]={
   {"&New",ID_FILE_NEW,0,0},
   {NULL,ID_SEPERATOR,0,0},
   {"E&xit",ID_FILE_EXIT,0,0}
};

#define NO_FILE_ITEMS 3

MenuRes MainMenuRes[]={
   {"&File",NO_FILE_ITEMS,FileMenuRes},
};

class MainMenu:public AutoMenu {
   public:
      MainMenu(Window *parent,int x,int y,int w)
         :AutoMenu(parent,MainMenuRes,1,x,y,w)
         {};

   protected:

      void CmFileNew();
      void CmFileExit();

      DECLARE_RESPONSE_TABLE;
};

class MainMenuWindow:public Window {
   public:
      MainMenuWindow()
         :Window(NULL,NULL,0,0,ws.GetTopWindow()->GetWidth()-1,SysFont->height+FWIDTH*2+4,WA_VISABLE | WA_BORDER)
      {
         menu=new MainMenu(this,FWIDTH+2,FWIDTH+2,w-FWIDTH*2-5);
      }
      ~MainMenuWindow();

   private:
      MainMenu *menu;
};

class DrawWindow:public Window {
   public:
      DrawWindow(int x1,int y1,int x2,int y2)
         :Window(NULL,"Drawing Window",x1,y1,x2,y2,WA_VISABLE | WA_SAVEAREA | WA_CAPTION | 
                           WA_SIZEABLE | WA_BORDER | WA_MAXBOX | WA_SYSBOX)
         {}

   protected:

      void CmSysBox();
      void LButtonDown(int x,int y,int kb_stat);
      void MouseMove(int x,int y,int kb_stat,int mb_stat);

      DECLARE_RESPONSE_TABLE;

      int isDrawing;
      int lastx,lasty;
};


#endif
