/*************************************************************
 ******************    ===STEP3.EXE===    ********************
 *************************************************************
		Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> STEP3.CC
 -> Third tutorial step.
*/

#include "step4.h"
#include <tws/button.h>

DEFINE_RESPONSE_TABLE(MainMenu,AutoMenu)
	E_COMMAND(ID_FILE_NEW,CmFileNew)
	E_COMMAND(ID_FILE_EXIT,CmFileExit)
END_RESPONSE_TABLE

					// The destructor for the main menu window.
MainMenuWindow::~MainMenuWindow()
{
	delete menu;
}

void
MainMenu::CmFileNew()
{
	Window *temp=new DrawWindow(50,50,250,200);
	temp->Paint();
	temp->RefreshWindow();
}

void
MainMenu::CmFileExit()
{
	ws.StopRunningEvents();
}

DEFINE_RESPONSE_TABLE(DrawWindow,Window)
	E_BUTTONUP(ID_SYSBOX,CmSysBox)
	E_LBUTTONDOWN
	E_MOUSEMOVE
END_RESPONSE_TABLE;

void
DrawWindow::CmSysBox()
{
	ws.QueueEvent(parent,event(W_REMOVE_CHILD,(int)this));
}

void
DrawWindow::LButtonDown(int x,int y,int kb_stat)
{
	x-=absx;             // Make relative to window.
	y-=absy;             // Make relative to window.
	if(x>=cx1 && x<=cx2 && y>=cy1 && y<=cy2)
	{
		lastx=x-cx1;
		lasty=y-cy1;
	}
}

void
DrawWindow::MouseMove(int x,int y,int kb_stat,int mb_stat)
{
	if(mb_stat&MBS_LEFT_BUTTON)
	{
		ViewBuffer *temp=GetClientBuffer();
		Line(temp,lastx,lasty,x-absx-cx1,y-absy-cy1,0);
		DeleteBuffer(temp);
		RefreshWindow(MIN(lastx+absx+cx1,x),MIN(lasty+absy+cy1,y),MAX(lastx+absx+cx1,x),MAX(lasty+absy+cy1,y));
		lastx=x-absx-cx1;
		lasty=y-absy-cy1;
	}
}

void main(int argc,char *argv[])
{
	char *temp;

	ws.Init("tutorial.cfg");   // Initialise the system with tutorial.cfg

	MainMenuWindow Main;       // Create the main menu window (and menu)

	ws.RefreshDesktop();       // Refresh (draw) the desktop

	ws.RunEvents();            // Start up the system event handling loops
}  

