/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> HELP.H
 -> HelpWindow and related classes for handling help files. 
*/

#ifndef _help_h
#define _help_h

#include <types.h>
#include <stdio.h>
#include <string.h>
#include <tws/scrolwin.h>
#include <tws/button.h>

class HelpTopic {
   public:
      HelpTopic(char*,int,int&);
      ~HelpTopic();

      inline int GetLength()
         { return length; }
      inline char *GetText()
         { return text; }
      inline int isTopic(const char *n)
         { return (strcmp(n,name)==0); }
      inline char *TopicName()
         { return name; }
      int GetHeight(int width);

   protected:
      char *name;
      char *text;
      int length;
};

class HelpDataBase {
   public:
      HelpDataBase(const char *filename);
      HelpDataBase(char *text,int length);
      ~HelpDataBase();

      HelpTopic *GetTopic(const char *name);

   protected:
      HelpTopic **topics;
      int len,ntopics;
};

#define ID_CONTENTS  1000
#define ID_BACK      1001

class HelpWindow:public ScrollingWindow {
   public:
      HelpWindow(Window*,HelpDataBase*,const char*,int,int,int,int);
      ~HelpWindow();

      void Setup(int pos=0);
   protected:
      void PaintWindow(int,int,int,int);
      void LButtonDown(int,int,int);
      void SysBox();
      void CmContents();
      void CmLastTopic();
      void Resize(int,int,int,int);
      void KeyUp(int);
      void KeyDown(int);

      HelpDataBase *hdb;
      HelpTopic *topic,*last[10];
      int last_pos[10];
      TextButton *back,*contents;
      int nhot_spots,len;
      char **names;
      int *x;
      int *y;
      int *l;
      ViewBuffer *hbuf;

      DECLARE_RESPONSE_TABLE;
};



#endif
