/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> FILEDLG.H
 -> FileDialog class for a file dialog box.
*/

#ifndef _filedlg_h
#define _filedlg_h

#include <stdio.h>
#include <tws/button.h>
#include <tws/tabwin.h>
#include <tws/edit.h>
#include <tws/scrolwin.h>


#define E_FILELIST(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==3000) \
   { \
      function(); \
      return TRUE; \
   }

#define E_FILELISTSELECT(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==3001) \
   { \
      function(); \
      return TRUE; \
   }


class FileList:public ScrollingWindow {
   public:
      FileList(Window *parent,ControlID ID,int x1,int y1,int x2,int y2);
      ~FileList();
      int GetDrive() {return drive;}
      char *GetDir() {return dir+(drive<<8);}
      char *GetName();
      void KeepPath();

   protected:
      void PaintWindow(int,int,int,int);
      void FillList();              // Fills the list.
      void AddItem(int type,int indent,char *name);
      void SelectItem(int n);
      void LButtonDown(int,int,int,int);
      void KeyUp(int);
      void KeyDown(int);
      void KeyEnter(int);
      void Focus();
      void UnFocus();
      inline int ItemLength(int n)
         {return 42+StringWidth(item_name[n],SysFont)+item_indent[n]*22;}
      
      int drive,selected,focused;
      char dir[6656];
      int nitems,len;
      int *item_type;
      int *item_indent;
      char **item_name;
      ControlID ID;

      DECLARE_RESPONSE_TABLE;
};

#define IDFILELIST 4
#define IDFILENAME 5

class FileDlg:public TabWin {
   public:
      FileDlg(const char *title,const char *name=NULL);
      ~FileDlg();

      char *Run();      // returns an allocated string which must be deleted.

   private:
      void CmOK();
      void CmCancel();
      void SelectFile();
      void ChangeFile();

      TextButton *OK,*Cancel;
      EditText *filename;
      FileList *filelist;
      BOOL isOK;

      DECLARE_RESPONSE_TABLE;
};


void SetupFileListDrivesDirectories();


#endif
