/*
  This file was created using sys/socket.h from Watt32 project.
*/
/*
 * Copyright (c) 1982, 1986, 1990, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)in.h        8.3 (Berkeley) 1/3/94
 * $Id: in.h,v 1.22.2.1 1996/11/11 23:40:37 phk Exp $
 */

#ifndef _SYS_SOCKET_H_
#define _SYS_SOCKET_H_

#undef FD_SETSIZE
#define FD_SETSIZE 64 
#include <sys/types.h>

#define MAX_SOCKETS FD_SETSIZE
#define FD_MASK    ((FD_SETSIZE / 8) + (FD_SETSIZE % 8 == 0 ? 0 : 1))

/* Socket types supported */

#define SOCK_STREAM     1               /* stream socket */
#define SOCK_DGRAM      2               /* datagram socket */

/* Option flags per-socket. */

#define SO_DEBUG        0x0001          /* turn on debugging info recording */
#define SO_REUSEADDR    0x0004          /* allow local address reuse */
#define SO_KEEPALIVE    0x0008          /* keep connections alive */
#define SO_DONTROUTE    0x0010          /* just use interface addresses */
#define SO_BROADCAST    0x0020          /* permit sending of broadcast msgs */
#define SO_LINGER       0x0080          /* linger on close if data present */
#define SO_OOBINLINE    0x0100          /* leave received OOB data in line */

#define SO_DONTLINGER   (int)(~SO_LINGER)

/* Only ioctl flags supported */

#define FIONBIO        1
#define FIONREAD       2

/* Address families supported */

#define AF_UNSPEC       0
#define AF_INET         2

/* Maximum queue length specifiable by listen. */

#define SOMAXCONN       5

#define MSG_PEEK        2             /* peek at incoming message */
#define MSG_PUSH        4

/* Structure used by kernel to store most addresses. */
struct sockaddr {
  unsigned short sa_family;              /* address family */
  char    sa_data[14];            /* up to 14 bytes of direct address */
};

/* Structure used by kernel to pass protocol information in raw sockets. */
struct sockproto {
  unsigned short sp_family;              /* address family */
  unsigned short sp_protocol;            /* protocol */
};

#include <sockdefs.h>

#endif
