/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wctrans.c,v 1.1 1996/10/27 13:23:30 jack Exp $ */

#include <stddef.h>
#include <string.h>
#include <wctype.h>
#include <wcprvt.h>

wctrans_t
wctrans (const char *property)
{
  int l, m, r;
  int s;
  int c1, c2;

  if (property == NULL)
    return (wctrans_t) 0;

  l = 0; /* left(start) point */
  m = 0; /* middle point */
  r = __wcprops_trans_num - 1; /* right(end) point */
  c2 = *(unsigned char *) property;

  /* binary search */
  while (l <= r)
    {
      m = (l + r) / 2;
      c1 = *(unsigned char *) __wcprops_trans[m]->name;
      s = c1 - c2;
      if (s == 0)
	s = strcmp (__wcprops_trans[m]->name, property);
      if (s < 0)
	l = m + 1;
      else if (s > 0)
	r = m - 1;
      else
	return (wctrans_t) (m + 1);
    }

  /* not found */
  return (wctrans_t) 0;
}
