/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcstoul.c,v 1.2 1996/07/14 10:04:37 jack Exp $ */

#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <wchar.h>
#include <wctype.h>

#define WC(c) ((wchar_t) (c))

unsigned long int
wcstoul (const wchar_t *ws, wchar_t **endptr, int base)
{
  const wchar_t *wtop = ws;
  const wchar_t *save;
  unsigned long int value = 0;
  unsigned long int ud, um;
  int sign = 0;
  int overflow = 0;
  wchar_t wc;

  /* skip white space */
  while ((wc = *ws++))
    if (! iswspace (wc))
      break;

  /* get sign */
  switch (wc)
    {
    case WC ('-'):
      sign = -1;
    case WC ('+'):
      wc = *ws++;
    }

  /* examine base and skip 0x */
  if (base == 0 || base == 16)
    {
      if (wc == WC ('0'))
	{
	  if ((*ws == WC ('x')) || (*ws == WC ('x')))
	    {
	      ws++;
	      wc = *ws++;
	      base = 16;
	    }
	  else if (base == 0)
	    base = 8;
	}
      else if (base == 0)
	base = 10;
    }

  /* make limit value */
  ud = ULONG_MAX;
  um = ud % (unsigned long) base;
  ud = ud / (unsigned long) base;

  /* get value */
  for (save = ws; wc != 0; wc = *ws++)
    {
      register int c;

      if (! iswascii (wc))
	break;

      c = (int) wc;
      if (isdigit (c))
	c -= '0';
      else if (isupper (c))
	c -= 'A' - 10;
      else if (islower (c))
	c -= 'a' - 10;
      else
	break;

      if (c >= base)
	break;

      if (! overflow)
	{
	  if (value < ud || (value == ud && c <= um))
	    {
	      value *= base;
	      value += c;
	    }
	  else
	    overflow = 1;
	}
    }

  if (endptr != NULL)
    *endptr = (wchar_t *) ((save != ws) ? ws - 1 : wtop);

  if (overflow)
    {
      errno = ERANGE;
      return ULONG_MAX;
    }

  return (unsigned long int) ((sign < 0) ? -value : value);
}
