/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcsncat.c,v 1.2 1996/07/13 20:09:36 jack Exp $ */

#include <wchar.h>

wchar_t *
wcsncat (wchar_t *wd, const wchar_t *ws, size_t n)
{
  wchar_t *top = wd;

  if (n == 0)
    return top;

  while (*wd++ != 0)
    ;
  --wd;

  while (n > 0)
    {
      if ((*wd++ = *ws++) == 0)
	break;
      n--;
    }

  while (n-- > 0)
    *wd++ = 0;

  return top;
}
