/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: putws.c,v 1.1 1996/07/16 15:34:38 jack Exp $ */

#include <stdio.h>
#include <wchar.h>
#include <wcprvt.h>

int
putws (const wchar_t *ws)
{
  wchar_t wc;
  __WCHAR_BINARYMODE_VARIABLES;

  __WCHAR_BINARYMODE_PROLOGUE (stdout);

  while ((wc = *ws++) != 0)
    {
      if (__fputwc (wc, stdout) == WEOF)
	{
	  __WCHAR_BINARYMODE_EPILOGUE (stdout);
	  return -1;
	}
    }

  /* append newline */
  if (__fputwc ((wchar_t) '\n', stdout) == WEOF)
    {
      __WCHAR_BINARYMODE_EPILOGUE (stdout);
      return -1;
    }

  __WCHAR_BINARYMODE_EPILOGUE (stdout);

  return 0;
}
