/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbstok.c,v 1.1 1996/07/01 19:16:21 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

unsigned char *
_mbstok (unsigned char *us, const unsigned char *udlm)
{
  static unsigned char *next = NULL;
  unsigned char *beginp, *endp;
  size_t bytes;

  /* continue ? */
  if (us == NULL)
    {
      if (next == NULL)
	return NULL;
      us = next;
    }

  /* skip delimiter */
  beginp = _mbsspnp (us, udlm);
  if (beginp == NULL)
    {
      next = NULL;
      return NULL;
    }

  /* search delimiter */
  endp = _mbspbrk (beginp, udlm);
  if (endp == NULL)
    next = NULL;
  else
    {
      /* cut off token */
      bytes = _mbclen (endp);
      while (bytes-- > 0)
	*endp++ = '\0';

      /* save pointer */
      next = endp;
    }

  return beginp;
}
