/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsnbcnt.c,v 1.1 1996/07/01 19:14:54 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

size_t
_mbsnbcnt (const unsigned char *us, size_t n)
{
  size_t bytes;
  size_t total = 0;

  /* count bytes of string */
  while (n > 0)
    {
      bytes = _mbclen (us);
      if (bytes == 1)
	{
	  if (*us == '\0')
	    break;
	}
      us += bytes;
      total += bytes;
      n--;
    }

  return total;
}
