/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _jpsjcnv.c,v 1.3 1996/10/25 14:03:58 jack Exp $ */

#include <stddef.h>
#include <mbprvt.h>

/* ja_JP.SJIS locale definitions */
/* mapping table generated by __mbinit() */
unsigned short *__sjis_to_unicode_mapping = NULL;
unsigned short *__unicode_to_sjis_mapping = NULL;

/* num of max characters in multibyte */
const int __mb_cur_max_ja_jp_sjis = 2;

/* convert functions */
wchar_t
__string_single_to_wchar_ja_jp_sjis (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis, unicode;

  /* get sjis value */
  sjis = (unsigned short) us[0];

  /* convert to UNICODE */
  unicode = __sjis_to_unicode_mapping[sjis];

  /* error ? */
  if (unicode == _MBC_ERROR_UNICODE)
    return _MBC_ERROR_WCHAR;

  /* return result */
  return (wchar_t) unicode;
}

wchar_t
__string_double_to_wchar_ja_jp_sjis (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis, unicode;

  /* get sjis value */
  sjis = (unsigned short) ((us[0] << 8) + us[1]);

  /* convert to UNICODE */
  unicode = __sjis_to_unicode_mapping[sjis];

  /* error ? */
  if (unicode == _MBC_ERROR_UNICODE)
    return _MBC_ERROR_WCHAR;

  /* return result */
  return (wchar_t) unicode;
}

int
__wchar_to_mbc_ja_jp_sjis (wchar_t wc)
{
  unsigned short sjis, unicode;

  /* check range */
  if (wc < 0 || wc > 0xffffU)
    return _MBC_ERROR_CODE;

  /* get unicode value */
  unicode = (unsigned short) wc;

  /* convert to Shift-JIS */
  sjis = __unicode_to_sjis_mapping[unicode];

  /* error ? */
  if (sjis == _MBC_ERROR_SJIS)
    return _MBC_ERROR_CODE;

  /* return result */
  return (int) sjis;
}
