// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include "XHandler.H"
#include <X11/Xlib.h>
#include <X11/Xutil.h>

bool XHandler::tripped;
Display *XHandler::display;

int 
XHandler::handle(Display *, XErrorEvent *)
{
    tripped = true;
    return 0;
}

void
XHandler::set( Display *dpy )
{
    display = dpy;
    tripped = false;
    XSetErrorHandler(handle);
}

bool
XHandler::reset()
{
    XSync(display,0);
    bool rc = tripped;
    tripped = false;
    return rc;
}

bool
XHandler::unset()
{
    XSync(display,0);
    XSetErrorHandler(0);
    return tripped;
}




