/**
 * $Id: Primitive.H,v 1.1 1996/12/16 06:54:53 keithw Exp $
 *
 * (c)1996 Hermetica. Written by Alligator Descartes <descarte@hermetica.com>
 *
 * $Log: Primitive.H,v $
 * Revision 1.1  1996/12/16 06:54:53  keithw
 * 0.1.8 Beta 3, really.
 *
 *
 */

#ifdef sun
#ifndef PI
#define PI M_PI
#endif
#endif

typedef enum cylicone_cap { CAP_NONE=0, CAP_TOP, CAP_BOTTOM, CAP_BOTH } cylicone_cap_t;
typedef enum primitive_orient { FACE_OUTSIDE=1, FACE_INSIDE, FACE_BOTH } primitive_orient_t;
typedef enum sphere_type { GEODESIC, LONGITUDINAL } sphere_type_t;
typedef enum tesselate_type { TRIANGULAR, POLYGONAL } tesselate_type_t;

extern Model *createCone( cylicone_cap_t, float, float, float );
extern Model *createCylinder( tesselate_type_t, cylicone_cap_t, float, float, float, float );
extern Model *createCylinder( tesselate_type_t, cylicone_cap_t, float, float, float );
extern Model *createCube( tesselate_type_t, primitive_orient_t, float, float, float );
extern Model *createSphere( sphere_type_t, tesselate_type_t, primitive_orient_t, float, float );
