#include "thread.h"
#include "switch.h"
#include "signal.h"
#include <stdlib.h>
#include <stdio.h>
#include "schedule.h"

#define STACKSIZE (4*1024)

struct thread * CreateThread(void (*torun) (void *), void *par)
{
int x;
struct sigaction * sig;

    struct thread *newthread;
    struct thread *foo;
    newthread = malloc(sizeof(struct thread));

    /* setup default signal handlers */
    /* malloc it so it wont dissapear when leaving this function */
    /* remalloc before each call to sigaction  the call to sigaction
       will set the thread to point to sig so remallocing is not bad */

    newthread->stack=malloc(STACKSIZE * sizeof(int));        
    for(x=0; x<8; x++)
        newthread->regs[x]=1;
    newthread->threadstatus = CREATED;
    newthread->TID = gettid((struct thread *) -1);
    /* put the correct stack pointer and pc value in the reg array
       that will be moved into the real registers by SWITCH */
    newthread->regs[0]=(unsigned int) newthread->stack;
    *newthread->stack=(unsigned int) torun;

    AddToReady(newthread);
    return newthread;
}

void MakeMain(struct thread * tomake)
{
    current=tomake; 
}

void yield(void)
{
    struct thread *next;
    if(tobekilled!=0)
    {
        free(tobekilled);
        tobekilled=0;
        current=0;
    }
    next = GetNextThread();
    if(current!=0)
        AddToReady(current);
    if(next!=0 && next != NULL) 
        Start(next);
    else
    {
        exit(0);
    }
}

void KillThread(void)
{
     tobekilled=current;
     yield();
}

unsigned int gettid(struct thread *tidfor)
{
    if((unsigned int) tidfor == -1)
    {
        if(bigtid == MAXINT)
        {
            bigtid = 1;   /* 0 is reserved */
        }
        else
        {
            bigtid++;
        }
        return bigtid; 
    }
    else
    {
        return tidfor->TID;
    }
}
