// The DLX Symbol-Listing Utility V1.0
// Copyright (c) 1997, Nanosoft, Inc.
#include "dlx.h"
#include "iostream.h"
#include "stdio.h"
#include "malloc.h"

main(int argc, char** argv)
{
        if(argc==1)
        {
                cout << "DLX SymbolList V1.0" << endl;
                cout << "Copyright (c) 1997, Nanosoft, Inc." << endl << endl;
                cout << "Syntax:" << endl;
                cout << "       DLXLIST <filename> [filename]..." << endl;
        }
        dlxheader dh;
        for(long x=1; x<argc; x++)
        {
                FILE* myfile=fopen( argv[x], "rb" );
                if(myfile==NULL)
                {
                        cout << "File Not Found: " << argv[x] << endl;
                } else {
                        fread(&dh, 1, sizeof(dh), myfile);
                        if(dh.magic==DLX_MAGIC)
                        {
                                cout << "DLX V1.0/1.1/1.2: " << argv[x] << endl;
                                cout << "    Relocations: " << dh.numrelocs << endl;
                                cout << "    Program Size: " << dh.prgsize << endl;
                                cout << "    Imported Symbols: " << dh.numimports << endl;
                                long stlen;  char *str;
                                for(long l=0; l<dh.numimports; l++)
                                {
                                        fread(&stlen, sizeof(long),1,myfile);
                                        str=(char *)malloc(stlen);
                                        fread(str,sizeof(char),stlen,myfile);
                                        cout << "        Symbol: " << str << endl;
                                        free(str);
                                        fread(&stlen,sizeof(long),1,myfile);
                                        cout << "            Dependants: " << stlen << endl;
                                        str=(char *)malloc(sizeof(long)*stlen);
                                        fread(str,sizeof(long),stlen,myfile);
                                        free(str);
                                }
                        } else if(dh.magic==DLX2_MAGIC) {
                                cout << "DLX V2.0: " << argv[x] << endl;
                                cout << "    Relocations: " << dh.numrelocs << endl;
                                cout << "    Program Size: " << dh.prgsize << endl;
                                dlxiddesc did;
                                char plat[9]={0,0,0,0,0,0,0,0,0};
                                fread(plat,8,1,myfile);
                                fread(&did,sizeof(did),1,myfile);
                                cout << "    Build For:" << endl;
                                cout << "       " << plat << endl;
                                cout << "    Version Data:" << endl;
                                memcpy( plat, &(did.MFID), 8 );
                                cout << "        Manufacturer: " << plat << endl;
                                memcpy( plat, &(did.PRID), 8 );
                                cout << "        Product ID: " << plat << endl;
                                memcpy( plat, &(did.VTBL), 8 );
                                cout << "        Version: " << plat << endl;
                                cout << "        Unique ID: " << did.UNID << endl;
                                cout << "    Imported Symbols: " << dh.numimports << endl;
                                long stlen;  char *str;
                                for(long l=0; l<dh.numimports; l++)
                                {
                                        fread(&stlen, sizeof(long),1,myfile);
                                        str=(char *)malloc(stlen);
                                        fread(str,sizeof(char),stlen,myfile);
                                        cout << "        Symbol: " << str << endl;
                                        free(str);
                                        fread(&stlen,sizeof(long),1,myfile);
                                        cout << "            Dependants: " << stlen << endl;
                                        str=(char *)malloc(sizeof(long)*stlen);
                                        fread(str,sizeof(long),stlen,myfile);
                                        free(str);
                                }
                        }
                        fclose(myfile);
                }
        }
}
