/*
 Copyright (C) 1996 By Ilya P. Ryzhenkov, see COPYDLM.TXT for details
*/
#ifndef __include_helpdefs_h_
#define __include_helpdefs_h_

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#include <string.h>
//#include <mss.h>

#define DEFNEW(name,type) type *name=(type*)malloc(sizeof(type))
#define NEW(type) ((type*)malloc(sizeof(type)))
#define NEWAR(type,count) ((type*)malloc(sizeof(type)*count))
#define FREE(ptr) ((ptr?free(ptr):0),1)

#define READ(f,ptr,count) (((read(f,ptr,sizeof(*ptr)*count))!=(sizeof(*ptr)*count))?0:1)

#define DLM_ENOERR 0 /* No error */
#define DLM_ENOMEM 1 /* Not enough memory */
#define DLM_EFILE  2 /* File I/O error (check errno) */
#define DLM_EALOAD 3 /* DLM Already loaded */
#define DLM_ENODLM 4 /* DLM was not loaded */
#define DLM_ECTOR  5 /* DLM's constructor() returned zero */
#define DLM_EINVF  6 /* Not DLM file */
#define DLM_EAUTO  7 /* DLM Auto-Loading failed */
extern int dlmerrno;
#define ERR(e) dlmerrno=DLM_E##e

extern int dlmflags;
#define DLMFLAG_DUP 0x7 /* AND with this value to get/set duplicate export 
		           symbol handling scheme */
		           
#define DLMFLAG_DUP_IGNORE 0 /* Don't put duplicate exports to export
                                table at all. */
#define DLMFLAG_DUP_OVRIDE 1 /* Re-fixup all existing imports to the
                                new value and use it future. If DLM
                                unloads, reuse old values automaticaly.
                                This is default value. */
#define DLMFLAG_DUP_FUTURE 2 /* Use new value in future, leave already
                                defined as they are. If DLM
                                unloads, reuse old values automaticaly */
#define DLMFLAG_DUP_FAIL   3 /* Exit program on duplicate symbols. */


#endif

