/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 */
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#pragma pack(1)
#include <coff.h>
#pragma pack()
#include "dlm.h"

typedef unsigned short int Word;
typedef unsigned long int Long;
typedef unsigned char Byte;

typedef unsigned char *SCNDTA;

typedef struct tagDlm {
 char *filename;
 Word NumSect;
 Long NumSym;
 Long NumRel;
 Long StrSize;
 Long ScnOffs;
 DLMSCN *Sections;      /* Section headers */
 SCNDTA *SectData;
 char   *Base;             /* Base address for section data*/
 DLMSYM *Symbols;               /* Symbols */
 char   *Strings;               /* Symbol names (string table) */
 DLMREL *Relocs;                /* Relocation table */
 Long    VSize;
 Long    FSize;
} TDlm;

typedef struct tagCoff {
 Word NumSect;
 Long NumSym;
 Long SymOffset;
 SCNHDR *Sections;
 SCNDTA *SectData;
 SYMENT *Symbols;
 char *Strings;
 RELOC **Relocs;
} TCoff;

TCoff *LoadCoff(char *fname);
void DestroyCoff(TCoff *cf);
TDlm *coff2dlm(TCoff *cf);

TDlm *LoadDlm(char *fname);
void WriteDlm(TDlm *dl,char *fname,int appendflag);
void DestroyDlm(TDlm *dl);

void DumpDlm(TDlm *dlm,char *name);
void MakeExe(TDlm *dlm,char *fname,char *stub);

void AddSymbol(TDlm *dlm,char *name, char *fname);
void DelSymbol(TDlm *dlm,char *name);
void AddAutoLoad(TDlm *dlm,char *name);
void DelAutoLoad(TDlm *dlm,char *name);
void UpdateExport(TDlm *dlm,char *exp);
void DumpExport(TDlm *dlm,char *exp);
void DumpImport(TDlm *dlm,char *imp);
void DumpExportWithDLM(TDlm *dlm,char *exp);
void AddDAL(TDlm *dlm, char *name);
void GenerateDAL(TDlm *dlm,char *out,char *lst);
extern char quite;
