/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** SPRITE.H: This file is part of the BETATRON library and can be used
 **           and/or distributed only under the terms of the GNU Library
 **           General Public License. See doc/readme.1st for details.
 */



#ifndef sprite_h
#define sprite_h

#include <malloc.h>



struct TOworld;
struct TOobject;

typedef void (*TPaction) (TOobject *);

struct TOobject
  {
   friend TOworld;

   TOobject *Pnext;
   TOobject *Pprev;
   TOobject *Pnext2;
   TOobject *Pprev2;
   TOworld *owner;
   char framesbit;	   // 0: for TOobject objects 1: for descedants
   char visbit;
   char activebit;	   // 1: call the active action in every frame
					   // 0: call the active action only when visible
   char deadbit;	   // 1: freeze the object
   char deletebit;	   // 1: remove the sprite from the world & delete it
					   //	 in the next frame
   char removebit;	   // 1: only remove the sprite from the world in the
					   //	 next frame
  char rangeactivebit; // 1: TOworld calculates the inrangebit and uses it
					   //	 to call the active action
					   // 0: TOworld doesnot calculate the inrangebit.
					   //	 and doesnot use it to call the active action

   unsigned short rx1,
   ry1,rx2,ry2; 	   // the coordinates of the range box

   unsigned char type;
   unsigned short id;
   unsigned char priority;
   unsigned short x,y;
   signed char dx,dy;
   signed char gx,gy;
   unsigned long time;
   TPaction nextaction;
   unsigned short slen, shei;

   void setvisbit(char bit)  { visbit = bit; }
   char getvisbit() { return visbit ;}
   void setdeadbit(char bit) { deadbit = (bit!=0); }
   char getdeadbit() { return deadbit; }
   void setnext(TOobject *nxt) { Pnext = nxt; }
   TOobject *getnext() { return Pnext; }
   void setpriority(unsigned char priority0);
   unsigned char getpriority() { return priority ; };
   void setrange(unsigned short x0,unsigned short y0,unsigned short l0,
				 unsigned short h0);


   void init(unsigned char id0,unsigned short x0,
		 unsigned short y0,unsigned short slen0,unsigned short shei0);
	 ~TOobject();

	void callnext()
	{
	  if (nextaction) nextaction(this);
	};


   private:

   char oldvisbit;
 };





typedef TOobject *TOPobject;




struct TOsprite : public TOobject
 { friend TOworld;
   unsigned char staticbit;
   unsigned short framebase;
   signed short framenow;
   void init(unsigned char id0,unsigned short x0,
		 unsigned short y0,unsigned short slen0,unsigned short shei0,
			 signed short framenow0,unsigned short framebase0 = 0);

   private:

   unsigned short oldx,oldy,oldlen,oldhei;
   unsigned short clipx,clipy, cliplen, cliphei;

};



#include "world.h"

#endif
