#ifndef screen_sheet_header
#define screen_sheet_header

#include "line.h"

#define MAXROWS 50

class screen_sheet : public rectangle
{
public:
screen_sheet( int tlx, int tly, int width, int height );
screen_sheet();
~screen_sheet();

void draw_to( screen_sheet & other );
void draw_to_screen();
void copy( screen_sheet & other );
void copy_screen();
void fill( rectangle area, screen_char fill_char );
void fill();

virtual void resize( int new_width, int new_height );
virtual void resize_and_keep( int new_width, int new_height );
void move_to( int x, int y );

void put_text( const char * text, int y, char colour );
void put_text( const char * text, int x, int y, char colour );
void get_text( char * buffer,     int x, int y, int length );
void set_text( char character,    int x, int y, int length );

void set_colour( char colour,     int x, int y, int length );
void set_colour( char colour,     int x, int y );
void set_colour( char colour,     rectangle area );
void colour_from_to( char colour, point start, point end );
void colour_fill();

void set_character( char character );
char character() const { return _fill_char.character; }
void set_colour( char colour );
char colour() const { return _fill_char.colour; }

virtual void set_fill_char( char character, char colour );
screen_char fill_char() { return _fill_char; }

operator screen_line * () { return _image; }

screen_line * _image;

private:
screen_char _fill_char;

friend void resize_screen();
friend void clear_screen();
};

void fill_screen( int character, char attribute );
void update_screen();

#endif
