#include "overlap.h"

bool operator==( point one, point the_other )
{
   return ( one.x == the_other.x && one.y == the_other.y );
}

bool operator!=( point one, point the_other )
{
   return ( one.x != the_other.x || one.y != the_other.y );
}

point operator-( point one, point the_other )
{
   point p = { one.x - the_other.x,
               one.y - the_other.y };
   return p;
}

point operator+( point one, point the_other )
{
   point p = { one.x + the_other.x,
               one.y + the_other.y };
   return p;
}

point operator+=( point one, point the_other )
{
   one.x += the_other.x;
   one.y += the_other.y;
   return one;
}

point operator-=( point one, point the_other )
{
   one.x -= the_other.x;
   one.y -= the_other.y;
   return one;
}


line::line() {
   resize( 0, 0 );
   }

line::line( int start, int length ) {
   resize( start, length );
   }

line::line( line & model ) {
   resize( model._start, model._length );
   }

line & line::operator=( line model ) {
   _start = model._start;
   _end = model._end;
   _length = model._length;
   return *this;
   }

void line::resize( int new_length ) {
   _length = bigger_of( new_length, 0 );
   _end = _start + _length - 1;
   }

void line::resize( int start, int length ) {
   _start = start;
   _length = bigger_of( length, 0 );
   _end = _start + _length - 1;
   }

void line::move_to( int new_x ) {
   _start = new_x;
   _end = _start + _length - 1;
   }

bool line::overlaps( int x ) {
   return ( x >= _start && x <= _end );
   }

bool line::overlaps( line & other ) {
   return !( _end < other._start || _start > other._end );
   }

bool line::contains( int x ) {
   return overlaps( x );
   }

bool line::contains( line & other ) {
   return ( _start <= other._start && _end >= other._end );
   }

line line::overlap_with( line & other ) {
   line overlap;
   if( this -> overlaps( other ) ) {
      int new_start  = bigger_of( _start, other._start );
      int new_end    = smaller_of( _end, other._end );
      int new_length = new_start - new_end + 1;
      resize( new_start, new_length );
   }
   return overlap;
}

int  line::left()   { return _start; }
int  line::right()  { return _end; }
int  line::length()  { return _length; }

bool line::operator==( line & other ) {
   return ( _start == other._start && _length == other._length );
}


rectangle::
rectangle()
{
   move_to( 0, 0 );
   resize( 0, 0 );
}

rectangle::
rectangle( int tlx, int tly, int width, int length )
{
   move_to( tlx, tly );
   resize( width, length );
}


rectangle::
rectangle( rectangle & model )
{
   operator=( model );
}

rectangle & rectangle::
operator=( rectangle & model )
{
   _tl = model._tl;
   _br = model._br;
   _width = model._width;
   _height = model._height;

   return *this;
}

bool rectangle::
overlaps( int x, int y )
{
   return ( ( x >= _tl.x && x <= _br.x )
         && ( y >= _tl.y && y <= _br.y ) );
}

bool rectangle::
overlaps( point p ) { return overlaps( p.x, p.y ); }

bool rectangle::
overlaps( rectangle & other )
{
   return !( _br.x < other._tl.x
          || _tl.x > other._br.x
          || _br.y < other._tl.y
          || _tl.y > other._br.y );
}

bool rectangle::
contains( int x, int y ) { return overlaps( x, y ); }

bool rectangle::
contains( point p ) { return overlaps( p.x, p.y ); }

bool rectangle::
contains( rectangle & other )
{
   return overlaps( other._tl.x, other._tl.y )
       && overlaps( other._tl.x, other._tl.y );
}

rectangle rectangle::
overlap_with( rectangle & other )
{
   rectangle overlap;

   if( this -> overlaps( other ) )
   {
      int tlx = bigger_of(  _tl.x, other._tl.x );
      int tly = bigger_of(  _tl.y, other._tl.y );
      int width  = ( smaller_of( _br.x, other._br.x ) - tlx ) + 1;
      int height = ( smaller_of( _br.y, other._br.y ) - tly ) + 1;
      overlap.move_to( tlx, tly );
      overlap.resize( width, height );
   }
   return overlap;
}

point rectangle::top_left()     { return _tl; }
point rectangle::bottom_right() { return _br; }

int  rectangle::top()    { return _tl.y; }
int  rectangle::left()   { return _tl.x; }
int  rectangle::bottom() { return _br.y; }
int  rectangle::right()  { return _br.x; }

int  rectangle::width()  { return _width; }
int  rectangle::height() { return _height; }

bool rectangle::
operator==( rectangle & other )
{
   return ( _tl == other._tl
         && _br == other._br );
}

void rectangle::
move_to( int new_x, int new_y )
{
   _tl.x = new_x;
   _tl.y = new_y;
   _br.x = _tl.x + _width  - 1;
   _br.y = _tl.y + _height - 1;
}

void rectangle::
resize( int new_width, int new_height )
{
   if( new_width >= 0 )
      _width = new_width;
   if( new_height >= 0 )
      _height = new_height;

   _br.x = _tl.x + _width  - 1;
   _br.y = _tl.y + _height - 1;
}

