#include "keyboard.h"
#include <bios.h>
#include <dos.h>

keyboard_object key;

keyboard_object::keyboard_object()
{
   _scan_code = 0;
}

keyboard_object::~keyboard_object()
{
}

// rate must be between 0 (fast) and 31 (slow)
// delay must be between 0 (short) and 3 (long)
void keyboard_object::
set_repeat_rate( int rate, int delay )
{
   union REGS registers;

   if( rate <  0 ) rate =  0;
   if( rate > 31 ) rate = 31;
   if( delay < 0 ) delay = 0;
   if( delay > 3 ) delay = 3;

   registers.w.ax = 0x0305;
   registers.w.bx = delay << 8 | rate;
   int86( 0x16, &registers, &registers );
}

unsigned keyboard_object::pressed()
{
   return _bios_keybrd( _NKEYBRD_READY );
}

unsigned keyboard_object::get()
{
   return _scan_code = _bios_keybrd( _NKEYBRD_READ );
}

unsigned keyboard_object::scan_code()
{
   return _scan_code;
}

char keyboard_object::ascii_code()
{
   return (char)( _scan_code & 255 );
}

char keyboard_object::key_code()
{
   return (char)( _scan_code >> 8 );
}

unsigned shift_status_word()
{
   return (unsigned int)_bios_keybrd( _NKEYBRD_SHIFTSTATUS );
}


unsigned keyboard_object::pure()
{
   return purify( _scan_code );
}

unsigned purify( unsigned scan_code )
{
   switch( scan_code )
   {
   case  escape_key:
   case  alt_escape_key:
      return escape_key;

   case  f1_key:
   case  shift_f1_key:
   case  control_f1_key:
   case  alt_f1_key:
      return f1_key;

   case  f2_key:
   case  shift_f2_key:
   case  control_f2_key:
   case  alt_f2_key:
      return f2_key;

   case  f3_key:
   case  shift_f3_key:
   case  control_f3_key:
   case  alt_f3_key:
      return f3_key;

   case  f4_key:
   case  shift_f4_key:
   case  control_f4_key:
   case  alt_f4_key:
      return f4_key;

   case  f5_key:
   case  shift_f5_key:
   case  control_f5_key:
   case  alt_f5_key:
      return f5_key;

   case  f6_key:
   case  shift_f6_key:
   case  control_f6_key:
   case  alt_f6_key:
      return f6_key;

   case  f7_key:
   case  shift_f7_key:
   case  control_f7_key:
   case  alt_f7_key:
      return f7_key;

   case  f8_key:
   case  shift_f8_key:
   case  control_f8_key:
   case  alt_f8_key:
      return f8_key;

   case  f9_key:
   case  shift_f9_key:
   case  control_f9_key:
   case  alt_f9_key:
      return f9_key;

   case  f10_key:
   case  shift_f10_key:
   case  control_f10_key:
   case  alt_f10_key:
      return f10_key;

   case  f11_key:
   case  shift_f11_key:
   case  control_f11_key:
   case  alt_f11_key:
      return f11_key;

   case  f12_key:
   case  shift_f12_key:
   case  control_f12_key:
   case  alt_f12_key:

   case  above_tab_key:
   case  shift_above_tab_key:
   case  control_above_tab_key:
   case  alt_above_tab_key:
      return f12_key;

   case  _1_key:
   case  shift_1_key:
   case  alt_1_key:
   case  _2_key:
      return _1_key;

   case  shift_2_key:
   case  control_2_key:
   case  alt_2_key:
      return shift_2_key;

   case  _3_key:
   case  shift_3_key:
   case  alt_3_key:
      return _3_key;

   case  _4_key:
   case  shift_4_key:
   case  alt_4_key:
      return _4_key;

   case  _5_key:
   case  shift_5_key:
   case  alt_5_key:
      return _5_key;

   case  _6_key:
   case  shift_6_key:
   case  control_6_key:
   case  alt_6_key:
      return _6_key;

   case  _7_key:
   case  shift_7_key:
   case  alt_7_key:
      return _7_key;

   case  _8_key:
   case  shift_8_key:
   case  alt_8_key:
      return _8_key;

   case  _9_key:
   case  shift_9_key:
   case  alt_9_key:
      return _9_key;

   case  _0_key:
   case  shift_0_key:
   case  alt_0_key:
      return _0_key;

   case  minus_key:
   case  shift_minus_key:
   case  control_minus_key:
   case  alt_minus_key:
      return minus_key;

   case  equals_key:
   case  shift_equals_key:
   case  alt_equals_key:
      return equals_key;

   case  backspace_key:
   case  control_backspace_key:
   case  alt_backspace_key:
      return backspace_key;

   case  tab_key:
   case  shift_tab_key:
   case  control_tab_key:
   case  alt_tab_key:
      return tab_key;

   case  q_key:
   case  shift_q_key:
   case  control_q_key:
   case  alt_q_key:
      return q_key;

   case  w_key:
   case  shift_w_key:
   case  control_w_key:
   case  alt_w_key:
      return w_key;

   case  e_key:
   case  shift_e_key:
   case  control_e_key:
   case  alt_e_key:
      return e_key;

   case  r_key:
   case  shift_r_key:
   case  control_r_key:
   case  alt_r_key:
      return r_key;

   case  t_key:
   case  shift_t_key:
   case  control_t_key:
   case  alt_t_key:
      return t_key;

   case  y_key:
   case  shift_y_key:
   case  control_y_key:
   case  alt_y_key:
      return y_key;

   case  u_key:
   case  shift_u_key:
   case  control_u_key:
   case  alt_u_key:
      return u_key;

   case  i_key:
   case  shift_i_key:
   case  control_i_key:
   case  alt_i_key:
      return i_key;

   case  o_key:
   case  shift_o_key:
   case  control_o_key:
   case  alt_o_key:
      return o_key;

   case  p_key:
   case  shift_p_key:
   case  control_p_key:
   case  alt_p_key:
      return p_key;

   case  left_square_bracket_key:
   case  shift_left_square_bracket_key:
   case  control_left_square_bracket_key:
   case  alt_left_square_bracket_key:
      return left_square_bracket_key;

   case  right_square_bracket_key:
   case  shift_right_square_bracket_key:
   case  control_right_square_bracket_key:
   case  alt_right_square_bracket_key:
      return right_square_bracket_key;

   case  return_key:
   case  control_return_key:
   case  alt_return_key:
      return return_key;

   case  a_key:
   case  shift_a_key:
   case  control_a_key:
   case  alt_a_key:
      return a_key;

   case  s_key:
   case  shift_s_key:
   case  control_s_key:
   case  alt_s_key:
      return s_key;

   case  d_key:
   case  shift_d_key:
   case  control_d_key:
   case  alt_d_key:
      return d_key;

   case  f_key:
   case  shift_f_key:
   case  control_f_key:
   case  alt_f_key:
      return f_key;

   case  g_key:
   case  shift_g_key:
   case  control_g_key:
   case  alt_g_key:
      return g_key;

   case  h_key:
   case  shift_h_key:
   case  control_h_key:
   case  alt_h_key:
      return h_key;

   case  j_key:
   case  shift_j_key:
   case  control_j_key:
   case  alt_j_key:
      return j_key;

   case  k_key:
   case  shift_k_key:
   case  control_k_key:
   case  alt_k_key:
      return k_key;

   case  l_key:
   case  shift_l_key:
   case  control_l_key:
   case  alt_l_key:
      return l_key;

   case  semicolon_key:
   case  shift_semicolon_key:
   case  alt_semicolon_key:
      return semicolon_key;

   case  apostrophe_key:
   case  shift_apostrophe_key:
   case  alt_apostrophe_key:
      return apostrophe_key;

   case  hash_key:
   case  shift_hash_key:
   case  alt_hash_key:
      return hash_key;

   case  backslash_key:
   case  shift_backslash_key:
      return backslash_key;

   case  z_key:
   case  shift_z_key:
   case  control_z_key:
   case  alt_z_key:
      return z_key;

   case  x_key:
   case  shift_x_key:
   case  control_x_key:
   case  alt_x_key:
      return x_key;

   case  c_key:
   case  shift_c_key:
   case  alt_c_key:
      return c_key;

   case  v_key:
   case  shift_v_key:
   case  control_v_key:
   case  alt_v_key:
      return v_key;

   case  b_key:
   case  shift_b_key:
   case  control_b_key:
   case  alt_b_key:
      return b_key;

   case  n_key:
   case  shift_n_key:
   case  control_n_key:
   case  alt_n_key:
      return n_key;

   case  m_key:
   case  shift_m_key:
   case  control_m_key:
   case  alt_m_key:
      return m_key;

   case  comma_key:
   case  shift_comma_key:
   case  alt_comma_key:
      return comma_key;

   case  dot_key:
   case  shift_dot_key:
   case  alt_dot_key:
      return dot_key;

   case  forward_slash_key:
   case  shift_forward_slash_key:
   case  alt_forward_slash_key:
   case  space_bar:
      return forward_slash_key;

   case  insert_key:
   case  control_insert_key:
   case  alt_insert_key:
      return insert_key;

   case  delete_key:
   case  control_delete_key:
   case  alt_delete_key:
      return delete_key;

   case  home_key:
   case  control_home_key:
   case  alt_home_key:
      return home_key;

   case  end_key:
   case  control_end_key:
   case  alt_end_key:
      return end_key;

   case  page_up_key:
   case  control_page_up_key:
   case  alt_page_up_key:
      return page_up_key;

   case  page_down_key:
   case  control_page_down_key:
   case  alt_page_down_key:
      return page_down_key;

   case  left_arrow_key:
   case  control_left_arrow_key:
   case  alt_left_arrow_key:
      return left_arrow_key;

   case  right_arrow_key:
   case  control_right_arrow_key:
   case  alt_right_arrow_key:
      return right_arrow_key;

   case  up_arrow_key:
   case  control_up_arrow_key:
   case  alt_up_arrow_key:
      return up_arrow_key;

   case  down_arrow_key:
   case  control_down_arrow_key:
   case  alt_down_arrow_key:
      return down_arrow_key;

   case  numpad_dot_key:
   case  shift_numpad_dot_key:
   case  control_numpad_dot_key:
      return numpad_dot_key;

   case  numpad_0_key:
   case  shift_numpad_0_key:
   case  control_numpad_0_key:
      return numpad_0_key;

   case  numpad_1_key:
   case  shift_numpad_1_key:
   case  control_numpad_1_key:
   case  alt_numpad_1_key:
      return numpad_1_key;

   case  numpad_2_key:
   case  shift_numpad_2_key:
   case  control_numpad_2_key:
   case  alt_numpad_2_key:
      return numpad_2_key;

   case  numpad_3_key:
   case  shift_numpad_3_key:
   case  control_numpad_3_key:
   case  alt_numpad_3_key:
      return numpad_3_key;

   case  numpad_4_key:
   case  shift_numpad_4_key:
   case  control_numpad_4_key:
   case  alt_numpad_4_key:
      return numpad_4_key;

   case  numpad_5_key:
   case  shift_numpad_5_key:
   case  control_numpad_5_key:
   case  alt_numpad_5_key:
      return numpad_5_key;

   case  numpad_6_key:
   case  shift_numpad_6_key:
   case  control_numpad_6_key:
   case  alt_numpad_6_key:
      return numpad_6_key;

   case  numpad_7_key:
   case  shift_numpad_7_key:
   case  control_numpad_7_key:
   case  alt_numpad_7_key:
      return numpad_7_key;

   case  numpad_8_key:
   case  shift_numpad_8_key:
   case  control_numpad_8_key:
   case  alt_numpad_8_key:
      return numpad_8_key;

   case  numpad_9_key:
   case  shift_numpad_9_key:
   case  control_numpad_9_key:
   case  alt_numpad_9_key:
      return numpad_9_key;

   case  numpad_slash_key:
   case  control_numpad_slash_key:
   case  alt_numpad_slash_key:
      return numpad_slash_key;

   case  numpad_asterisk_key:
   case  control_numpad_asterisk_key:
   case  alt_numpad_asterisk_key:
      return numpad_asterisk_key;

   case  numpad_minus_key:
   case  control_numpad_minus_key:
   case  alt_numpad_minus_key:
      return numpad_minus_key;

   case  numpad_plus_key:
   case  control_numpad_plus_key:
   case  alt_numpad_plus_key:
      return numpad_plus_key;

   case  numpad_enter_key:
   case  control_numpad_enter_key:
   case  alt_numpad_enter_key:
      return numpad_enter_key;

   default:
      return 0;
   }
}

