/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains fading functions.

*/
#ifndef s_fade_h
#define s_fade_h

//For PALETTE.
#include <allegro.h>


//Some small routines for colors.
extern RGB v2rgb(char r,char g,char b);
extern RGB anothercolor(RGB color);
extern RGB invertcolor(RGB color);
extern RGB graycolor(RGB color);
#define greycolor(color)   graycolor(color)
extern RGB hsv2rgb(float h,float s,float v);
extern RGB random_color(void);
extern RGB random_hue(float s,float v);
//Two small routines for palettes.
extern void fill_palette(PALETTE pal,RGB color);
#define palcopy(so,de)        (memcpy((de),(so),256*sizeof(RGB)))


/* Return the luminance of the color. Luminance ranges from 0 (black) to
	max_luminance=6300 (white).
*/
#define luminance(r,g,b)      (m30((long)(r))+((long)(g))*59+((long)(b))*11)
#define _luminancergb(color)  (m30((long)(color).r)+((long)(color).g)*59+((long)(color).b)*11)
extern int luminancergb(RGB color);
//The highest value luminance can have.
#define max_luminance         (6300)
/* Lightens or darkens a color.
*/
extern RGB luminate(RGB color,int newlum);


//Returns a color at progress/256 part of the way between so and de.
extern RGB change_color(RGB so,RGB de,long progress);
//Returns a color at progress/256 part of the way between so and de, but with
//the same luminance as so.
extern RGB change_hue(RGB so,RGB de,long progress);


//These are really strange and hard to explain. Look at the code if you're
//interested.
extern int make_nonlinear_progress(double x, double maxi, double maxo,
 double displacement);
extern int make_lum_progress(double progress, double maxi, double maxo,
 double lum, double amount);


//These are external and alter the speed and some more of fading.
extern int fade_curviness, fade_lum, fade_amount, fade_via_amount;


//Extremely cool fading functions!!!

extern void fade_callback(int progress);
extern void fadeout_range(int milliseconds, int fromindex, int toindex);
extern void fadein_range(int milliseconds, int fromindex, int toindex, PALETTE pal);
extern void fadeto_range(int milliseconds, int fromindex, int toindex, PALETTE pal);
extern void fadebetween_range(int milliseconds, int fromindex, int toindex, PALETTE so, PALETTE de);
#define fadeout(milliseconds)                                     (fadeout_range(milliseconds,0,255))
#define fadein(milliseconds,pal)                                  (fadein_range(milliseconds,0,255,pal))
#define fadeto(milliseconds,pal)                                  (fadeto_range(milliseconds,0,255,pal))
#define fadebetween(milliseconds,so,de)                           (fadebetween_range(milliseconds,0,255,so,de))

extern void fadeto_color_range(int milliseconds, int fromindex, int toindex, RGB color);
extern void fadeto_hue_range(int milliseconds, int fromindex, int toindex, RGB color);
#define fadeto_color(milliseconds,color)                          (fadeto_color_range(milliseconds,0,255,color))
#define fadeto_hue(milliseconds,color)                            (fadeto_hue_range(milliseconds,0,255,color))
#define fadeto_color_random_range(milliseconds,fromindex,toindex) (fadeto_color_range(milliseconds,fromindex,toindex,random_hue(1,1)))
#define fadeto_hue_random_range(milliseconds,fromindex,toindex)   (fadeto_hue_range(milliseconds,fromindex,toindex,random_hue(1,1)))
#define fadeto_color_random(milliseconds)                         (fadeto_color(milliseconds,random_hue(1,1)))
#define fadeto_hue_random(milliseconds)                           (fadeto_hue(milliseconds,random_hue(1,1)))

extern void fade_viacolor_callback(int progress);
extern void fadeout_viacolor_range(int milliseconds, int fromindex, int toindex, RGB color);
extern void fadein_viacolor_range(int milliseconds, int fromindex, int toindex, PALETTE pal, RGB color);
extern void fadeto_viacolor_range(int milliseconds, int fromindex, int toindex, PALETTE pal, RGB color);
extern void fadebetween_viacolor_range(int milliseconds, int fromindex, int toindex, PALETTE so, PALETTE de, RGB color);
#define fadeout_viacolor(milliseconds,color)                                     (fadeout_viacolor_range(milliseconds,0,255,color))
#define fadein_viacolor(milliseconds,pal,color)                                  (fadein_viacolor_range(milliseconds,0,255,pal,color))
#define fadeto_viacolor(milliseconds,pal,color)                                  (fadeto_viacolor_range(milliseconds,0,255,pal,color))
#define fadebetween_viacolor(milliseconds,so,de,color)                           (fadebetween_viacolor_range(milliseconds,0,255,so,de,color))
#define fadeout_viacolor_random_range(milliseconds,fromindex,toindex)            (fadeout_viacolor_range(milliseconds,fromindex,toindex,random_color(1,1)))
#define fadein_viacolor_random_range(milliseconds,fromindex,toindex,pal)         (fadein_viacolor_range(milliseconds,fromindex,toindex,pal,random_color(1,1)))
#define fadeto_viacolor_random_range(milliseconds,fromindex,toindex,pal)         (fadeto_viacolor_range(milliseconds,fromindex,toindex,pal,random_color(1,1)))
#define fadebetween_viacolor_random_range(milliseconds,fromindex,toindex,so,de)  (fadebetween_viacolor_range(milliseconds,fromindex,toindex,so,de,random_color(1,1)))
#define fadeout_viacolor_random(milliseconds)                                    (fadeout_viacolor(milliseconds,random_color(1,1)))
#define fadein_viacolor_random(milliseconds,pal)                                 (fadein_viacolor(milliseconds,pal,random_color(1,1)))
#define fadeto_viacolor_random(milliseconds,pal)                                 (fadeto_viacolor(milliseconds,pal,random_color(1,1)))
#define fadebetween_viacolor_random(milliseconds,so,de)                          (fadebetween_viacolor(milliseconds,so,de,random_color(1,1)))

extern void fade_viahue_callback(int progress);
extern void fadeout_viahue_range(int milliseconds, int fromindex, int toindex, RGB color);
extern void fadein_viahue_range(int milliseconds, int fromindex, int toindex, PALETTE pal, RGB color);
extern void fadeto_viahue_range(int milliseconds, int fromindex, int toindex, PALETTE pal, RGB color);
extern void fadebetween_viahue_range(int milliseconds, int fromindex, int toindex, PALETTE so, PALETTE de, RGB color);
#define fadeout_viahue(milliseconds,color)                                       (fadeout_viahue_range(milliseconds,0,255,color))
#define fadein_viahue(milliseconds,pal,color)                                    (fadein_viahue_range(milliseconds,0,255,pal,color))
#define fadeto_viahue(milliseconds,pal,color)                                    (fadeto_viahue_range(milliseconds,0,255,pal,color))
#define fadebetween_viahue(milliseconds,so,de,color)                             (fadebetween_viahue_range(milliseconds,0,255,so,de,color))
#define fadeout_viahue_random_range(milliseconds,fromindex,toindex)              (fadeout_viahue_range(milliseconds,fromindex,toindex,random_hue(1,1)))
#define fadein_viahue_random_range(milliseconds,fromindex,toindex,pal)           (fadein_viahue_range(milliseconds,fromindex,toindex,pal,random_hue(1,1)))
#define fadeto_viahue_random_range(milliseconds,fromindex,toindex,pal)           (fadeto_viahue_range(milliseconds,fromindex,toindex,pal,random_hue(1,1)))
#define fadebetween_viahue_random_range(milliseconds,fromindex,toindex,so,de)    (fadebetween_viahue_range(milliseconds,fromindex,toindex,so,de,random_hue(1,1)))
#define fadeout_viahue_random(milliseconds)                                      (fadeout_viahue(milliseconds,random_hue(1,1)))
#define fadein_viahue_random(milliseconds,pal)                                   (fadein_viahue(milliseconds,pal,random_hue(1,1)))
#define fadeto_viahue_random(milliseconds,pal)                                   (fadeto_viahue(milliseconds,pal,random_hue(1,1)))
#define fadebetween_viahue_random(milliseconds,so,de)                            (fadebetween_viahue(milliseconds,so,de,random_hue(1,1)))

//Special fading. Doesn't work yet.
//extern void fadein_millenium(PALETTE pal,int milliseconds);

#endif
