/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains mallocing and reallocing functions.

*/

#ifndef s_alloc_h
#define s_alloc_h


extern void *(*xxmalloc)(int size);
extern void *(*xxrealloc)(void *buf, int size);

extern void *salad_xmalloc(int size);
extern void *salad_xrealloc(void *buf, int size);

/* The malloc functions only malloc if `buf' is `NULL'. The realloc functions
	only realloc if `allocmode' is `NULL'.
*/
extern void *ifmalloc(void *buf,int length);
extern void *ifrealloc(void *buf,int allocmode,int length);
extern void *ifxmalloc(void *buf,int length);
extern void *ifxrealloc(void *buf,int allocmode,int length);
#define _ifmalloc(buf,length)             ( (buf) ?         (buf) : ((buf)=malloc(length)) )
#define _ifrealloc(buf,allocmode,length)  ( (allocmode) ?   (buf) : ((buf)=realloc(buf,length)) )
#define _ifxmalloc(buf,length)            ( (buf) ?         (buf) : ((buf)=xxmalloc(length)) )
#define _ifxrealloc(buf,allocmode,length) ( (allocmode) ?   (buf) : ((buf)=xxrealloc(buf,length)) )

/***************************************
****                                ****
**** Allocing functions for strings ****
****                                ****
***************************************/

/* The same as malloc/realloc/xxmalloc/xxrealloc, but puts a zero at the end of
	the string. Length is number of characters, not counting the zero.
*/
extern uchar *strmalloc(long length);
extern uchar *strrealloc(uchar *text,long length);
extern uchar *strxmalloc(long length);
extern uchar *strxrealloc(uchar *text,long length);
/* The same as the above, with the difference that they maybe skip the
	mallocing part.
	The malloc functions only malloc if text is NULL.
	The realloc functions only realloc if mallocmode is NULL.
*/
/*not tested*/
extern uchar *ifstrmalloc(uchar *text,long length);
/*not tested*/
extern uchar *ifstrrealloc(uchar *text,int allocmode,long length);
/*not tested*/
extern uchar *ifstrxmalloc(uchar *text,long length);
/*not tested*/
extern uchar *ifstrxrealloc(uchar *text,int allocmode,long length);

/* xmallocs/xreallocs memory for strings.
	Note that these macros always return zero. You should call them without
	doing anything to the result, for example:
	 strxrealloc(text,40);
	Also note that the size parameter is used twice, so you shouldn't specify
	complex expressions or, even worse, function calls as parameters.
	The length parameter means the number of characters in the string, not
	counting the last zero.
	These are the same as the functions without _. The difference is that
	these are macros. The functions just call these macros.
*/
#define _strxmalloc(text,length)    ((*( ((text)=xxmalloc((length)+1))+(length) ))=0)
#define _strxrealloc(text,length)   ((*( ((text)=xxrealloc((text),(length)+1))+(length) ))=0)

/* xmallocs/xreallocs memory for strings if allocmode is nonzero.
	For malloc function: If text is NULL, the macro will malloc memory for it.
	Otherwise, it will only set last byte to zero.
	For realloc function: If allocmode is NULL, the macro will realloc memory
	for text. Otherwise, it will only set the last byte to zero.
	This is useful if you want the user of your function to select wether he
	or your function shall malloc data.
*/
/*not tested*/
#define _ifstrxmalloc(text,length)              ( (text) ? *((text)+(length))=0 : _strxmalloc((text),(length)) )
/*not tested*/
#define _ifstrxrealloc(text,allocmode,length)   ( (allocmode) ? *((text)+(length))=0 : _strxrealloc((text),(length)) )




#endif

