#include <salad.h>
#include <allegro.h>

#include <conio.h>


void init(void)
{
allegro_init();
install_timer();
install_keyboard();
salad_init();

clrscr();
printf(
"Salad Example\n"
"Example of the stop-watch functions (`timer_*()') in Salad by Sven Sandberg.\n"
"\n"
"Press any of the following keys:\n"
"1   - `timer_start(1000)' - starts the stop-watch, updating it 1000 times a\n"
"                            second.\n"
"2   - `timer_read()'      - reads current time\n"
"3   - `timer_stop()'      - stops the stop-watch\n"
"4   - `timer_pause()'     - pauses the stop-watch\n"
"5   - `timer_unpause()'   - unpauses the stop-watch\n"
"ESC - exit the example program\n"
"\n"
"timer_mode == %d\n"
"Current time: %u.\n"
"\n"
"The stop-watch hasn't been started yet. To start it, press 1\n",
timer_mode, (unsigned int)timer_read());//Return value is already unsigned
//int, but DJGPP gives a warning otherways.
}



void run(void)
{
int ret;
while(!key[KEY_ESC]){
	gotoxy(1,13);
	printf("timer_mode == %d\n", timer_mode);
	gotoxy(1,14);
	printf("Current time: %u       \n", (unsigned int)timer_read());
	if(keypressed()){
		switch(readkey() & 0xFF){
			case '1':
				gotoxy(1,16);
				delline();delline();delline();delline();
				if(timer_mode != 0)
					printf("The timer wasn't off. That means it will only be resetted.\n");
				printf("`timer_start()' starts the stop watch, ie makes it begin ticking.\n");
				ret = timer_start(1000);
				if(ret == 0)
					printf("`timer_start()' was successfully called, returning 0.\n");
				else
					printf("`timer_start()' failed, returning %d.\n", ret);
			break;
			case '2':
				gotoxy(1,16);
				delline();delline();delline();delline();
				if(timer_mode == 0)
					printf("The timer is off. That means `timer_read()' can only return 0.\n");
				printf("`timer_read()' returns the time elapsed since `timer_start()' was called,\n"
				 "measured in milliseconds.\n"
				 "`timer_read()' was called and returned %u.\n",
				 (unsigned int)timer_read());
			break;
			case '3':
				gotoxy(1,16);
				delline();delline();delline();delline();
				if(timer_mode == 0)
					printf("The timer was already off. That `timer_stop()' won't do anything.\n");
				printf("`timer_stop()' stops the stop watch. To start it again, call `timer_start()'.\n"
				 "`timer_stop' was called and retured %u.\n",
				 (unsigned int)timer_stop());
			break;
			case '4':
				gotoxy(1,16);
				delline();delline();delline();delline();
				if(timer_mode == 0)
					printf("The timer was off. `timer_pause()' will make the timer paused anyway.\n");
				else if(timer_mode == 1)
					printf("The timer was already paused. That means `timer_pause()' won't do anything.\n");
				printf("`timer_pause()' pauses the stop watch. You may call `timer_unpause()' later to\n"
				 "make it continue. It returns the current time, in milliseconds.\n"
				 "It was called and retured %u.\n",
				 (unsigned int)timer_pause());
			break;
			case '5':
				gotoxy(1,16);
				delline();delline();delline();delline();
				if(timer_mode == 0)
					printf("The timer was off. `timer_unpause()' will start the timer.\n");
				else if(timer_mode == 2)
					printf("The timer was already on. That means `timer_unpause()' won't do anything.\n");
				printf("`timer_unpause()' unpauses the stop watch.\n");
				ret = timer_unpause();
				if(ret == 0)
					printf("`timer_unpause()' was successfully called and returned 0.\n");
				else
					printf("`timer_unpause()' failed, returning %d.\n", ret);
			break;
		}
	}
}
}



int main(void)
{
init();
run();
gotoxy(1,20);
return 0;
}
