//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Button object
//----------------------------------------------------------------------------
// Constructor
button_object::button_object (const char* tex, const char sk, const bool exits)
   :text_object(tex),
	willexit(exits),
	shortcut(sk)
   {
	// Setup the exit conditions
	if(willexit) make_exit();
	else dont_exit();

	// Setup the quick key
	set_key(shortcut);

   // Setup the defaults
   set_x(100);
   set_y(100);
   set_w(text_length(font,(unsigned char*)text)+20);
   set_h(text_height(font)+10);

   deselect();

   demand_focus = true;
   }
//----------------------------------------------------------------------------
// Destructor
button_object::~button_object (void)
   {
   }

//----------------------------------------------------------------------------
// Basic message passing functions

// Tell the object to draw itself
void button_object::msg_draw()
   {
   _draw_button_object (text,
                        selected(),
                        x(),y(),w(),h(),
                        disabled(),has_focus(),
                        color ? color->fore() : degui_fore_color,
                        color ? color->select() : degui_select_color,
                        color ? color->deselect() : degui_deselect_color,
                        color ? color->disable() : degui_disable_color,
                        color ? color->light_shad() : degui_light_shad_color,
                        color ? color->dark_shad() : degui_dark_shad_color);
   _redraw = false;
   }
//----------------------------------------------------------------------------
// Tell the object to deal with a mouse click
void button_object::msg_key (void)
   {
   if(selected()==true) deselect();
   else select();

   if(will_exit()==true) deselect();
   }
//----------------------------------------------------------------------------
// Ask the object if they want the focus
bool button_object::msg_wantfocus (void)
   {
   return true;
   }
//----------------------------------------------------------------------------

