//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

Dialog within a dialog and the adding and removal of dialogs from a
allready running dialog

*/
#include <stdlib.h>
#include <stdio.h>

#include "allegro.h"

// Include the dialog objects
#include "degui.h"

// For use with the callbacks to remove or add other stuff
dialog* main_dialog;

dialog* sub_dialog1;
dialog* sub_dialog2;

button_object* control;

// This is a callback called when the user wants to add or remove a subdialog
int add_remove_proc (void)
   {
   static bool should_add = false;

   // Do we add the other dialog
   if(should_add==true)
      {
      main_dialog->add(*sub_dialog2);
      control->set_text("Remove sub-dialog 2");
      should_add = false;
      }
   else
      {
      main_dialog->remove(*sub_dialog2);
      control->set_text("Add sub-dialog 2");
      should_add = true;
      }
   // Do the switching of the button and wait for the button up
   dialog_object::default_behaviour();
   while(mouse_b) { };

   // Ask for a redraw sincw we changed everything
   return D_REDRAW;
   }

//----------------------------------------------------------------------------
int main(void)
   {
   /* initialise everything */
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Declare the first sub-dialog and it's objects
   dialog sd1;
   sub_dialog1 = &sd1;

   shadow_box_object object_2;
   text_object object_3("Sub-dialog 1");
   button_object object_4("Button",0,false);
   button_object object_5("Button",0,false);

   // Declare the second sub-dialog and it's objects
   dialog sd2;
   sub_dialog2 = &sd2;

   box_object object_6;
   list_object object_7;
   text_object object_8("Subdialog 2");

   // Declare the main dialog
   dialog the_dialog;
   main_dialog = &the_dialog;

   // Add Objects to the dialog
   sd1.add(object_2,90,95,145,160);
   sd1.add(object_3,120,110,96,8);
   sd1.add(object_4,120,140,68,18);
   sd1.add(object_5,120,170,68,18);

   // Add Objects to the dialog
   sd2.add(object_6,325,90,165,170);
   sd2.add(object_7,355,155,100,65);
   sd2.add(object_8,360,120,88,8);

   // Declare the main dialog
   box_object object_9;
   text_object object_10("Main dialog");
   button_object add_or_remove_sd2("Remove sub-dialog 2");

   control = &add_or_remove_sd2;

   // Here we make the button call a callback when clicked or
   // keyed to add or remove the sub-dialog
   add_or_remove_sd2.set_key_callback(add_remove_proc);
   add_or_remove_sd2.set_click_callback(add_remove_proc);

   // Add Objects to the dialog
   the_dialog.add(object_9,0,0,SCREEN_W,SCREEN_H);
   the_dialog.add(object_10,230,45,88,8);
   the_dialog.add(add_or_remove_sd2,10,10);
   the_dialog.add(sd1); // Here we are adding a dialog into another dialog
   the_dialog.add(sd2);

   // Do the dialog
   the_dialog.execute();

   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------
