//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "backg.h"
#include "manipul.h"

//----------------------------------------------------------------------------
// Helper function for dialog to move objects
void do_object_move (DIALOG *pointed, DIALOG *current, const int gran)
   {
   int original_x, original_y;
   int last_mousex, last_mousey, this_mousex, this_mousey;
   int done_move;
   BITMAP *bak;

   // Make sure that we pointed to an object
   if((pointed==NULL)||(current==NULL)) return;

   // The original object position
   original_x = pointed->x;
   original_y = pointed->y;

   // Make sure that we pointed to an object
   if((pointed==NULL)||(current==NULL)) return;
   position_mouse(pointed->x,pointed->y);

   // Move the mouse to the object
   last_mousex = (mouse_x/gran)*gran;
   last_mousey = (mouse_y/gran)*gran;
   this_mousex = (mouse_x/gran)*gran;
   this_mousey = (mouse_y/gran)*gran;

   // Get the object background
   bak = create_bitmap(pointed->w+1,pointed->h+1);
   get_object_background(bak,pointed);

   // Move the object where the user wants it
   done_move = FALSE;
   while(done_move==FALSE)
      {
      // Only redraw when the mouse has moved
      if((last_mousex!=this_mousex)||(last_mousey!=this_mousey))
         {
         // Replace with the background
         show_mouse(NULL);
         blit(bak,screen,0,0,pointed->x,pointed->y,pointed->w+1,pointed->h+1);

         // Move the object over
         pointed->x = this_mousex;
         pointed->y = this_mousey;

         // Get the new background
         blit(screen,bak,pointed->x,pointed->y,0,0,pointed->w+1,pointed->h+1);

         // Draw the object
         pointed->proc(MSG_DRAW,pointed,0);
         rect(screen,pointed->x,pointed->y,pointed->x+pointed->w,pointed->y+pointed->h,gui_fg_color);
         show_mouse(screen);

         // Remember where the mouse was
         last_mousex = this_mousex;
         last_mousey = this_mousey;
         }
      this_mousex = (mouse_x/gran)*gran;
      this_mousey = (mouse_y/gran)*gran;

      // Check for user keys
      if(keypressed())
         {
         switch(readkey()>>8)
            {
            // Check for user escape
            case(KEY_ESC):
               {
               // Replace the old position and return
               pointed->x = original_x;
               pointed->y = original_y;
               done_move = TRUE;
               break;
               }
            // Normal moving exit
            case(KEY_SPACE):
            case(KEY_ENTER):
               {
               done_move = TRUE;
               break;
               }
            // Check if it was the invoking key
            default:
               {
               };
            }
         }
      // Pressing the mouse will also set the object down
      else if(mouse_b)
         {
         done_move = TRUE;
         while(mouse_b) {};
         }
      }
   // Cleanup the keyboard buffer and the bitmaps
   destroy_bitmap(bak);
   }
//----------------------------------------------------------------------------

