indexing
    description    : "rgb objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    names          : rgb
    date_started   : "17th December, 1996"
    version        : "0.1"


class RGB


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make(r, g, b : INTEGER) is
    -- Create a new rgb colour with the specified components
    require
        red_is_valid   : r >= 0
        green_is_valid : g >= 0
        blue_is_valid  : b >= 0
    do
        red   := r
        green := g
        blue  := b
    ensure
        red_correct   : red   = r
        green_correct : green = g
        blue_correct  : blue  = b
    end  -- feature make


    red   : INTEGER
    green : INTEGER
    blue  : INTEGER


------------------------------------------------------ Class invariant
invariant

    red_is_valid   : red   >= 0
    green_is_valid : green >= 0
    blue_is_valid  : blue  >= 0


end  -- class RGB


