@echo off
rem ********************
rem * File: MAKE_ACE.BAT
rem * Does: Makes the ACE library.
rem ********************

:CompileC
echo Compiling C source files...
gcc -I. -I./support -Wall -Werror -m486 -O2 -ffast-math -fomit-frame-pointer -c ./support/screen.c
gcc -I. -I./support -Wall -Werror -m486 -O2 -ffast-math -fomit-frame-pointer -c ./support/timer.c
gcc -I. -I./support -Wall -Werror -m486 -O2 -ffast-math -fomit-frame-pointer -c ./support/keyboard.c
gcc -I. -I./support -Wall -Werror -m486 -O2 -ffast-math -fomit-frame-pointer -c ./support/file.c

:MakeLibrary
echo Creating LIBACE.A...
ar rs LIBACE.A screen.o timer.o keyboard.o file.o
copy libace.a tests > NUL

:CleanUp
echo Deleting all object files...
del *.o > NUL

:End
echo Done.
