indexing
    description    : "Allegro con Eiffel: datafile objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : datafile
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class DATAFILE


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end  -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make(datafilename : STRING) is
    -- Create a new datafile_object
    require
        ace_initialised : info.ace_initialised
        valid_filename  : datafilename /= Void and then
                          ace_file_tools.exists(datafilename)
    do
        filename := clone(datafilename)
    ensure
        filename_is_valid : filename /= Void and
                            filename.is_equal(datafilename)
    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- The name of the datafile
    filename : STRING

    -- A local ace_file_tools object for file specific assertions
    ace_file_tools : ACE_FILE_TOOLS


------------------------------------------------------ Datafile object features
feature { ANY }

    exists(objectname : STRING) : BOOLEAN is
    -- Does the specified object exist in this datafile?
    require
        ace_initialised     : info.ace_initialised
        objectname_is_valid : objectname /= Void
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        Result := p3.is_not_void

        -- If we successfully loaded the object, unload it straight away
        if Result then
            c_inline_c("unload_datafile_object((DATAFILE *)_p3);")
        end  -- if
    end  -- feature exists


    type(objectname : STRING) : INTEGER is
    -- Return the type of the given object
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname)
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        c_inline_c("R=((DATAFILE *)_p3)->type;unload_datafile_object((DATAFILE *)_p3);")
    ensure
        Result_is_valid : Result = info.object_bitmap                 or
                          Result = info.object_rle_sprite             or
                          Result = info.object_compiled_sprite        or
                          Result = info.object_planar_compiled_sprite or
                          Result = info.object_palette                or
                          Result = info.object_font                   or
                          Result = info.object_sample                 or
                          Result = info.object_midi                   or
                          Result = info.object_flic
    end  -- feature type


------------------------------------------------------ Object loading features
feature { ANY }

    load_bitmap(objectname : STRING) : BITMAP is
    -- Load the specified bitmap object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_bitmap
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the bitmap data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_bitmap


    load_rle_sprite(objectname : STRING) : RLE_SPRITE is
    -- Load the specified rle sprite object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_rle_sprite
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the rle sprite data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_rle_sprite


    load_compiled_sprite(objectname : STRING) : COMPILED_SPRITE is
    -- Load the specified compiled sprite object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_compiled_sprite
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the compiled sprite data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_compiled_sprite


    load_planar_compiled_sprite(objectname : STRING) : PLANAR_COMPILED_SPRITE is
    -- Load the specified planar compiled sprite object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_planar_compiled_sprite
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the planar compiled sprite data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_planar_compiled_sprite


    load_palette(objectname : STRING) : PALETTE is
    -- Load the specified palette object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_palette
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the palette data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_palette


    load_font(objectname : STRING) : FONT is
    -- Load the specified font object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_font
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the font data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_font


    load_sample(objectname : STRING) : SAMPLE is
    -- Load the specified sample object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_sample
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the sample data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_sample


    load_midi(objectname : STRING) : MIDI is
    -- Load the specified midi object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_midi
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the midi data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_midi


    load_flic(objectname : STRING) : FLIC is
    -- Load the specified FLIC object from the datafile
    require
        ace_initialised  : info.ace_initialised
        valid_objectname : objectname /= Void and then
                           exists(objectname) and then
                           type(objectname) = info.object_flic
    local
        p1 : POINTER
        p2 : POINTER
        p3 : POINTER
        p4 : POINTER
    do
        p1 := filename.to_external
        p2 := objectname.to_external
        p3 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p3=load_datafile_object(_p1,_p2);")

        check
            p3_is_valid : p3.is_not_void
        end  -- check

        -- Retrieve the FLI/FLC data
        p4 := p1   -- Dummy operation so it doesn't get optimised out
        c_inline_c("_p4=((DATAFILE *)_p3)->dat;")

        check
            p4_is_valid : p4.is_not_void
        end  -- check

        c_inline_c("((DATAFILE *)_p3)->dat=NULL;unload_datafile_object((DATAFILE *)_p3);")
        !!Result.make_from_external(p4);
    end  -- feature load_flic


------------------------------------------------------ Class invariant
invariant

    filename_is_valid : filename /= Void and then
                        ace_file_tools.exists(filename)


end  -- class DATAFILE
