indexing
    description    : "Allegro con Eiffel: ACE Information"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : ace_information
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class ACE_INFORMATION

creation { ACE_INFORMATION_SINGLETON }
    make


------------------------------------------------------ Creation features
feature { ACE_INFORMATION_SINGLETON }

    make is
    -- Create a new allegro information object
    do
        ace_initialised               := FALSE
        graphics_initialised          := FALSE
        graphics_driver               := graphics_text
        timer_initialised             := FALSE
        retrace_simulator_initialised := FALSE
        mouse_installed               := FALSE
        joystick_installed            := FALSE
        keyboard_initialised          := FALSE
        soundcard_initialised         := FALSE
        digital_driver                := digital_none
        midi_driver                   := midi_none
    ensure
        ace_not_initialised      : not ace_initialised
        graphics_not_initialised : not graphics_initialised
        graphics_text_mode       : graphics_driver = graphics_text
        timer_not_initialised    : not timer_initialised
        retrace_simulator_not_initialised : not retrace_simulator_initialised
        mouse_not_installed      : not mouse_installed
        joystick_not_installed   : not joystick_installed
        keyboard_not_initialised : not keyboard_initialised
        soundcard_not_initialised : not soundcard_initialised
        no_digital_driver        : digital_driver = digital_none
        no_midi_driver           : midi_driver = midi_none
    end  -- feature make


------------------------------------------------------ Features
feature { ANY }

    -- Has ACE been initialised?
    ace_initialised : BOOLEAN


    -- Has graphics mode been initialised?
    graphics_initialised : BOOLEAN


    -- Which graphics driver are we using?
    graphics_driver : INTEGER


    -- Has the timer been initialised?
    timer_initialised : BOOLEAN


    -- Has retrace simulation been initialised?
    retrace_simulator_initialised : BOOLEAN


    -- Is a mouse installed?
    mouse_installed : BOOLEAN


    -- Is the joystick installed?
    joystick_installed : BOOLEAN


    -- Has the keyboard been initialised?
    keyboard_initialised : BOOLEAN


    -- Has the soundcard been initialised?
    soundcard_initialised : BOOLEAN


    -- The current digital sound driver
    digital_driver : INTEGER


    -- The current MIDI sound driver
    midi_driver : INTEGER


    digital_initialised : BOOLEAN is
    -- Has a digital driver been installed?
    do
        Result := digital_driver /= digital_none
    end  -- feature digital_initialised


    midi_initialised : BOOLEAN is
    -- Has a midi driver been installed?
    do
        Result := midi_driver /= midi_none
    end  -- feature midi_initialised


    version : STRING is
    -- Return this verion of ACE
    require
        ace_initialised : ace_initialised
    once
        !!Result.make(128)
        Result.blank(128)
        Result := "0.1."
        Result.right_adjust
        Result.append(allegro_version)
        Result.right_adjust
    end  -- feature version


    allegro_version : STRING is
    -- Return the verion of Allegro in use
    require
        ace_initialised : ace_initialised
    local
        p : POINTER
    once
        !!Result.make(128)
        Result.blank(128)
        p := Result.to_external
        c_inline_c("strcpy(_p,ALLEGRO_VERSION_STR);")
        Result.right_adjust
    end  -- feature allegro_version


    id : STRING is
    -- Return the id of ACE
    require
        ace_initialised : ace_initialised
    once
        !!Result.make(128)
        Result := "Allegro Con Eiffel (ACE) v"
        Result.append(version)
        Result.append("beta by Peter Monks 1997")
        Result.right_adjust
    end  -- feature id


    allegro_id : STRING is
    -- Return the id of Allegro
    require
        ace_initialised : ace_initialised
    local
        p : POINTER
    once
        !!Result.make(128)
        Result.blank(128)
        p := Result.to_external
        c_inline_c("strcpy(_p,allegro_id);")
        Result.right_adjust
    end  -- feature allegro_id


    error_description : STRING is
    -- Return a description of the current error
    local
        p : POINTER
    do
        !!Result.make(128)
        Result.blank(128)
        p := Result.to_external
        c_inline_c("strcpy(_p, allegro_error);")
        Result.right_adjust
    end  -- feature error_description


    windows_version : INTEGER is
    -- Return the Windoze major version
    require
        ace_initialised : ace_initialised
    once
        c_inline_c("R = windows_version;")
    end  -- feature windows_version


    windows_sub_version : INTEGER is
    -- Return the Windoze sub version
    require
        ace_initialised : ace_initialised
    once
        c_inline_c("R = windows_sub_version;")
    end  -- feature windows_sub_version


------------------------------------------------------ ace_initialise features
feature { ACE_INITIALISE }

    set_ace_flag(value : BOOLEAN) is
    -- Set the ace_initialised flag
    do
        ace_initialised := value
    ensure
        ace_initialised_valid : ace_initialised = value
--        consistency           : equal(strip(ace_initialised), old strip(ace_initialised))
    end  -- feature set_ace_flag


------------------------------------------------------ Screen features
feature { SCREEN }

    set_graphics_flag(value : BOOLEAN) is
    -- Set the graphics_initialised flag
    do
        graphics_initialised := value
    ensure
        graphics_initialised_valid : graphics_initialised = value
--        consistency                : equal(strip(graphics_initialised), old strip(graphics_initialised))
    end  -- feature set_ace_flag


    set_graphics_driver(value : INTEGER) is
    -- Set the graphics_driver indicator
    require
        value_is_valid : value = graphics_text       or
                         value = graphics_vga        or
                         value = graphics_modex      or
                         value = graphics_vesa1      or
                         value = graphics_vesa2b     or
                         value = graphics_vesa2l     or
                         value = graphics_vbeaf      or
                         value = graphics_xtended    or
                         value = graphics_ati        or
                         value = graphics_mach64     or
                         value = graphics_cirrus64   or
                         value = graphics_cirrus54   or
                         value = graphics_paradise   or
                         value = graphics_s3         or
                         value = graphics_trident    or
                         value = graphics_et3000     or
                         value = graphics_et4000     or
                         value = graphics_video7
    do
        graphics_driver := value
    ensure
        graphics_driver_valid : graphics_driver = value
--        consistency           : equal(strip(graphics_driver), old strip(graphics_driver))
    end  -- feature set_graphics_driver


------------------------------------------------------ Timer features
feature { TIMER }

    set_timer_flag(value : BOOLEAN) is
    -- Set the timer_initialised flag
    do
        timer_initialised := value
    ensure
        timer_initialised_valid : timer_initialised = value
--        consistency               : equal(strip(timer_initialised), old strip(timer_initialised))
    end  -- feature set_timer_flag



------------------------------------------------------ Retrace Simulator features
feature { RETRACE_SIMULATOR }

    set_retrace_simulator_flag(value : BOOLEAN) is
    -- Set the retrace_simulator_initialised flag
    require
        timer_initialised : timer_initialised
    do
        retrace_simulator_initialised := value
    ensure
        retrace_simulator_flag_valid : retrace_simulator_initialised = value
--        consistency                  : equal(strip(retrace_simulator_initialised), old strip(retrace_simulator_initialised))
    end  -- feature set_retrace_simulator_flag


------------------------------------------------------ Mouse features
feature { MOUSE }

    set_mouse_flag(value : BOOLEAN) is
    -- Set the mouse_installed flag
    do
        mouse_installed := value
    ensure
        mouse_installed_valid : mouse_installed = value
--        consistency           : equal(strip(mouse_installed), old strip(mouse_installed))
    end  -- feature set_mouse_flag


------------------------------------------------------ Joystick features
feature { JOYSTICK }

    set_joystick_flag(value : BOOLEAN) is
    -- Set the joystick_installed flag
    do
        joystick_installed := value
    ensure
        joystick_installed_valid : joystick_installed = value
--        consistency              : equal(strip(joystick_installed), old strip(joystick_installed))
    end  -- feature set_joystick_flag


------------------------------------------------------ Keyboard features
feature { KEYBOARD }

    set_keyboard_flag(value : BOOLEAN) is
    -- Set the keyboard_initialised flag
    do
        keyboard_initialised := value
    ensure
        keyboard_initialised_valid : keyboard_initialised = value
--        consistency                : equal(strip(keyboard_initialised), old strip(keyboard_initialised))
    end  -- feature set_keyboard_flag


------------------------------------------------------ Soundcard features
feature { SOUNDCARD }

    set_soundcard_flag(value : BOOLEAN) is
    -- Set the soundcard_initialised flag
    do
        soundcard_initialised := value
    ensure
        soundcard_initialised : soundcard_initialised = value
--        consistency                : equal(strip(soundcard_initialised), old strip(soundcard_initialised))
    end  -- feature set_soundcard_flag


    set_digital_driver(driver : INTEGER) is
    -- Set the digital sound driver
    do
        digital_driver := driver
    ensure
        digital_driver_valid : digital_driver = driver
--        consistency                : equal(strip(digital_driver), old strip(digital_driver))
    end  -- feature set_digital_driver


    set_midi_driver(driver : INTEGER) is
    -- Set the midi driver
    do
        midi_driver := driver
    ensure
        midi_driver_valid : midi_driver = driver
--        consistency                : equal(strip(midi_driver), old strip(midi_driver))
    end  -- feature set_midi_driver


------------------------------------------------------ Graphics modes
feature { ANY }

    graphics_text : INTEGER is
    once
        c_inline_c("R=GFX_TEXT;")
    end  -- feature graphics_text


    graphics_autodetect : INTEGER is
    once
        c_inline_c("R=GFX_AUTODETECT;")
    end  -- feature graphics_autodetect


    graphics_vga : INTEGER is
    once
        c_inline_c("R=GFX_VGA;")
    end  -- feature graphics_vga


    graphics_modex : INTEGER is
    once
        c_inline_c("R=GFX_MODEX;")
    end  -- feature graphics_modex


    graphics_vesa1 : INTEGER is
    once
        c_inline_c("R=GFX_VESA1;")
    end  -- feature graphics_vesa1


    graphics_vesa2b : INTEGER is
    once
        c_inline_c("R=GFX_VESA2B;")
    end  -- feature graphics_vesa2b


    graphics_vesa2l : INTEGER is
    once
        c_inline_c("R=GFX_VESA2L;")
    end  -- feature graphics_vesa2l


    graphics_vbeaf : INTEGER is
    once
        c_inline_c("R=GFX_VBEAF;")
    end  -- feature graphics_vbeaf


    graphics_xtended : INTEGER is
    once
        c_inline_c("R=GFX_XTENDED;")
    end  -- feature graphics_xtended


    graphics_ati : INTEGER is
    once
        c_inline_c("R=GFX_ATI;")
    end  -- feature graphics_ati


    graphics_mach64 : INTEGER is
    once
        c_inline_c("R=GFX_MACH64;")
    end  -- feature graphics_mach64


    graphics_cirrus64 : INTEGER is
    once
        c_inline_c("R=GFX_CIRRUS64;")
    end  -- feature graphics_cirrus64


    graphics_cirrus54 : INTEGER is
    once
        c_inline_c("R=GFX_CIRRUS54;")
    end  -- feature graphics_cirrus54


    graphics_paradise : INTEGER is
    once
        c_inline_c("R=GFX_PARADISE;")
    end  -- feature graphics_paradise


    graphics_s3 : INTEGER is
    once
        c_inline_c("R=GFX_S3;")
    end  -- feature graphics_s3


    graphics_trident : INTEGER is
    once
        c_inline_c("R=GFX_TRIDENT;")
    end  -- feature graphics_trident


    graphics_et3000 : INTEGER is
    once
        c_inline_c("R=GFX_ET3000;")
    end  -- feature graphics_et3000


    graphics_et4000 : INTEGER is
    once
        c_inline_c("R=GFX_ET4000;")
    end  -- feature graphics_et4000


    graphics_video7 : INTEGER is
    once
        c_inline_c("R=GFX_VIDEO7;")
    end  -- feature graphics_video7


------------------------------------------------------ Keyboard scancodes
feature { ANY }

    scancode_escape : INTEGER is
    -- The code for the ESC key
    once
        c_inline_c("R=KEY_ESC;")
    end  -- feature code_escape


    scancode_1 : INTEGER is
    -- The code for the 1 key
    once
        c_inline_c("R=KEY_1;")
    end  -- feature code_1


    scancode_2 : INTEGER is
    -- The code for the 2 key
    once
        c_inline_c("R=KEY_2;")
    end  -- feature code_2


    scancode_3 : INTEGER is
    -- The code for the 3 key
    once
        c_inline_c("R=KEY_3;")
    end  -- feature code_3


    scancode_4 : INTEGER is
    -- The code for the 4 key
    once
        c_inline_c("R=KEY_4;")
    end  -- feature code_4


    scancode_5 : INTEGER is
    -- The code for the 5 key
    once
        c_inline_c("R=KEY_5;")
    end  -- feature code_5


    scancode_6 : INTEGER is
    -- The code for the 6 key
    once
        c_inline_c("R=KEY_6;")
    end  -- feature code_6


    scancode_7 : INTEGER is
    -- The code for the 7 key
    once
        c_inline_c("R=KEY_7;")
    end  -- feature code_7


    scancode_8 : INTEGER is
    -- The code for the 8 key
    once
        c_inline_c("R=KEY_8;")
    end  -- feature code_8


    scancode_9 : INTEGER is
    -- The code for the 9 key
    once
        c_inline_c("R=KEY_9;")
    end  -- feature code_9


    scancode_0 : INTEGER is
    -- The code for the 0 key
    once
        c_inline_c("R=KEY_0;")
    end  -- feature code_0


    scancode_minus : INTEGER is
    -- The code for the minus (-) key
    once
        c_inline_c("R=KEY_MINUS;")
    end  -- feature code_minus


    scancode_equals : INTEGER is
    -- The code for the equals (=) key
    once
        c_inline_c("R=KEY_EQUALS;")
    end  -- feature code_equals


    scancode_backspace : INTEGER is
    -- The code for the backspace key
    once
        c_inline_c("R=KEY_BACKSPACE;")
    end  -- feature code_backspace


    scancode_tab : INTEGER is
    -- The code for the tab key
    once
        c_inline_c("R=KEY_TAB;")
    end  -- feature code_tab


    scancode_q : INTEGER is
    -- The code for the q key
    once
        c_inline_c("R=KEY_Q;")
    end  -- feature code_q


    scancode_w : INTEGER is
    -- The code for the w key
    once
        c_inline_c("R=KEY_W;")
    end  -- feature code_w


    scancode_e : INTEGER is
    -- The code for the e key
    once
        c_inline_c("R=KEY_E;")
    end  -- feature code_e


    scancode_r : INTEGER is
    -- The code for the r key
    once
        c_inline_c("R=KEY_R;")
    end  -- feature code_r


    scancode_t : INTEGER is
    -- The code for the t key
    once
        c_inline_c("R=KEY_T;")
    end  -- feature code_t


    scancode_y : INTEGER is
    -- The code for the y key
    once
        c_inline_c("R=KEY_Y;")
    end  -- feature code_y


    scancode_u : INTEGER is
    -- The code for the u key
    once
        c_inline_c("R=KEY_U;")
    end  -- feature code_u


    scancode_i : INTEGER is
    -- The code for the i key
    once
        c_inline_c("R=KEY_I;")
    end  -- feature code_i


    scancode_o : INTEGER is
    -- The code for the o key
    once
        c_inline_c("R=KEY_O;")
    end  -- feature code_o


    scancode_p : INTEGER is
    -- The code for the p key
    once
        c_inline_c("R=KEY_P;")
    end  -- feature code_p


    scancode_openbrace : INTEGER is
    -- The code for the openbrace ([) key
    once
        c_inline_c("R=KEY_OPENBRACE;")
    end  -- feature code_openbrace


    scancode_closebrace : INTEGER is
    -- The code for the closebrace (]) key
    once
        c_inline_c("R=KEY_CLOSEBRACE;")
    end  -- feature code_closebrace


    scancode_enter : INTEGER is
    -- The code for the enter key
    once
        c_inline_c("R=KEY_ENTER;")
    end  -- feature code_enter


    scancode_control : INTEGER is
    -- The code for the control key
    once
        c_inline_c("R=KEY_CONTROL;")
    end  -- feature code_control


    scancode_a : INTEGER is
    -- The code for the a key
    once
        c_inline_c("R=KEY_A;")
    end  -- feature code_a


    scancode_s : INTEGER is
    -- The code for the s key
    once
        c_inline_c("R=KEY_S;")
    end  -- feature code_s


    scancode_d : INTEGER is
    -- The code for the d key
    once
        c_inline_c("R=KEY_D;")
    end  -- feature code_d


    scancode_f : INTEGER is
    -- The code for the f key
    once
        c_inline_c("R=KEY_F;")
    end  -- feature code_f


    scancode_g : INTEGER is
    -- The code for the g key
    once
        c_inline_c("R=KEY_G;")
    end  -- feature code_g


    scancode_h : INTEGER is
    -- The code for the h key
    once
        c_inline_c("R=KEY_H;")
    end  -- feature code_h


    scancode_j : INTEGER is
    -- The code for the j key
    once
        c_inline_c("R=KEY_J;")
    end  -- feature code_j


    scancode_k : INTEGER is
    -- The code for the k key
    once
        c_inline_c("R=KEY_K;")
    end  -- feature code_k


    scancode_l : INTEGER is
    -- The code for the l key
    once
        c_inline_c("R=KEY_L;")
    end  -- feature code_l


    scancode_colon : INTEGER is
    -- The code for the colon (;) key
    once
        c_inline_c("R=KEY_COLON;")
    end  -- feature code_colon


    scancode_quote : INTEGER is
    -- The code for the quote (') key
    once
        c_inline_c("R=KEY_QUOTE;")
    end  -- feature code_quote


    scancode_tilde : INTEGER is
    -- The code for the unshifted tilde (`) key
    once
        c_inline_c("R=KEY_TILDE;")
    end  -- feature code_tilde


    scancode_leftshift : INTEGER is
    -- The code for the left shift key
    once
        c_inline_c("R=KEY_LSHIFT;")
    end  -- feature code_leftshift


    scancode_backslash : INTEGER is
    -- The code for the backslash key
    once
        c_inline_c("R=KEY_BACKSLASH;")
    end  -- feature code_backslash


    scancode_z : INTEGER is
    -- The code for the z key
    once
        c_inline_c("R=KEY_Z;")
    end  -- feature code_z


    scancode_x : INTEGER is
    -- The code for the x key
    once
        c_inline_c("R=KEY_X;")
    end  -- feature code_x


    scancode_c : INTEGER is
    -- The code for the c key
    once
        c_inline_c("R=KEY_C;")
    end  -- feature code_c


    scancode_v : INTEGER is
    -- The code for the v key
    once
        c_inline_c("R=KEY_V;")
    end  -- feature code_v


    scancode_b : INTEGER is
    -- The code for the b key
    once
        c_inline_c("R=KEY_B;")
    end  -- feature code_b


    scancode_n : INTEGER is
    -- The code for the n key
    once
        c_inline_c("R=KEY_N;")
    end  -- feature code_n


    scancode_m : INTEGER is
    -- The code for the m key
    once
        c_inline_c("R=KEY_M;")
    end  -- feature code_m


    scancode_comma : INTEGER is
    -- The code for the comma (,) key
    once
        c_inline_c("R=KEY_COMMA;")
    end  -- feature code_comma


    scancode_stop : INTEGER is
    -- The code for the stop (.) key
    once
        c_inline_c("R=KEY_STOP;")
    end  -- feature code_stop


    scancode_slash : INTEGER is
    -- The code for the slash '/' key
    once
        c_inline_c("R=KEY_SLASH;")
    end  -- feature code_slash


    scancode_rightshift : INTEGER is
    -- The code for the right shift key
    once
        c_inline_c("R=KEY_RSHIFT;")
    end  -- feature code_rightshift


    scancode_asterisk : INTEGER is
    -- The code for the asterisk (*) key
    once
        c_inline_c("R=KEY_ASTERISK;")
    end  -- feature code_asterisk


    scancode_alt : INTEGER is
    -- The code for the alt key
    once
        c_inline_c("R=KEY_ALT;")
    end  -- feature code_alt


    scancode_space : INTEGER is
    -- The code for the spacebar
    once
        c_inline_c("R=KEY_SPACE;")
    end  -- feature code_space


    scancode_capslock : INTEGER is
    -- The code for the capslock key
    once
        c_inline_c("R=KEY_CAPSLOCK;")
    end  -- feature code_capslock


    scancode_f1 : INTEGER is
    -- The code for the F1 key
    once
        c_inline_c("R=KEY_F1;")
    end  -- feature code_f1


    scancode_f2 : INTEGER is
    -- The code for the F2 key
    once
        c_inline_c("R=KEY_F2;")
    end  -- feature code_f2


    scancode_f3 : INTEGER is
    -- The code for the F3 key
    once
        c_inline_c("R=KEY_F3;")
    end  -- feature code_f3


    scancode_f4 : INTEGER is
    -- The code for the F4 key
    once
        c_inline_c("R=KEY_F4;")
    end  -- feature code_f4


    scancode_f5 : INTEGER is
    -- The code for the F5 key
    once
        c_inline_c("R=KEY_F5;")
    end  -- feature code_f5


    scancode_f6 : INTEGER is
    -- The code for the F6 key
    once
        c_inline_c("R=KEY_F6;")
    end  -- feature code_f6


    scancode_f7 : INTEGER is
    -- The code for the F7 key
    once
        c_inline_c("R=KEY_F7;")
    end  -- feature code_f7


    scancode_f8 : INTEGER is
    -- The code for the F8 key
    once
        c_inline_c("R=KEY_F8;")
    end  -- feature code_f8


    scancode_f9 : INTEGER is
    -- The code for the F9 key
    once
        c_inline_c("R=KEY_F9;")
    end  -- feature code_f9


    scancode_f10 : INTEGER is
    -- The code for the F10 key
    once
        c_inline_c("R=KEY_F10;")
    end  -- feature code_f10


    scancode_numlock : INTEGER is
    -- The code for the num lock key
    once
        c_inline_c("R=KEY_NUMLOCK;")
    end  -- feature code_numlock


    scancode_scrolllock : INTEGER is
    -- The code for the scroll lock key
    once
        c_inline_c("R=KEY_SCRLOCK;")
    end  -- feature code_scrolllock


    scancode_home : INTEGER is
    -- The code for the home key
    once
        c_inline_c("R=KEY_HOME;")
    end  -- feature code_home


    scancode_up : INTEGER is
    -- The code for the up key
    once
        c_inline_c("R=KEY_UP;")
    end  -- feature code_up


    scancode_pageup : INTEGER is
    -- The code for the page up key
    once
        c_inline_c("R=KEY_PGUP;")
    end  -- feature code_pageup


    scancode_keypad_minus : INTEGER is
    -- The code for the keypad minus key
    once
        c_inline_c("R=KEY_MINUS_PAD;")
    end  -- feature code_keypad_minus


    scancode_left : INTEGER is
    -- The code for the left key
    once
        c_inline_c("R=KEY_LEFT;")
    end  -- feature code_left


    scancode_keypad_5 : INTEGER is
    -- The code for the keypad 5 key
    once
        c_inline_c("R=KEY_5_PAD;")
    end  -- feature code_keypad_5


    scancode_right : INTEGER is
    -- The code for the right key
    once
        c_inline_c("R=KEY_RIGHT;")
    end  -- feature code_right


    scancode_keypad_plus : INTEGER is
    -- The code for the keypad plus key
    once
        c_inline_c("R=KEY_PLUS_PAD;")
    end  -- feature code_keypad_plus


    scancode_end : INTEGER is
    -- The code for the end key
    once
        c_inline_c("R=KEY_END;")
    end  -- feature code_end


    scancode_down : INTEGER is
    -- The code for the down key
    once
        c_inline_c("R=KEY_DOWN;")
    end  -- feature code_down


    scancode_pagedown : INTEGER is
    -- The code for the page down key
    once
        c_inline_c("R=KEY_PGDN;")
    end  -- feature code_pagedown


    scancode_insert : INTEGER is
    -- The code for the insert key
    once
        c_inline_c("R=KEY_INSERT;")
    end  -- feature code_insert


    scancode_delete : INTEGER is
    -- The code for the delete key
    once
        c_inline_c("R=KEY_DEL;")
    end  -- feature code_delete


    scancode_f11 : INTEGER is
    -- The code for the F11 key
    once
        c_inline_c("R=KEY_F11;")
    end  -- feature code_f11


    scancode_f12 : INTEGER is
    -- The code for the F12 key
    once
        c_inline_c("R=KEY_F12;")
    end  -- feature code_f12


    scancode_pad : INTEGER is
    -- Defined in Allegro (I don't know what key this is, though!)
    once
        c_inline_c("R=KEY_PAD;")
    end  -- feature code_pad


------------------------------------------------------ Datafile object types
feature { ANY }

    object_bitmap : INTEGER is
    -- The type code for a bitmap
    once
        c_inline_c("R=DAT_BITMAP;")
    end  -- feature object_bitmap


    object_rle_sprite : INTEGER is
    -- The type code for an rle_sprite
    once
        c_inline_c("R=DAT_RLE_SPRITE;")
    end  -- feature object_rle_sprite


    object_compiled_sprite : INTEGER is
    -- The type code for a compiled_sprite
    once
        c_inline_c("R=DAT_C_SPRITE;")
    end  -- feature object_compiled_sprite


    object_planar_compiled_sprite : INTEGER is
    -- The type code for a planar_compiled_sprite
    once
        c_inline_c("R=DAT_XC_SPRITE;")
    end  -- feature object_planar_compiled_sprite


    object_palette : INTEGER is
    -- The type code for a palette
    once
        c_inline_c("R=DAT_PALETTE;")
    end  -- feature object_palette


    object_font : INTEGER is
    -- The type code for a font
    once
        c_inline_c("R=DAT_FONT;")
    end  -- feature object_font


    object_sample : INTEGER is
    -- The type code for a sample
    once
        c_inline_c("R=DAT_SAMPLE;")
    end  -- feature object_sample


    object_midi : INTEGER is
    -- The type code for a midi sequence
    once
        c_inline_c("R=DAT_MIDI;")
    end  -- feature object_midi


    object_flic : INTEGER is
    -- The type code for a fli/flc animation
    once
        c_inline_c("R=DAT_FLI;")
    end  -- feature object_flic


------------------------------------------------------ Soundcard drivers scancodes
feature { ANY }

    digital_none : INTEGER is
    -- No digital driver
    once
        c_inline_c("R=DIGI_NONE;")
    end  -- feature digital_none


    digital_autodetect : INTEGER is
    -- Autodetection digital driver
    once
        c_inline_c("R=DIGI_AUTODETECT;")
    end  -- feature digital_autodetect


    digital_autodetect_soundblaster : INTEGER is
    -- Autodetection of sound blaster
    once
        c_inline_c("R=DIGI_SB;")
    end  -- feature digital_autodetect_soundblaster


    digital_soundblaster_1 : INTEGER is
    -- Soundblaster v1.0 driver
    once
        c_inline_c("R=DIGI_SB10;")
    end  -- feature digital_soundblaster_1


    digital_soundblaster_1_5 : INTEGER is
    -- Soundblaster v1.5 driver
    once
        c_inline_c("R=DIGI_SB15;")
    end  -- feature digital_soundblaster_1_5


    digital_soundblaster_2 : INTEGER is
    -- Soundblaster v2.0 driver
    once
        c_inline_c("R=DIGI_SB20;")
    end  -- feature digital_soundblaster_2


    digital_soundblaster_pro : INTEGER is
    -- Soundblaster Pro driver
    once
        c_inline_c("R=DIGI_SBPRO;")
    end  -- feature digital_soundblaster_pro


    digital_soundblaster_16 : INTEGER is
    -- Soundblaster 16 driver
    once
        c_inline_c("R=DIGI_SB16;")
    end  -- feature digital_soundblaster_16


--    digital_gus : INTEGER is
--    -- GUS driver (not written yet)
--    once
--        c_inline_c("R=DIGI_GUS;")
--    end  -- feature digital_gus


      midi_none : INTEGER is
      -- No MIDI driver
      once
          c_inline_c("R=MIDI_NONE;")
      end  -- feature midi_none


      midi_autodetect : INTEGER is
      -- Autodetection MIDI driver
      once
          c_inline_c("R=MIDI_AUTODETECT;")
      end  -- feature midi_autodetect


      midi_adlib : INTEGER is
      -- Adlib MIDI driver
      once
          c_inline_c("R=MIDI_ADLIB;")
      end  -- feature midi_adlib


      midi_opl2 : INTEGER is
      -- OPL2 MIDI driver
      once
          c_inline_c("R=MIDI_OPL2;")
      end  -- feature midi_opl2


      midi_2xopl2 : INTEGER is
      -- Dual OPL2 MIDI driver
      once
          c_inline_c("R=MIDI_2XOPL2;")
      end  -- feature midi_2xopl2


      midi_opl3 : INTEGER is
      -- OPL3 MIDI driver
      once
          c_inline_c("R=MIDI_OPL3;")
      end  -- feature midi_opl3


      midi_sb_out : INTEGER is
      -- Soundblaster MIDI interface MIDI driver
      once
          c_inline_c("R=MIDI_SB_OUT;")
      end  -- feature midi_sb_out


      midi_mpu : INTEGER is
      -- MPU-401 MIDI driver
      once
          c_inline_c("R=MIDI_MPU;")
      end  -- feature midi_mpu


--      midi_gus : INTEGER is
--      -- GUS MIDI driver (not written yet)
--      once
--          c_inline_c("R=MIDI_GUS;")
--      end  -- feature midi_gus


--        midi_digmid : INTEGER is
--        -- Digital MIDI driver (not written yet)
--        once
--            c_inline_c("R=MIDI_DIGMID;")
--        end  -- feature midi_digmid


------------------------------------------------------ Class invariant
invariant

    graphics_flag_valid : graphics_initialised implies ace_initialised
    timer_flag_valid    : timer_initialised    implies ace_initialised
    retrace_simulator_flag_valid : retrace_simulator_initialised implies timer_initialised
    mouse_installed_flag_valid : mouse_installed implies ace_initialised
    joystick_installed_flag_valid : joystick_installed implies ace_initialised
    keyboard_initialised_flag_valid : keyboard_initialised implies ace_initialised
    soundcard_initialised_flag_valid : soundcard_initialised implies ace_initialised


end  -- class ACE_INFORMATION
