"======================================================================
|
|   TCPSocketImpl
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


SocketImpl subclass: #TCPSocketImpl
	   instanceVariableNames: ''
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!TCPSocketImpl methodsFor: 'implementation'!

accept: implementationClass
    | peer sizePtr newFD |
    peer := ByteArray new: CSockAddrStruct sizeof.
    sizePtr := ByteArray new: CInt sizeof.
    sizePtr intAt: 1 put: CSockAddrStruct sizeof.

    newFD := self
	accept: self fd
	peer: peer
	addrLen: sizePtr.

    ^(implementationClass on: newFD)
	hasBeenBound;
	hasBeenConnectedTo: peer;
	yourself
!

bindTo: ipAddress port: port
    | addr |
    addr := ipAddress port: port.
    [
        self bind: self fd to: addr addrLen: addr size.
        File checkError.
    ]   ifCurtailed: [ self nowDead; close ].
    self isOpen ifTrue: [ self hasBeenBound ]
!

connectTo: ipAddress port: port
    | addr |
    addr := ipAddress port: port.
    [
        self connect: self fd to: addr addrLen: addr size.
        File checkError.
    ]   ifCurtailed: [ self nowDead; close ].
    self isOpen	ifTrue: [ self hasBeenConnected ]
!

create
    | descriptor |
    descriptor := self
	create: IPAddress pfInet
	type: self class sockStream
	protocol: 0.

    File checkError.
    self initFd: descriptor
!

getPeerName
    | peer sizePtr |
    peer := ByteArray new: CSockAddrStruct sizeof.
    sizePtr := ByteArray new: CInt sizeof.
    sizePtr intAt: 1 put: CSockAddrStruct sizeof.

    self
	getPeerName: self fd
	addr: peer
	addrLen: sizePtr.

    ^peer
!

getSockName
    | sock sizePtr |
    sock := ByteArray new: CSockAddrStruct sizeof.
    sizePtr := ByteArray new: CInt sizeof.
    sizePtr intAt: 1 put: CSockAddrStruct sizeof.

    self
	getSockName: self fd
	addr: sock
	addrLen: sizePtr.

    ^sock
!

listen: backlog
    self listen: self fd log: backlog
!

optionAt: opt level: level size: size
    | result |
    result := ByteArray new: size.
    self
	option: self fd
	level: level 
	at: opt
	get: result
	size: size.
    ^result
!

optionAt: opt level: level put: anObject
    | ba |
    ba := self makeByteArray: anObject.
    self
	option: self fd
	level: level
	at: opt
	put: ba
	size: ba size.
! !

