"======================================================================
|
|   Smalltalk TCP/IP sockets - Abstract socket class
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Stream subclass: #AbstractSocket
	  instanceVariableNames: 'impl'
	  classVariableNames: 'CheckPeriod Timeout'
	  poolDictionaries: ''
	  category: 'Sockets-Streams'
!

AbstractSocket class instanceVariableNames: 'defaultImplementationClass'!

!AbstractSocket class methodsFor: 'timed-out operations'!

checkPeriod
    ^CheckPeriod
!

checkPeriod: anInteger
    CheckPeriod := anInteger truncated
!

timeout
    ^Timeout
!

timeout: anInteger
    Timeout := anInteger truncated
! !

!AbstractSocket class methodsFor: 'accessing'!

defaultImplementationClass
    ^defaultImplementationClass
!

defaultImplementationClass: aClass
    defaultImplementationClass := aClass
! !

!AbstractSocket class methodsFor: 'instance creation'!

new: implementation
    ^super new initialize: implementation
!

new
    ^self new: self defaultImplementationClass new
! !

!AbstractSocket methodsFor: 'accessing'!

address
    self subclassResponsibility
!

available
    ^self implementation canRead
!

close
    self flush.
    self implementation close.
!

flush
!

isOpen
    self implementation isNil ifFalse: [ ^false ].
    ^self implementation isOpen
!

localAddress
    self implementation isNil ifTrue: [ self error: 'socket not connected' ].
    ^self implementation localAddress
!

localPort
    self implementation isNil ifTrue: [ self error: 'socket not connected' ].
    ^self implementation localPort
!

port
    self subclassResponsibility
!

remoteAddress
    self implementation isNil ifTrue: [ self error: 'socket not connected' ].
    ^self implementation remoteAddress
!

remotePort
    self implementation isNil ifTrue: [ self error: 'socket not connected' ].
    ^self implementation remotePort
!

soTimeout
    self implementation isNil ifTrue: [ self error: 'socket not connected' ].
    ^self implementation soTimeout
!

soTimeout: timeout
    self implementation isNil ifTrue: [ self error: 'socket not connected' ].
    ^self implementation soTimeout: timeout
! !

!AbstractSocket methodsFor: 'printing'!

printOn: aStream
    aStream
	print: self class;
	nextPut: $[;
	print: self address;
	nextPut: $: ;
	print: self port;
	nextPutAll: ']'
! !

!AbstractSocket methodsFor: 'private'!

implementation
    ^impl
!

initialize: implementation
    impl := implementation.
!

waitUntil: aBlock then: resultBlock onTimeoutDo: timeoutBlock

    Timeout // CheckPeriod timesRepeat: [
	aBlock value ifTrue: [ ^resultBlock value ].
	(Delay forMilliseconds: CheckPeriod) wait
    ].
    self close.
    ^timeoutBlock value.
! !

!AbstractSocket class methodsFor: 'stream protocol'!

atEnd
    ^false
!

next
    ^self implementation next
!

nextPut: char
    ^self implementation nextPut: char
! !

AbstractSocket timeout: 30000; checkPeriod: 1000!