			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-001

Bug-Reported-by:	Juergen Daubert <jue@jue.li>
Bug-Reference-ID:	<20110214175132.GA19813@jue.netz>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-02/msg00125.html

Bug-Description:

When running in Posix mode, bash does not correctly expand the right-hand
side of a double-quoted word expansion containing single quotes.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2011-01-02 16:12:51.000000000 -0500
--- subst.c	2011-02-19 00:00:00.000000000 -0500
***************
*** 1380,1387 ****
  
    /* The handling of dolbrace_state needs to agree with the code in parse.y:
!      parse_matched_pair() */
!   dolbrace_state = 0;
!   if (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES))
!     dolbrace_state = (flags & SX_POSIXEXP) ? DOLBRACE_QUOTE : DOLBRACE_PARAM;
  
    i = *sindex;
--- 1380,1389 ----
  
    /* The handling of dolbrace_state needs to agree with the code in parse.y:
!      parse_matched_pair().  The different initial value is to handle the
!      case where this function is called to parse the word in
!      ${param op word} (SX_WORD). */
!   dolbrace_state = (flags & SX_WORD) ? DOLBRACE_WORD : DOLBRACE_PARAM;
!   if ((quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES)) && (flags & SX_POSIXEXP))
!     dolbrace_state = DOLBRACE_QUOTE;
  
    i = *sindex;
***************
*** 7177,7181 ****
        /* Extract the contents of the ${ ... } expansion
  	 according to the Posix.2 rules. */
!       value = extract_dollar_brace_string (string, &sindex, quoted, (c == '%' || c == '#') ? SX_POSIXEXP : 0);
        if (string[sindex] == RBRACE)
  	sindex++;
--- 7181,7185 ----
        /* Extract the contents of the ${ ... } expansion
  	 according to the Posix.2 rules. */
!       value = extract_dollar_brace_string (string, &sindex, quoted, (c == '%' || c == '#' || c =='/' || c == '^' || c == ',' || c ==':') ? SX_POSIXEXP|SX_WORD : SX_WORD);
        if (string[sindex] == RBRACE)
  	sindex++;
*** ../bash-4.2-patched/subst.h	2010-12-02 20:21:29.000000000 -0500
--- subst.h	2011-02-16 21:12:09.000000000 -0500
***************
*** 57,60 ****
--- 57,61 ----
  #define SX_ARITHSUB	0x0080	/* extracting $(( ... )) (currently unused) */
  #define SX_POSIXEXP	0x0100	/* extracting new Posix pattern removal expansions in extract_dollar_brace_string */
+ #define SX_WORD		0x0200	/* extracting word in ${param op word} */
  
  /* Remove backslashes which are quoting backquotes from STRING.  Modifies
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 0
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 1
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-002

Bug-Reported-by:	Clark J. Wang <dearvoid@gmail.com>
Bug-Reference-ID:	<AANLkTimGbW7aC4E5infXP6ku5WPci4t=xVc+L1SyHqrD@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-02/msg00157.html

Bug-Description:

The readline vi-mode `cc', `dd', and `yy' commands failed to modify the
entire line.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/readline/vi_mode.c	2010-11-20 19:51:39.000000000 -0500
--- lib/readline/vi_mode.c	2011-02-17 20:24:25.000000000 -0500
***************
*** 1115,1119 ****
        _rl_vi_last_motion = c;
        RL_UNSETSTATE (RL_STATE_VIMOTION);
!       return (0);
      }
  #if defined (READLINE_CALLBACKS)
--- 1115,1119 ----
        _rl_vi_last_motion = c;
        RL_UNSETSTATE (RL_STATE_VIMOTION);
!       return (vidomove_dispatch (m));
      }
  #if defined (READLINE_CALLBACKS)
*** ../bash-4.2-patched/lib/readline/callback.c	2010-06-06 12:18:58.000000000 -0400
--- lib/readline/callback.c	2011-02-17 20:43:28.000000000 -0500
***************
*** 149,152 ****
--- 149,155 ----
  	  /* Should handle everything, including cleanup, numeric arguments,
  	     and turning off RL_STATE_VIMOTION */
+ 	  if (RL_ISSTATE (RL_STATE_NUMERICARG) == 0)
+ 	    _rl_internal_char_cleanup ();
+ 
  	  return;
  	}
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 1
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 2
  
  #endif /* _PATCHLEVEL_H_ */

			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-003

Bug-Reported-by:	Clark J. Wang <dearvoid@gmail.com>
Bug-Reference-ID:	<AANLkTikZ_rVV-frR8Fh0PzhXnMKnm5XsUR-F3qtPPs5G@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-02/msg00136.html

Bug-Description:

When using the pattern replacement and pattern removal word expansions, bash
miscalculates the possible match length in the presence of an unescaped left
bracket without a closing right bracket, resulting in a failure to match
the pattern.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/glob/gmisc.c	2011-02-05 16:11:17.000000000 -0500
--- lib/glob/gmisc.c	2011-02-18 23:53:42.000000000 -0500
***************
*** 78,83 ****
       size_t wmax;
  {
!   wchar_t wc, *wbrack;
!   int matlen, t, in_cclass, in_collsym, in_equiv;
  
    if (*wpat == 0)
--- 78,83 ----
       size_t wmax;
  {
!   wchar_t wc;
!   int matlen, bracklen, t, in_cclass, in_collsym, in_equiv;
  
    if (*wpat == 0)
***************
*** 119,123 ****
  	case L'[':
  	  /* scan for ending `]', skipping over embedded [:...:] */
! 	  wbrack = wpat;
  	  wc = *wpat++;
  	  do
--- 119,123 ----
  	case L'[':
  	  /* scan for ending `]', skipping over embedded [:...:] */
! 	  bracklen = 1;
  	  wc = *wpat++;
  	  do
***************
*** 125,140 ****
  	      if (wc == 0)
  		{
! 	          matlen += wpat - wbrack - 1;	/* incremented below */
! 	          break;
  	        }
  	      else if (wc == L'\\')
  		{
! 		  wc = *wpat++;
! 		  if (*wpat == 0)
! 		    break;
  		}
  	      else if (wc == L'[' && *wpat == L':')	/* character class */
  		{
  		  wpat++;
  		  in_cclass = 1;
  		}
--- 125,148 ----
  	      if (wc == 0)
  		{
! 		  wpat--;			/* back up to NUL */
! 	          matlen += bracklen;
! 	          goto bad_bracket;
  	        }
  	      else if (wc == L'\\')
  		{
! 		  /* *wpat == backslash-escaped character */
! 		  bracklen++;
! 		  /* If the backslash or backslash-escape ends the string,
! 		     bail.  The ++wpat skips over the backslash escape */
! 		  if (*wpat == 0 || *++wpat == 0)
! 		    {
! 		      matlen += bracklen;
! 		      goto bad_bracket;
! 		    }
  		}
  	      else if (wc == L'[' && *wpat == L':')	/* character class */
  		{
  		  wpat++;
+ 		  bracklen++;
  		  in_cclass = 1;
  		}
***************
*** 142,145 ****
--- 150,154 ----
  		{
  		  wpat++;
+ 		  bracklen++;
  		  in_cclass = 0;
  		}
***************
*** 147,152 ****
  		{
  		  wpat++;
  		  if (*wpat == L']')	/* right bracket can appear as collating symbol */
! 		    wpat++;
  		  in_collsym = 1;
  		}
--- 156,165 ----
  		{
  		  wpat++;
+ 		  bracklen++;
  		  if (*wpat == L']')	/* right bracket can appear as collating symbol */
! 		    {
! 		      wpat++;
! 		      bracklen++;
! 		    }
  		  in_collsym = 1;
  		}
***************
*** 154,157 ****
--- 167,171 ----
  		{
  		  wpat++;
+ 		  bracklen++;
  		  in_collsym = 0;
  		}
***************
*** 159,164 ****
  		{
  		  wpat++;
  		  if (*wpat == L']')	/* right bracket can appear as equivalence class */
! 		    wpat++;
  		  in_equiv = 1;
  		}
--- 173,182 ----
  		{
  		  wpat++;
+ 		  bracklen++;
  		  if (*wpat == L']')	/* right bracket can appear as equivalence class */
! 		    {
! 		      wpat++;
! 		      bracklen++;
! 		    }
  		  in_equiv = 1;
  		}
***************
*** 166,174 ****
--- 184,196 ----
  		{
  		  wpat++;
+ 		  bracklen++;
  		  in_equiv = 0;
  		}
+ 	      else
+ 		bracklen++;
  	    }
  	  while ((wc = *wpat++) != L']');
  	  matlen++;		/* bracket expression can only match one char */
+ bad_bracket:
  	  break;
  	}
***************
*** 214,219 ****
       size_t max;
  {
!   char c, *brack;
!   int matlen, t, in_cclass, in_collsym, in_equiv;
  
    if (*pat == 0)
--- 236,241 ----
       size_t max;
  {
!   char c;
!   int matlen, bracklen, t, in_cclass, in_collsym, in_equiv;
  
    if (*pat == 0)
***************
*** 255,259 ****
  	case '[':
  	  /* scan for ending `]', skipping over embedded [:...:] */
! 	  brack = pat;
  	  c = *pat++;
  	  do
--- 277,281 ----
  	case '[':
  	  /* scan for ending `]', skipping over embedded [:...:] */
! 	  bracklen = 1;
  	  c = *pat++;
  	  do
***************
*** 261,276 ****
  	      if (c == 0)
  		{
! 	          matlen += pat - brack - 1;	/* incremented below */
! 	          break;
  	        }
  	      else if (c == '\\')
  		{
! 		  c = *pat++;
! 		  if (*pat == 0)
! 		    break;
  		}
  	      else if (c == '[' && *pat == ':')	/* character class */
  		{
  		  pat++;
  		  in_cclass = 1;
  		}
--- 283,306 ----
  	      if (c == 0)
  		{
! 		  pat--;			/* back up to NUL */
! 		  matlen += bracklen;
! 		  goto bad_bracket;
  	        }
  	      else if (c == '\\')
  		{
! 		  /* *pat == backslash-escaped character */
! 		  bracklen++;
! 		  /* If the backslash or backslash-escape ends the string,
! 		     bail.  The ++pat skips over the backslash escape */
! 		  if (*pat == 0 || *++pat == 0)
! 		    {
! 		      matlen += bracklen;
! 		      goto bad_bracket;
! 		    }
  		}
  	      else if (c == '[' && *pat == ':')	/* character class */
  		{
  		  pat++;
+ 		  bracklen++;
  		  in_cclass = 1;
  		}
***************
*** 278,281 ****
--- 308,312 ----
  		{
  		  pat++;
+ 		  bracklen++;
  		  in_cclass = 0;
  		}
***************
*** 283,288 ****
  		{
  		  pat++;
  		  if (*pat == ']')	/* right bracket can appear as collating symbol */
! 		    pat++;
  		  in_collsym = 1;
  		}
--- 314,323 ----
  		{
  		  pat++;
+ 		  bracklen++;
  		  if (*pat == ']')	/* right bracket can appear as collating symbol */
! 		    {
! 		      pat++;
! 		      bracklen++;
! 		    }
  		  in_collsym = 1;
  		}
***************
*** 290,293 ****
--- 325,329 ----
  		{
  		  pat++;
+ 		  bracklen++;
  		  in_collsym = 0;
  		}
***************
*** 295,300 ****
  		{
  		  pat++;
  		  if (*pat == ']')	/* right bracket can appear as equivalence class */
! 		    pat++;
  		  in_equiv = 1;
  		}
--- 331,340 ----
  		{
  		  pat++;
+ 		  bracklen++;
  		  if (*pat == ']')	/* right bracket can appear as equivalence class */
! 		    {
! 		      pat++;
! 		      bracklen++;
! 		    }
  		  in_equiv = 1;
  		}
***************
*** 302,310 ****
--- 342,354 ----
  		{
  		  pat++;
+ 		  bracklen++;
  		  in_equiv = 0;
  		}
+ 	      else
+ 		bracklen++;
  	    }
  	  while ((c = *pat++) != ']');
  	  matlen++;		/* bracket expression can only match one char */
+ bad_bracket:
  	  break;
  	}
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 2
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 3
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-004

Bug-Reported-by:	Mike Frysinger <vapier@gentoo.org>
Bug-Reference-ID:	<201102182106.17834.vapier@gentoo.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-02/msg00222.html

Bug-Description:

When used in contexts where word splitting and quote removal were not
performed, such as pattern removal or pattern substitution, empty strings
(either literal or resulting from quoted variables that were unset or
null) were not matched correctly, resulting in failure.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2011-01-02 16:12:51.000000000 -0500
--- subst.c	2011-02-18 22:30:13.000000000 -0500
***************
*** 3373,3379 ****
    if (string == 0 || *string == '\0')
      return (WORD_LIST *)NULL;
  
!   td.flags = 0;
    td.word = string;
    tresult = call_expand_word_internal (&td, quoted, 1, dollar_at_p, has_dollar_at);
    return (tresult);
--- 3373,3379 ----
    if (string == 0 || *string == '\0')
      return (WORD_LIST *)NULL;
  
!   td.flags = W_NOSPLIT2;		/* no splitting, remove "" and '' */
    td.word = string;
    tresult = call_expand_word_internal (&td, quoted, 1, dollar_at_p, has_dollar_at);
    return (tresult);
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 3
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 4
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-005

Bug-Reported-by:	Dennis Williamson <dennistwilliamson@gmail.com>
Bug-Reference-ID:	<AANLkTikDbEV5rnbPc0zOfmZfBcg0xGetzLLzK+KjRiNa@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-02/msg00147.html

Bug-Description:

Systems that use tzset() to set the local timezone require the TZ variable
to be in the environment.  Bash must make sure the environment has been
modified with any updated value for TZ before calling tzset().  This
affects prompt string expansions and the `%T' printf conversion specification
on systems that do not allow bash to supply a replacement for getenv(3).

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/variables.h	2010-12-02 20:22:01.000000000 -0500
--- variables.h	2011-02-19 19:57:12.000000000 -0500
***************
*** 314,317 ****
--- 314,318 ----
  extern void sort_variables __P((SHELL_VAR **));
  
+ extern int chkexport __P((char *));
  extern void maybe_make_export_env __P((void));
  extern void update_export_env_inplace __P((char *, int, char *));
*** ../bash-4.2-patched/variables.c	2011-01-24 20:07:48.000000000 -0500
--- variables.c	2011-02-19 20:04:50.000000000 -0500
***************
*** 3654,3657 ****
--- 3654,3673 ----
  }
  
+ int
+ chkexport (name)
+      char *name;
+ {
+   SHELL_VAR *v;
+ 
+   v = find_variable (name);
+   if (exported_p (v))
+     {
+       array_needs_making = 1;
+       maybe_make_export_env ();
+       return 1;
+     }
+   return 0;
+ }
+ 
  void
  maybe_make_export_env ()
***************
*** 4215,4219 ****
    { "TEXTDOMAINDIR", sv_locale },
  
! #if defined (HAVE_TZSET) && defined (PROMPT_STRING_DECODE)
    { "TZ", sv_tz },
  #endif
--- 4231,4235 ----
    { "TEXTDOMAINDIR", sv_locale },
  
! #if defined (HAVE_TZSET)
    { "TZ", sv_tz },
  #endif
***************
*** 4559,4568 ****
  #endif /* HISTORY */
  
! #if defined (HAVE_TZSET) && defined (PROMPT_STRING_DECODE)
  void
  sv_tz (name)
       char *name;
  {
!   tzset ();
  }
  #endif
--- 4575,4585 ----
  #endif /* HISTORY */
  
! #if defined (HAVE_TZSET)
  void
  sv_tz (name)
       char *name;
  {
!   if (chkexport (name))
!     tzset ();
  }
  #endif
*** ../bash-4.2-patched/parse.y	2011-01-02 15:48:11.000000000 -0500
--- parse.y	2011-02-19 20:05:00.000000000 -0500
***************
*** 5136,5139 ****
--- 5136,5142 ----
  	      /* Make the current time/date into a string. */
  	      (void) time (&the_time);
+ #if defined (HAVE_TZSET)
+ 	      sv_tz ("TZ");		/* XXX -- just make sure */
+ #endif
  	      tm = localtime (&the_time);
  
*** ../bash-4.2-patched/builtins/printf.def	2010-11-23 10:02:55.000000000 -0500
--- builtins/printf.def	2011-02-19 20:05:04.000000000 -0500
***************
*** 466,469 ****
--- 466,472 ----
  		else
  		  secs = arg;
+ #if defined (HAVE_TZSET)
+ 		sv_tz ("TZ");		/* XXX -- just make sure */
+ #endif
  		tm = localtime (&secs);
  		n = strftime (timebuf, sizeof (timebuf), timefmt, tm);
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 4
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 5
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-006

Bug-Reported-by:	Allan McRae <allan@archlinux.org>
Bug-Reference-ID:	<4D6D0D0B.50908@archlinux.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-03/msg00001.html

Bug-Description:

A problem with bash42-005 caused it to dump core if TZ was unset.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/variables.c	2011-02-25 12:07:41.000000000 -0500
--- variables.c	2011-03-01 10:13:04.000000000 -0500
***************
*** 3661,3665 ****
  
    v = find_variable (name);
!   if (exported_p (v))
      {
        array_needs_making = 1;
--- 3661,3665 ----
  
    v = find_variable (name);
!   if (v && exported_p (v))
      {
        array_needs_making = 1;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 5
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 6
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-007

Bug-Reported-by:	Matthias Klose <doko@debian.org>
Bug-Reference-ID:	<4D6FD2AC.1010500@debian.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-03/msg00015.html

Bug-Description:

When used in contexts where word splitting and quote removal were not
performed, such as case statement word expansion, empty strings
(either literal or resulting from quoted variables that were unset or
null) were not expanded correctly, resulting in failure.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2011-02-25 12:03:58.000000000 -0500
--- subst.c	2011-03-03 14:08:23.000000000 -0500
***************
*** 4609,4614 ****
--- 4611,4617 ----
    if (ifs_firstc == 0)
  #endif
      word->flags |= W_NOSPLIT;
+   word->flags |= W_NOSPLIT2;
    result = call_expand_word_internal (word, quoted, 0, (int *)NULL, (int *)NULL);
    expand_no_split_dollar_star = 0;
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 6
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 7
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-008

Bug-Reported-by:	Doug McMahon <mc2man@optonline.net>
Bug-Reference-ID:	<1299441211.2535.11.camel@doug-XPS-M1330>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-03/msg00050.html

Bug-Description:

Bash-4.2 does not attempt to save the shell history on receipt of a
terminating signal that is handled synchronously.  Unfortunately, the
`close' button on most X11 terminal emulators sends SIGHUP, which
kills the shell.

This is a very small patch to save the history in the case that an
interactive shell receives a SIGHUP or SIGTERM while in readline and
reading a command.

The next version of bash will do this differently.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/sig.c	Tue Nov 23 08:21:22 2010
--- sig.c	Tue Mar  8 21:28:32 2011
***************
*** 47,50 ****
--- 47,51 ----
  #if defined (READLINE)
  #  include "bashline.h"
+ #  include <readline/readline.h>
  #endif
  
***************
*** 63,66 ****
--- 64,68 ----
  extern int history_lines_this_session;
  #endif
+ extern int no_line_editing;
  
  extern void initialize_siglist ();
***************
*** 506,510 ****
  #if defined (HISTORY)
        /* XXX - will inhibit history file being written */
!       history_lines_this_session = 0;
  #endif
        terminate_immediately = 0;
--- 508,515 ----
  #if defined (HISTORY)
        /* XXX - will inhibit history file being written */
! #  if defined (READLINE)
!       if (interactive_shell == 0 || interactive == 0 || (sig != SIGHUP && sig != SIGTERM) || no_line_editing || (RL_ISSTATE (RL_STATE_READCMD) == 0))
! #  endif
!         history_lines_this_session = 0;
  #endif
        terminate_immediately = 0;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 7
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 8
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-009

Bug-Reported-by:	<piuma@piumalab.org>
Bug-Reference-ID:	<4DAAC0DB.7060606@piumalab.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-04/msg00075.html

Bug-Description:

Under certain circumstances, running `fc -l' two times in succession with a
relative history offset at the end of the history will result in an incorrect
calculation of the last history entry and a seg fault.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/fc.def	2010-05-30 18:25:38.000000000 -0400
--- builtins/fc.def	2011-04-19 15:46:17.000000000 -0400
***************
*** 305,309 ****
  
    /* XXX */
!   if (saved_command_line_count > 0 && i == last_hist && hlist[last_hist] == 0)
      while (last_hist >= 0 && hlist[last_hist] == 0)
        last_hist--;
--- 305,309 ----
  
    /* XXX */
!   if (i == last_hist && hlist[last_hist] == 0)
      while (last_hist >= 0 && hlist[last_hist] == 0)
        last_hist--;
***************
*** 476,480 ****
  {
    int sign, n, clen, rh;
!   register int i, j;
    register char *s;
  
--- 476,480 ----
  {
    int sign, n, clen, rh;
!   register int i, j, last_hist;
    register char *s;
  
***************
*** 496,500 ****
       calculation as if it were on. */
    rh = remember_on_history || ((subshell_environment & SUBSHELL_COMSUB) && enable_history_list);
!   i -= rh + hist_last_line_added;
  
    /* No specification defaults to most recent command. */
--- 496,508 ----
       calculation as if it were on. */
    rh = remember_on_history || ((subshell_environment & SUBSHELL_COMSUB) && enable_history_list);
!   last_hist = i - rh - hist_last_line_added;
! 
!   if (i == last_hist && hlist[last_hist] == 0)
!     while (last_hist >= 0 && hlist[last_hist] == 0)
!       last_hist--;
!   if (last_hist < 0)
!     return (-1);
! 
!   i = last_hist;
  
    /* No specification defaults to most recent command. */
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 8
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 9
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-010

Bug-Reported-by:	Mike Frysinger <vapier@gentoo.org>
Bug-Reference-ID:	<201104122356.20160.vapier@gentoo.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-04/msg00058.html

Bug-Description:

Bash did not correctly print/reproduce here documents attached to commands
inside compound commands such as arithmetic for loops and user-specified
subshells.  This affected the execution of such commands inside a shell
function when the function definition is saved and later restored using
`.' or `eval'.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/print_cmd.c	2010-05-30 18:34:08.000000000 -0400
--- print_cmd.c	2011-04-14 10:43:18.000000000 -0400
***************
*** 316,319 ****
--- 317,321 ----
  	  skip_this_indent++;
  	  make_command_string_internal (command->value.Subshell->command);
+ 	  PRINT_DEFERRED_HEREDOCS ("");
  	  cprintf (" )");
  	  break;
***************
*** 593,596 ****
--- 606,610 ----
    indentation += indentation_amount;
    make_command_string_internal (arith_for_command->action);
+   PRINT_DEFERRED_HEREDOCS ("");
    semicolon ();
    indentation -= indentation_amount;
***************
*** 654,657 ****
--- 668,672 ----
  
    make_command_string_internal (group_command->command);
+   PRINT_DEFERRED_HEREDOCS ("");
  
    if (inside_function_def)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 9
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 10
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-011

Bug-Reported-by:	"David Parks" <davidparks21@yahoo.com>
Bug-Reference-ID:	<014101cc82c6$46ac1540$d4043fc0$@com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-10/msg00031.html

Bug-Description:

Overwriting a value in an associative array causes the memory allocated to
store the key on the second and subsequent assignments to leak.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/assoc.c	2009-08-05 20:19:40.000000000 -0400
--- assoc.c	2011-10-04 20:23:07.000000000 -0400
***************
*** 78,81 ****
--- 78,86 ----
    if (b == 0)
      return -1;
+   /* If we are overwriting an existing element's value, we're not going to
+      use the key.  Nothing in the array assignment code path frees the key
+      string, so we can free it here to avoid a memory leak. */
+   if (b->key != key)
+     free (key);
    FREE (b->data);
    b->data = value ? savestring (value) : (char *)0;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 10
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 11
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-012

Bug-Reported-by:	Rui Santos <rsantos@grupopie.com>
Bug-Reference-ID:	<4E04C6D0.2020507@grupopie.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-06/msg00079.html

Bug-Description:

When calling the parser to recursively parse a command substitution within
an arithmetic expansion, the shell overwrote the saved shell input line and
associated state, resulting in a garbled command.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/parse.y	2011-02-26 19:19:05.000000000 -0500
--- parse.y	2011-06-24 20:08:22.000000000 -0400
***************
*** 3843,3846 ****
--- 3849,3853 ----
  {
    sh_parser_state_t ps;
+   sh_input_line_state_t ls;
    int orig_ind, nc, sflags;
    char *ret, *s, *ep, *ostring;
***************
*** 3850,3857 ****
--- 3857,3866 ----
    ostring = string;
  
+ /*itrace("xparse_dolparen: size = %d shell_input_line = `%s'", shell_input_line_size, shell_input_line);*/
    sflags = SEVAL_NONINT|SEVAL_NOHIST|SEVAL_NOFREE;
    if (flags & SX_NOLONGJMP)
      sflags |= SEVAL_NOLONGJMP;
    save_parser_state (&ps);
+   save_input_line_state (&ls);
  
    /*(*/
***************
*** 3862,3865 ****
--- 3871,3876 ----
    restore_parser_state (&ps);
    reset_parser ();
+   /* reset_parser clears shell_input_line and associated variables */
+   restore_input_line_state (&ls);
    if (interactive)
      token_to_read = 0;
***************
*** 5909,5912 ****
--- 5920,5929 ----
    ps->echo_input_at_read = echo_input_at_read;
  
+   ps->token = token;
+   ps->token_buffer_size = token_buffer_size;
+   /* Force reallocation on next call to read_token_word */
+   token = 0;
+   token_buffer_size = 0;
+ 
    return (ps);
  }
***************
*** 5950,5953 ****
--- 5967,6006 ----
    expand_aliases = ps->expand_aliases;
    echo_input_at_read = ps->echo_input_at_read;
+ 
+   FREE (token);
+   token = ps->token;
+   token_buffer_size = ps->token_buffer_size;
+ }
+ 
+ sh_input_line_state_t *
+ save_input_line_state (ls)
+      sh_input_line_state_t *ls;
+ {
+   if (ls == 0)
+     ls = (sh_input_line_state_t *)xmalloc (sizeof (sh_input_line_state_t));
+   if (ls == 0)
+     return ((sh_input_line_state_t *)NULL);
+ 
+   ls->input_line = shell_input_line;
+   ls->input_line_size = shell_input_line_size;
+   ls->input_line_len = shell_input_line_len;
+   ls->input_line_index = shell_input_line_index;
+ 
+   /* force reallocation */
+   shell_input_line = 0;
+   shell_input_line_size = shell_input_line_len = shell_input_line_index = 0;
+ }
+ 
+ void
+ restore_input_line_state (ls)
+      sh_input_line_state_t *ls;
+ {
+   FREE (shell_input_line);
+   shell_input_line = ls->input_line;
+   shell_input_line_size = ls->input_line_size;
+   shell_input_line_len = ls->input_line_len;
+   shell_input_line_index = ls->input_line_index;
+ 
+   set_line_mbstate ();
  }
  
*** ../bash-4.2-patched/shell.h	2011-01-06 22:16:55.000000000 -0500
--- shell.h	2011-06-24 19:12:25.000000000 -0400
***************
*** 137,140 ****
--- 139,145 ----
    int *token_state;
  
+   char *token;
+   int token_buffer_size;
+ 
    /* input line state -- line number saved elsewhere */
    int input_line_terminator;
***************
*** 167,171 ****
--- 172,186 ----
  } sh_parser_state_t;
  
+ typedef struct _sh_input_line_state_t {
+   char *input_line;
+   int input_line_index;
+   int input_line_size;
+   int input_line_len;
+ } sh_input_line_state_t;
+ 
  /* Let's try declaring these here. */
  extern sh_parser_state_t *save_parser_state __P((sh_parser_state_t *));
  extern void restore_parser_state __P((sh_parser_state_t *));
+ 
+ extern sh_input_line_state_t *save_input_line_state __P((sh_input_line_state_t *));
+ extern void restore_input_line_state __P((sh_input_line_state_t *));
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 11
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 12
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-013

Bug-Reported-by:	Marten Wikstrom <marten.wikstrom@keystream.se>
Bug-Reference-ID:	<BANLkTikKECAh94ZEX68iQvxYuPeEM_xoSQ@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-05/msg00049.html

Bug-Description:

An off-by-one error caused the shell to skip over CTLNUL characters,
which are used internally to mark quoted null strings.  The effect
was to have stray 0x7f characters left after expanding words like
""""""""aa.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2011-03-06 14:11:11.000000000 -0500
--- subst.c	2011-05-11 11:23:33.000000000 -0400
***************
*** 3707,3711 ****
  	}
        else if (string[i] == CTLNUL)
! 	i++;
  
        prev_i = i;
--- 3710,3717 ----
  	}
        else if (string[i] == CTLNUL)
! 	{
! 	  i++;
! 	  continue;
! 	}
  
        prev_i = i;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 12
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 13
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-014

Bug-Reported-by:	Shawn Bohrer <sbohrer@rgmadvisors.com>
Bug-Reference-ID:	<20110504152320.6E8F28130527@dev1.rgmadvisors.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-05/msg00018.html

Bug-Description:

The regular expression matching operator did not correctly match
expressions with an embedded ^A.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/pathexp.c	2010-08-13 23:21:57.000000000 -0400
--- pathexp.c	2011-05-05 16:40:58.000000000 -0400
***************
*** 197,201 ****
  	  if ((qflags & QGLOB_FILENAME) && pathname[i+1] == '/')
  	    continue;
! 	  if ((qflags & QGLOB_REGEXP) && ere_char (pathname[i+1]) == 0)
  	    continue;
  	  temp[j++] = '\\';
--- 197,201 ----
  	  if ((qflags & QGLOB_FILENAME) && pathname[i+1] == '/')
  	    continue;
! 	  if (pathname[i+1] != CTLESC && (qflags & QGLOB_REGEXP) && ere_char (pathname[i+1]) == 0)
  	    continue;
  	  temp[j++] = '\\';
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 13
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 14
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-015

Bug-Reported-by:	<dnade.ext@orange-ftgroup.com>
Bug-Reference-ID:	<728_1312188080_4E3666B0_728_118711_1_3B5D3E0F95CC5C478D6500CDCE8B691F7AAAA4AA3D@PUEXCB2B.nanterre.francetelecom.fr>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-08/msg00000.html

Bug-Description:

When in a context where arithmetic evaluation is not taking place, the
evaluator should not check for division by 0.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/expr.c	2010-12-21 11:12:13.000000000 -0500
--- expr.c	2011-08-02 20:58:28.000000000 -0400
***************
*** 477,480 ****
--- 481,492 ----
        if (special)
  	{
+ 	  if ((op == DIV || op == MOD) && value == 0)
+ 	    {
+ 	      if (noeval == 0)
+ 		evalerror (_("division by 0"));
+ 	      else
+ 	        value = 1;
+ 	    }
+ 
  	  switch (op)
  	    {
***************
*** 483,493 ****
  	      break;
  	    case DIV:
- 	      if (value == 0)
- 		evalerror (_("division by 0"));
  	      lvalue /= value;
  	      break;
  	    case MOD:
- 	      if (value == 0)
- 		evalerror (_("division by 0"));
  	      lvalue %= value;
  	      break;
--- 495,501 ----
***************
*** 805,809 ****
  
        if (((op == DIV) || (op == MOD)) && (val2 == 0))
! 	evalerror (_("division by 0"));
  
        if (op == MUL)
--- 813,822 ----
  
        if (((op == DIV) || (op == MOD)) && (val2 == 0))
! 	{
! 	  if (noeval == 0)
! 	    evalerror (_("division by 0"));
! 	  else
! 	    val2 = 1;
! 	}
  
        if (op == MUL)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 14
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 15
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-016

Bug-Reported-by:	Martin von Gagern <Martin.vGagern@gmx.net>
Bug-Reference-ID:	<4E43AD9E.8060501@gmx.net>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-08/msg00141.html

Bug-Description:

Bash should not check for mail while executing the `eval' builtin.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/parse.y	Fri Feb 25 12:07:41 2011
--- parse.y	Thu Aug 11 19:02:26 2011
***************
*** 2500,2504 ****
  	 is the mail alarm reset; nothing takes place in check_mail ()
  	 except the checking of mail.  Please don't change this. */
!       if (prompt_is_ps1 && time_to_check_mail ())
  	{
  	  check_mail ();
--- 2498,2502 ----
  	 is the mail alarm reset; nothing takes place in check_mail ()
  	 except the checking of mail.  Please don't change this. */
!       if (prompt_is_ps1 && parse_and_execute_level == 0 && time_to_check_mail ())
  	{
  	  check_mail ();
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 15
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 16
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-017

Bug-Reported-by:	Curtis Doty <Curtis@GreenKey.net>
Bug-Reference-ID:	<20110621035324.A4F70849F59@mx1.iParadigms.net>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-06/msg00053.html

Bug-Description:

Using `read -a foo' where foo was an already-declared associative array
caused the shell to die with a segmentation fault.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/read.def	2011-01-04 11:43:36.000000000 -0500
--- builtins/read.def	2011-06-21 10:31:02.000000000 -0400
***************
*** 643,646 ****
--- 642,651 ----
  	  return EXECUTION_FAILURE;	/* readonly or noassign */
  	}
+       if (assoc_p (var))
+ 	{
+           builtin_error (_("%s: cannot convert associative to indexed array"), arrayname);
+ 	  xfree (input_string);
+ 	  return EXECUTION_FAILURE;	/* existing associative array */
+ 	}
        array_flush (array_cell (var));
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 16
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 17
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-018

Bug-Reported-by:	Thomas Cort <tcort@minix3.org>
Bug-Reference-ID:	<BANLkTik-ebGGw3k_1YtB=RyfV1bsqdxC_g@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-06/msg00110.html

Bug-Description:

Bash fails to compile unless JOB_CONTROL is defined.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/execute_cmd.c	2011-02-09 17:32:25.000000000 -0500
--- execute_cmd.c	2011-11-06 15:12:48.000000000 -0500
***************
*** 2197,2200 ****
--- 2315,2319 ----
      cmd->flags |= CMD_IGNORE_RETURN;
  
+ #if defined (JOB_CONTROL)
    lastpipe_flag = 0;
    begin_unwind_frame ("lastpipe-exec");
***************
*** 2216,2228 ****
  	  add_unwind_protect (lastpipe_cleanup, lastpipe_jid);
  	}
!       cmd->flags |= CMD_LASTPIPE;
      }	  
    if (prev >= 0)
      add_unwind_protect (close, prev);
  
    exec_result = execute_command_internal (cmd, asynchronous, prev, pipe_out, fds_to_close);
  
    if (lstdin > 0)
      restore_stdin (lstdin);
  
    if (prev >= 0)
--- 2335,2351 ----
  	  add_unwind_protect (lastpipe_cleanup, lastpipe_jid);
  	}
!       if (cmd)
! 	cmd->flags |= CMD_LASTPIPE;
      }	  
    if (prev >= 0)
      add_unwind_protect (close, prev);
+ #endif
  
    exec_result = execute_command_internal (cmd, asynchronous, prev, pipe_out, fds_to_close);
  
+ #if defined (JOB_CONTROL)
    if (lstdin > 0)
      restore_stdin (lstdin);
+ #endif
  
    if (prev >= 0)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 17
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 18
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-019

Bug-Reported-by:	Diego Augusto Molina <diegoaugustomolina@gmail.com>
Bug-Reference-ID:	<CAGOxLdHcSQu3ck9Qy3pRjj_NBU5tAPSAvNm-95-nLQ9Szwb6aA@mail.gmail.com>
Bug-Reference-URL:	lists.gnu.org/archive/html/bug-bash/2011-09/msg00047.html

Bug-Description:

Using `declare' with attributes and an invalid array variable name or
assignment reference resulted in a segmentation fault instead of a
declaration error.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/declare.def	2010-05-30 18:25:21.000000000 -0400
--- builtins/declare.def	2011-09-15 15:20:20.000000000 -0400
***************
*** 514,517 ****
--- 514,522 ----
  	      var = assign_array_element (name, value, 0);	/* XXX - not aflags */
  	      *subscript_start = '\0';
+ 	      if (var == 0)	/* some kind of assignment error */
+ 		{
+ 		  assign_error++;
+ 		  NEXT_VARIABLE ();
+ 		}
  	    }
  	  else if (simple_array_assign)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 18
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 19
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-020

Bug-Reported-by:	Vincent Sheffer <vince.sheffer@apisphere.com>
Bug-Reference-ID:	<F13C1C4F-C44C-4071-BFED-4BB6D13CF92F@apisphere.com>
Bug-Reference-URL:	https://lists.gnu.org/archive/html/bug-readline/2011-08/msg00000.html

Bug-Description:

The shared object helper script needs to be updated for Mac OS X 10.7
(Lion, darwin11).

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/support/shobj-conf	2009-10-28 09:20:21.000000000 -0400
--- support/shobj-conf	2011-08-27 13:25:23.000000000 -0400
***************
*** 158,162 ****
  
  # Darwin/MacOS X
! darwin[89]*|darwin10*)
  	SHOBJ_STATUS=supported
  	SHLIB_STATUS=supported
--- 172,176 ----
  
  # Darwin/MacOS X
! darwin[89]*|darwin1[012]*)
  	SHOBJ_STATUS=supported
  	SHLIB_STATUS=supported
***************
*** 187,191 ****
  
  	case "${host_os}" in
! 	darwin[789]*|darwin10*)	SHOBJ_LDFLAGS=''
  			SHLIB_XLDFLAGS='-dynamiclib -arch_only `/usr/bin/arch` -install_name $(libdir)/$@ -current_version $(SHLIB_MAJOR)$(SHLIB_MINOR) -compatibility_version $(SHLIB_MAJOR) -v'
  			;;
--- 201,205 ----
  
  	case "${host_os}" in
! 	darwin[789]*|darwin1[012]*)	SHOBJ_LDFLAGS=''
  			SHLIB_XLDFLAGS='-dynamiclib -arch_only `/usr/bin/arch` -install_name $(libdir)/$@ -current_version $(SHLIB_MAJOR)$(SHLIB_MINOR) -compatibility_version $(SHLIB_MAJOR) -v'
  			;;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 19
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 20
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-021

Bug-Reported-by:	Dan Douglas <ormaaj@gmail.com>
Bug-Reference-ID:	<4585554.nZWb4q7YoZ@smorgbox>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-12/msg00084.html

Bug-Description:

Using `read -N' to assign values to an array can result in NUL values being
assigned to some array elements.  These values cause seg faults when referenced
later.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/read.def	2011-11-21 18:03:38.000000000 -0500
--- builtins/read.def	2011-12-19 19:52:12.000000000 -0500
***************
*** 738,742 ****
  	    }
  	  else
! 	    var = bind_read_variable (varname, t);
  	}
        else
--- 775,779 ----
  	    }
  	  else
! 	    var = bind_read_variable (varname, t ? t : "");
  	}
        else
***************
*** 799,803 ****
      }
    else
!     var = bind_read_variable (list->word->word, input_string);
  
    if (var)
--- 836,840 ----
      }
    else
!     var = bind_read_variable (list->word->word, input_string ? input_string : "");
  
    if (var)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 20
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 21
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-022

Bug-Reported-by:	Gregory Margo <gmargo@pacbell.net>
Bug-Reference-ID:	<20110727174529.GA3333@pacbell.net>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-07/msg00102.html

Bug-Description:

The return value from lseek is `off_t'.  This can cause corrupted return
values when the file offset is greater than 2**31 - 1.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/sh/zread.c	Mon Mar  2 08:54:45 2009
--- lib/sh/zread.c	Thu Jul 28 18:16:53 2011
***************
*** 161,166 ****
       int fd;
  {
!   off_t off;
!   int r;
  
    off = lused - lind;
--- 161,165 ----
       int fd;
  {
!   off_t off, r;
  
    off = lused - lind;
***************
*** 169,173 ****
      r = lseek (fd, -off, SEEK_CUR);
  
!   if (r >= 0)
      lused = lind = 0;
  }
--- 168,172 ----
      r = lseek (fd, -off, SEEK_CUR);
  
!   if (r != -1)
      lused = lind = 0;
  }
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 21
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 22
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-023

Bug-Reported-by:	Ewan Mellor <Ewan.Mellor@eu.citrix.com>
Bug-Reference-ID:	<6005BE083BF501439A84DC3523BAC82DC4B964FD12@LONPMAILBOX01.citrite.net>
Bug-Reference-URL:	

Bug-Description:

Under some circumstances, an exit trap triggered by a bad substitution
error when errexit is enabled will cause the shell to exit with an
incorrect exit status (0).

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2011-11-21 12:04:38.000000000 -0500
--- subst.c	2012-02-08 13:36:28.000000000 -0500
***************
*** 7275,7278 ****
--- 7281,7285 ----
      case '\0':
      bad_substitution:
+       last_command_exit_value = EXECUTION_FAILURE;
        report_error (_("%s: bad substitution"), string ? string : "??");
        FREE (value);
*** ../bash-4.2-patched/error.c	2009-08-21 22:31:31.000000000 -0400
--- error.c	2012-02-25 15:54:40.000000000 -0500
***************
*** 201,205 ****
    va_end (args);
    if (exit_immediately_on_error)
!     exit_shell (1);
  }
  
--- 201,209 ----
    va_end (args);
    if (exit_immediately_on_error)
!     {
!       if (last_command_exit_value == 0)
! 	last_command_exit_value = 1;
!       exit_shell (last_command_exit_value);
!     }
  }
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 22
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 23
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-024

Bug-Reported-by:	Jim Avera <james_avera@yahoo.com>
Bug-Reference-ID:	<4F29E07A.80405@yahoo.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-02/msg00001.html

Bug-Description:

When `printf -v' is used to set an array element, the format string contains
`%b', and the corresponding argument is the empty string, the buffer used
to store the value to be assigned can be NULL, which results in NUL being
assigned to the array element.  This causes a seg fault when it's used later.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/printf.def	2011-02-25 12:07:41.000000000 -0500
--- builtins/printf.def	2012-02-02 08:37:12.000000000 -0500
***************
*** 256,259 ****
--- 257,262 ----
  	    {
  	      vflag = 1;
+ 	      if (vbsize == 0)
+ 		vbuf = xmalloc (vbsize = 16);
  	      vblen = 0;
  	      if (vbuf)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 23
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 24
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-025

Bug-Reported-by:	Bill Gradwohl <bill@ycc.com>
Bug-Reference-ID:	<CAFyvKis-UfuOWr5THBRKh=vYHDoKEEgdW8hN1RviTuYQ00Lu5A@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/help-bash/2012-03/msg00078.html

Bug-Description:

When used in a shell function, `declare -g -a array=(compound assignment)'
creates a local variable instead of a global one.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/command.h	2010-08-02 19:36:51.000000000 -0400
--- command.h	2012-04-01 12:38:35.000000000 -0400
***************
*** 98,101 ****
--- 98,102 ----
  #define W_ASSIGNASSOC	0x400000	/* word looks like associative array assignment */
  #define W_ARRAYIND	0x800000	/* word is an array index being expanded */
+ #define W_ASSNGLOBAL	0x1000000	/* word is a global assignment to declare (declare/typeset -g) */
  
  /* Possible values for subshell_environment */
*** ../bash-4.2-patched/execute_cmd.c	2011-11-21 18:03:41.000000000 -0500
--- execute_cmd.c	2012-04-01 12:42:03.000000000 -0400
***************
*** 3581,3585 ****
    WORD_LIST *w;
    struct builtin *b;
!   int assoc;
  
    if (words == 0)
--- 3581,3585 ----
    WORD_LIST *w;
    struct builtin *b;
!   int assoc, global;
  
    if (words == 0)
***************
*** 3587,3591 ****
  
    b = 0;
!   assoc = 0;
  
    for (w = words; w; w = w->next)
--- 3587,3591 ----
  
    b = 0;
!   assoc = global = 0;
  
    for (w = words; w; w = w->next)
***************
*** 3604,3607 ****
--- 3604,3609 ----
  	if (assoc)
  	  w->word->flags |= W_ASSIGNASSOC;
+ 	if (global)
+ 	  w->word->flags |= W_ASSNGLOBAL;
  #endif
        }
***************
*** 3609,3613 ****
      /* Note that we saw an associative array option to a builtin that takes
         assignment statements.  This is a bit of a kludge. */
!     else if (w->word->word[0] == '-' && strchr (w->word->word, 'A'))
        {
  	if (b == 0)
--- 3611,3618 ----
      /* Note that we saw an associative array option to a builtin that takes
         assignment statements.  This is a bit of a kludge. */
!     else if (w->word->word[0] == '-' && (strchr (w->word->word+1, 'A') || strchr (w->word->word+1, 'g')))
! #else
!     else if (w->word->word[0] == '-' && strchr (w->word->word+1, 'g'))
! #endif
        {
  	if (b == 0)
***************
*** 3619,3626 ****
  	      words->word->flags |= W_ASSNBLTIN;
  	  }
! 	if (words->word->flags & W_ASSNBLTIN)
  	  assoc = 1;
        }
- #endif
  }
  
--- 3624,3632 ----
  	      words->word->flags |= W_ASSNBLTIN;
  	  }
! 	if ((words->word->flags & W_ASSNBLTIN) && strchr (w->word->word+1, 'A'))
  	  assoc = 1;
+ 	if ((words->word->flags & W_ASSNBLTIN) && strchr (w->word->word+1, 'g'))
+ 	  global = 1;
        }
  }
  
*** ../bash-4.2-patched/subst.c	2012-03-11 17:35:13.000000000 -0400
--- subst.c	2012-04-01 12:38:35.000000000 -0400
***************
*** 367,370 ****
--- 367,375 ----
        fprintf (stderr, "W_ASSNBLTIN%s", f ? "|" : "");
      }
+   if (f & W_ASSNGLOBAL)
+     {
+       f &= ~W_ASSNGLOBAL;
+       fprintf (stderr, "W_ASSNGLOBAL%s", f ? "|" : "");
+     }
    if (f & W_COMPASSIGN)
      {
***************
*** 2804,2808 ****
    else if (assign_list)
      {
!       if (word->flags & W_ASSIGNARG)
  	aflags |= ASS_MKLOCAL;
        if (word->flags & W_ASSIGNASSOC)
--- 2809,2813 ----
    else if (assign_list)
      {
!       if ((word->flags & W_ASSIGNARG) && (word->flags & W_ASSNGLOBAL) == 0)
  	aflags |= ASS_MKLOCAL;
        if (word->flags & W_ASSIGNASSOC)

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 24
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 25
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-026

Bug-Reported-by:	Greg Wooledge <wooledg@eeg.ccf.org>
Bug-Reference-ID:	<20120425180443.GO22241@eeg.ccf.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-04/msg00172.html

Bug-Description:

The `lastpipe' option does not behave correctly on machines where the
open file limit is less than 256.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/execute_cmd.c	2011-11-21 12:04:47.000000000 -0500
--- execute_cmd.c	2012-04-26 11:09:30.000000000 -0400
***************
*** 2206,2210 ****
    if (lastpipe_opt && job_control == 0 && asynchronous == 0 && pipe_out == NO_PIPE && prev > 0)
      {
!       lstdin = move_to_high_fd (0, 0, 255);
        if (lstdin > 0)
  	{
--- 2325,2329 ----
    if (lastpipe_opt && job_control == 0 && asynchronous == 0 && pipe_out == NO_PIPE && prev > 0)
      {
!       lstdin = move_to_high_fd (0, 1, -1);
        if (lstdin > 0)
  	{
***************
*** 2252,2256 ****
--- 2371,2377 ----
      }
  
+ #if defined (JOB_CONTROL)
    discard_unwind_frame ("lastpipe-exec");
+ #endif
  
    return (exec_result);

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 25
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 26
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-027

Bug-Reported-by:	Mike Frysinger <vapier@gentoo.org>
Bug-Reference-ID:	<201204211243.30163.vapier@gentoo.org>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-04/msg00134.html

Bug-Description:

When the `extglob' shell option is enabled, pattern substitution does not
work correctly in the presence of multibyte characters.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2012-03-11 17:52:57.000000000 -0400
--- subst.c	2012-04-22 16:19:10.000000000 -0400
***************
*** 4167,4171 ****
  #if defined (EXTENDED_GLOB)
    if (extended_glob)
!     simple |= (wpat[1] != L'(' || (wpat[0] != L'*' && wpat[0] != L'?' && wpat[0] != L'+' && wpat[0] != L'!' && wpat[0] != L'@')); /*)*/
  #endif
  
--- 4167,4171 ----
  #if defined (EXTENDED_GLOB)
    if (extended_glob)
!     simple &= (wpat[1] != L'(' || (wpat[0] != L'*' && wpat[0] != L'?' && wpat[0] != L'+' && wpat[0] != L'!' && wpat[0] != L'@')); /*)*/
  #endif
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 26
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 27
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-028

Bug-Reported-by:	Mark Edgar <medgar123@gmail.com>
Bug-Reference-ID:	<CABHMh_3d+ZgO_zaEtYXPwK4P7tC0ghZ4g=Ue_TRpsEMf5YDsqw@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-03/msg00109.html

Bug-Description:

When using a word expansion for which the right hand side is evaluated,
certain expansions of quoted null strings include spurious ^? characters.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2012-03-11 17:35:13.000000000 -0400
--- subst.c	2012-03-20 19:30:13.000000000 -0400
***************
*** 5810,5813 ****
--- 5810,5823 ----
        if (qdollaratp && ((hasdol && quoted) || l->next))
  	*qdollaratp = 1;
+       /* If we have a quoted null result (QUOTED_NULL(temp)) and the word is
+ 	 a quoted null (l->next == 0 && QUOTED_NULL(l->word->word)), the
+ 	 flags indicate it (l->word->flags & W_HASQUOTEDNULL), and the
+ 	 expansion is quoted (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES))
+ 	 (which is more paranoia than anything else), we need to return the
+ 	 quoted null string and set the flags to indicate it. */
+       if (l->next == 0 && (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES)) && QUOTED_NULL(temp) && QUOTED_NULL(l->word->word) && (l->word->flags & W_HASQUOTEDNULL))
+ 	{
+ 	  w->flags |= W_HASQUOTEDNULL;
+ 	}
        dispose_words (l);
      }

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 27
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 28
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-029

Bug-Reported-by:	"Michael Kalisz" <michael@kalisz.homelinux.net>
Bug-Reference-ID:	<50241.78.69.11.112.1298585641.squirrel@kalisz.homelinux.net>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-02/msg00274.html

Bug-Description:

Bash-4.2 tries to leave completed directory names as the user typed them,
without expanding them to a full pathname.  One effect of this is that
shell variables used in pathnames being completed (e.g., $HOME) are left
unchanged, but the `$' is quoted by readline because it is a special
character to the shell.

This patch introduces two things:

1.  A new shell option, `direxpand', which, if set, attempts to emulate the
    bash-4.1 behavior of expanding words to full pathnames during
    completion;
2.  A set of heuristics that reduce the number of times special characters
    such as `$' are quoted when the directory name is not expanded.

Patch (apply with `patch -p0'):

diff -NrC 2 ../bash-4.2-patched/bashline.c ./bashline.c
*** ../bash-4.2-patched/bashline.c	2011-01-16 15:32:47.000000000 -0500
--- ./bashline.c	2012-05-07 16:27:18.000000000 -0400
***************
*** 122,125 ****
--- 122,128 ----
  static int bash_push_line __P((void));
  
+ static rl_icppfunc_t *save_directory_hook __P((void));
+ static void reset_directory_hook __P((rl_icppfunc_t *));
+ 
  static void cleanup_expansion_error __P((void));
  static void maybe_make_readline_line __P((char *));
***************
*** 244,251 ****
--- 247,261 ----
  int dircomplete_spelling = 0;
  
+ /* Expand directory names during word/filename completion. */
+ int dircomplete_expand = 0;
+ int dircomplete_expand_relpath = 0;
+ 
  static char *bash_completer_word_break_characters = " \t\n\"'@><=;|&(:";
  static char *bash_nohostname_word_break_characters = " \t\n\"'><=;|&(:";
  /* )) */
  
+ static const char *default_filename_quote_characters = " \t\n\\\"'@<>=;|&()#$`?*[!:{~";	/*}*/
+ static char *custom_filename_quote_characters = 0;
+ 
  static rl_hook_func_t *old_rl_startup_hook = (rl_hook_func_t *)NULL;
  
***************
*** 502,506 ****
    /* Tell the completer that we might want to follow symbolic links or
       do other expansion on directory names. */
!   rl_directory_rewrite_hook = bash_directory_completion_hook;
  
    rl_filename_rewrite_hook = bash_filename_rewrite_hook;
--- 512,516 ----
    /* Tell the completer that we might want to follow symbolic links or
       do other expansion on directory names. */
!   set_directory_hook ();
  
    rl_filename_rewrite_hook = bash_filename_rewrite_hook;
***************
*** 530,534 ****
  
    /* characters that need to be quoted when appearing in filenames. */
!   rl_filename_quote_characters = " \t\n\\\"'@<>=;|&()#$`?*[!:{~";	/*}*/
  
    rl_filename_quoting_function = bash_quote_filename;
--- 540,544 ----
  
    /* characters that need to be quoted when appearing in filenames. */
!   rl_filename_quote_characters = default_filename_quote_characters;
  
    rl_filename_quoting_function = bash_quote_filename;
***************
*** 565,570 ****
    rl_attempted_completion_function = attempt_shell_completion;
    rl_completion_entry_function = NULL;
-   rl_directory_rewrite_hook = bash_directory_completion_hook;
    rl_ignore_some_completions_function = filename_completion_ignore;
  }
  
--- 575,582 ----
    rl_attempted_completion_function = attempt_shell_completion;
    rl_completion_entry_function = NULL;
    rl_ignore_some_completions_function = filename_completion_ignore;
+   rl_filename_quote_characters = default_filename_quote_characters;
+ 
+   set_directory_hook ();
  }
  
***************
*** 1280,1283 ****
--- 1292,1298 ----
    rl_ignore_some_completions_function = filename_completion_ignore;
  
+   rl_filename_quote_characters = default_filename_quote_characters;
+   set_directory_hook ();
+ 
    /* Determine if this could be a command word.  It is if it appears at
       the start of the line (ignoring preceding whitespace), or if it
***************
*** 1592,1595 ****
--- 1607,1616 ----
  	  else
  	    {
+ 	     if (dircomplete_expand && dot_or_dotdot (filename_hint))
+ 		{
+ 		  dircomplete_expand = 0;
+ 		  set_directory_hook ();
+ 		  dircomplete_expand = 1;
+ 		}
  	      mapping_over = 4;
  	      goto inner;
***************
*** 1792,1795 ****
--- 1813,1819 ----
   inner:
    val = rl_filename_completion_function (filename_hint, istate);
+   if (mapping_over == 4 && dircomplete_expand)
+     set_directory_hook ();
+ 
    istate = 1;
  
***************
*** 2694,2697 ****
--- 2718,2767 ----
  }
  
+ /* Functions to save and restore the appropriate directory hook */
+ /* This is not static so the shopt code can call it */
+ void
+ set_directory_hook ()
+ {
+   if (dircomplete_expand)
+     {
+       rl_directory_completion_hook = bash_directory_completion_hook;
+       rl_directory_rewrite_hook = (rl_icppfunc_t *)0;
+     }
+   else
+     {
+       rl_directory_rewrite_hook = bash_directory_completion_hook;
+       rl_directory_completion_hook = (rl_icppfunc_t *)0;
+     }
+ }
+ 
+ static rl_icppfunc_t *
+ save_directory_hook ()
+ {
+   rl_icppfunc_t *ret;
+ 
+   if (dircomplete_expand)
+     {
+       ret = rl_directory_completion_hook;
+       rl_directory_completion_hook = (rl_icppfunc_t *)NULL;
+     }
+   else
+     {
+       ret = rl_directory_rewrite_hook;
+       rl_directory_rewrite_hook = (rl_icppfunc_t *)NULL;
+     }
+ 
+   return ret;
+ }
+ 
+ static void
+ restore_directory_hook (hookf)
+      rl_icppfunc_t *hookf;
+ {
+   if (dircomplete_expand)
+     rl_directory_completion_hook = hookf;
+   else
+     rl_directory_rewrite_hook = hookf;
+ }
+ 
  /* Handle symbolic link references and other directory name
     expansions while hacking completion.  This should return 1 if it modifies
***************
*** 2703,2720 ****
  {
    char *local_dirname, *new_dirname, *t;
!   int return_value, should_expand_dirname;
    WORD_LIST *wl;
    struct stat sb;
  
!   return_value = should_expand_dirname = 0;
    local_dirname = *dirname;
  
!   if (mbschr (local_dirname, '$'))
!     should_expand_dirname = 1;
    else
      {
        t = mbschr (local_dirname, '`');
        if (t && unclosed_pair (local_dirname, strlen (local_dirname), "`") == 0)
! 	should_expand_dirname = 1;
      }
  
--- 2773,2801 ----
  {
    char *local_dirname, *new_dirname, *t;
!   int return_value, should_expand_dirname, nextch, closer;
    WORD_LIST *wl;
    struct stat sb;
  
!   return_value = should_expand_dirname = nextch = closer = 0;
    local_dirname = *dirname;
  
!   if (t = mbschr (local_dirname, '$'))
!     {
!       should_expand_dirname = '$';
!       nextch = t[1];
!       /* Deliberately does not handle the deprecated $[...] arithmetic
! 	 expansion syntax */
!       if (nextch == '(')
! 	closer = ')';
!       else if (nextch == '{')
! 	closer = '}';
!       else
! 	nextch = 0;
!     }
    else
      {
        t = mbschr (local_dirname, '`');
        if (t && unclosed_pair (local_dirname, strlen (local_dirname), "`") == 0)
! 	should_expand_dirname = '`';
      }
  
***************
*** 2740,2743 ****
--- 2821,2841 ----
  	  dispose_words (wl);
  	  local_dirname = *dirname;
+ 	  /* XXX - change rl_filename_quote_characters here based on
+ 	     should_expand_dirname/nextch/closer.  This is the only place
+ 	     custom_filename_quote_characters is modified. */
+ 	  if (rl_filename_quote_characters && *rl_filename_quote_characters)
+ 	    {
+ 	      int i, j, c;
+ 	      i = strlen (default_filename_quote_characters);
+ 	      custom_filename_quote_characters = xrealloc (custom_filename_quote_characters, i+1);
+ 	      for (i = j = 0; c = default_filename_quote_characters[i]; i++)
+ 		{
+ 		  if (c == should_expand_dirname || c == nextch || c == closer)
+ 		    continue;
+ 		  custom_filename_quote_characters[j++] = c;
+ 		}
+ 	      custom_filename_quote_characters[j] = '\0';
+ 	      rl_filename_quote_characters = custom_filename_quote_characters;
+ 	    }
  	}
        else
***************
*** 2759,2762 ****
--- 2857,2871 ----
      }
  
+   /* no_symbolic_links == 0 -> use (default) logical view of the file system.
+      local_dirname[0] == '.' && local_dirname[1] == '/' means files in the
+      current directory (./).
+      local_dirname[0] == '.' && local_dirname[1] == 0 means relative pathnames
+      in the current directory (e.g., lib/sh).
+      XXX - should we do spelling correction on these? */
+ 
+   /* This is test as it was in bash-4.2: skip relative pathnames in current
+      directory.  Change test to
+       (local_dirname[0] != '.' || (local_dirname[1] && local_dirname[1] != '/'))
+      if we want to skip paths beginning with ./ also. */
    if (no_symbolic_links == 0 && (local_dirname[0] != '.' || local_dirname[1]))
      {
***************
*** 2764,2767 ****
--- 2873,2885 ----
        int len1, len2;
  
+       /* If we have a relative path
+       		(local_dirname[0] != '/' && local_dirname[0] != '.')
+ 	 that is canonical after appending it to the current directory, then
+ 	 	temp1 = temp2+'/'
+ 	 That is,
+ 	 	strcmp (temp1, temp2) == 0
+ 	 after adding a slash to temp2 below.  It should be safe to not
+ 	 change those.
+       */
        t = get_working_directory ("symlink-hook");
        temp1 = make_absolute (local_dirname, t);
***************
*** 2798,2802 ****
  	    }
  	}
!       return_value |= STREQ (local_dirname, temp2) == 0;
        free (local_dirname);
        *dirname = temp2;
--- 2916,2928 ----
  	    }
  	}
! 
!       /* dircomplete_expand_relpath == 0 means we want to leave relative
! 	 pathnames that are unchanged by canonicalization alone.
! 	 *local_dirname != '/' && *local_dirname != '.' == relative pathname
! 	 (consistent with general.c:absolute_pathname())
! 	 temp1 == temp2 (after appending a slash to temp2) means the pathname
! 	 is not changed by canonicalization as described above. */
!       if (dircomplete_expand_relpath || ((local_dirname[0] != '/' && local_dirname[0] != '.') && STREQ (temp1, temp2) == 0))
! 	return_value |= STREQ (local_dirname, temp2) == 0;
        free (local_dirname);
        *dirname = temp2;
***************
*** 3003,3012 ****
    orig_func = rl_completion_entry_function;
    orig_attempt_func = rl_attempted_completion_function;
-   orig_dir_func = rl_directory_rewrite_hook;
    orig_ignore_func = rl_ignore_some_completions_function;
    orig_rl_completer_word_break_characters = rl_completer_word_break_characters;
    rl_completion_entry_function = rl_filename_completion_function;
    rl_attempted_completion_function = (rl_completion_func_t *)NULL;
-   rl_directory_rewrite_hook = (rl_icppfunc_t *)NULL;
    rl_ignore_some_completions_function = filename_completion_ignore;
    rl_completer_word_break_characters = " \t\n\"\'";
--- 3129,3139 ----
    orig_func = rl_completion_entry_function;
    orig_attempt_func = rl_attempted_completion_function;
    orig_ignore_func = rl_ignore_some_completions_function;
    orig_rl_completer_word_break_characters = rl_completer_word_break_characters;
+ 
+   orig_dir_func = save_directory_hook ();
+ 
    rl_completion_entry_function = rl_filename_completion_function;
    rl_attempted_completion_function = (rl_completion_func_t *)NULL;
    rl_ignore_some_completions_function = filename_completion_ignore;
    rl_completer_word_break_characters = " \t\n\"\'";
***************
*** 3016,3023 ****
    rl_completion_entry_function = orig_func;
    rl_attempted_completion_function = orig_attempt_func;
-   rl_directory_rewrite_hook = orig_dir_func;
    rl_ignore_some_completions_function = orig_ignore_func;
    rl_completer_word_break_characters = orig_rl_completer_word_break_characters;
  
    return r;
  }
--- 3143,3151 ----
    rl_completion_entry_function = orig_func;
    rl_attempted_completion_function = orig_attempt_func;
    rl_ignore_some_completions_function = orig_ignore_func;
    rl_completer_word_break_characters = orig_rl_completer_word_break_characters;
  
+   restore_directory_hook (orig_dir_func);
+ 
    return r;
  }
diff -NrC 2 ../bash-4.2-patched/bashline.h ./bashline.h
*** ../bash-4.2-patched/bashline.h	2009-01-04 14:32:22.000000000 -0500
--- ./bashline.h	2012-05-07 16:27:18.000000000 -0400
***************
*** 34,41 ****
--- 34,46 ----
  extern int bash_re_edit __P((char *));
  
+ extern void bashline_set_event_hook __P((void));
+ extern void bashline_reset_event_hook __P((void));
+ 
  extern int bind_keyseq_to_unix_command __P((char *));
  
  extern char **bash_default_completion __P((const char *, int, int, int, int));
  
+ void set_directory_hook __P((void));
+ 
  /* Used by programmable completion code. */
  extern char *command_word_completion_function __P((const char *, int));
diff -NrC 2 ../bash-4.2-patched/builtins/shopt.def ./builtins/shopt.def
*** ../bash-4.2-patched/builtins/shopt.def	2010-07-02 22:42:44.000000000 -0400
--- ./builtins/shopt.def	2012-05-07 16:27:18.000000000 -0400
***************
*** 62,65 ****
--- 62,69 ----
  #include "bashgetopt.h"
  
+ #if defined (READLINE)
+ #  include "../bashline.h"
+ #endif
+ 
  #if defined (HISTORY)
  #  include "../bashhist.h"
***************
*** 95,99 ****
  extern int no_empty_command_completion;
  extern int force_fignore;
! extern int dircomplete_spelling;
  
  extern int enable_hostname_completion __P((int));
--- 99,103 ----
  extern int no_empty_command_completion;
  extern int force_fignore;
! extern int dircomplete_spelling, dircomplete_expand;
  
  extern int enable_hostname_completion __P((int));
***************
*** 122,125 ****
--- 126,133 ----
  #endif
  
+ #if defined (READLINE)
+ static int shopt_set_complete_direxpand __P((char *, int));
+ #endif
+ 
  static int shopt_login_shell;
  static int shopt_compat31;
***************
*** 151,154 ****
--- 159,163 ----
    { "compat41", &shopt_compat41, set_compatibility_level },
  #if defined (READLINE)
+   { "direxpand", &dircomplete_expand, shopt_set_complete_direxpand },
    { "dirspell", &dircomplete_spelling, (shopt_set_func_t *)NULL },
  #endif
***************
*** 536,539 ****
--- 545,559 ----
  }
  
+ #if defined (READLINE)
+ static int
+ shopt_set_complete_direxpand (option_name, mode)
+      char *option_name;
+      int mode;
+ {
+   set_directory_hook ();
+   return 0;
+ }
+ #endif
+ 
  #if defined (RESTRICTED_SHELL)
  /* Don't allow the value of restricted_shell to be modified. */
Binary files ../bash-4.2-patched/doc/._bashref.pdf and ./doc/._bashref.pdf differ
diff -NrC 2 ../bash-4.2-patched/doc/bash.1 ./doc/bash.1
*** ../bash-4.2-patched/doc/bash.1	2011-01-16 15:31:39.000000000 -0500
--- ./doc/bash.1	2012-05-07 16:27:18.000000000 -0400
***************
*** 8949,8952 ****
--- 8949,8962 ----
  The default bash behavior remains as in previous versions.
  .TP 8
+ .B direxpand
+ If set,
+ .B bash
+ replaces directory names with the results of word expansion when performing
+ filename completion.  This changes the contents of the readline editing
+ buffer.
+ If not set,
+ .B bash
+ attempts to preserve what the user typed.
+ .TP 8
  .B dirspell
  If set,
diff -NrC 2 ../bash-4.2-patched/doc/bashref.texi ./doc/bashref.texi
*** ../bash-4.2-patched/doc/bashref.texi	2011-01-16 15:31:57.000000000 -0500
--- ./doc/bashref.texi	2012-05-07 16:27:18.000000000 -0400
***************
*** 4536,4539 ****
--- 4536,4546 ----
  The default Bash behavior remains as in previous versions.
  
+ @item direxpand
+ If set, Bash
+ replaces directory names with the results of word expansion when performing
+ filename completion.  This changes the contents of the readline editing
+ buffer.
+ If not set, Bash attempts to preserve what the user typed.
+ 
  @item dirspell
  If set, Bash
diff -NrC 2 ../bash-4.2-patched/tests/shopt.right ./tests/shopt.right
*** ../bash-4.2-patched/tests/shopt.right	2010-07-02 23:36:30.000000000 -0400
--- ./tests/shopt.right	2012-05-07 16:27:18.000000000 -0400
***************
*** 13,16 ****
--- 13,17 ----
  shopt -u compat40
  shopt -u compat41
+ shopt -u direxpand
  shopt -u dirspell
  shopt -u dotglob
***************
*** 69,72 ****
--- 70,74 ----
  shopt -u compat40
  shopt -u compat41
+ shopt -u direxpand
  shopt -u dirspell
  shopt -u dotglob
***************
*** 102,105 ****
--- 104,108 ----
  compat40       	off
  compat41       	off
+ direxpand      	off
  dirspell       	off
  dotglob        	off
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 28
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 29
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-030

Bug-Reported-by:	Roman Rakus <rrakus@redhat.com>
Bug-Reference-ID:	<4D7DD91E.7040808@redhat.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2011-03/msg00126.html

Bug-Description:

When attempting to glob strings in a multibyte locale, and those strings
contain invalid multibyte characters that cause mbsnrtowcs to return 0,
the globbing code loops infinitely.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/glob/xmbsrtowcs.c	2010-05-30 18:36:27.000000000 -0400
--- lib/glob/xmbsrtowcs.c	2011-03-22 16:06:47.000000000 -0400
***************
*** 36,39 ****
--- 36,41 ----
  #if HANDLE_MULTIBYTE
  
+ #define WSBUF_INC 32
+ 
  #ifndef FREE
  #  define FREE(x)	do { if (x) free (x); } while (0)
***************
*** 149,153 ****
    size_t wcnum;		/* Number of wide characters in WSBUF */
    mbstate_t state;	/* Conversion State */
!   size_t wcslength;	/* Number of wide characters produced by the conversion. */
    const char *end_or_backslash;
    size_t nms;	/* Number of multibyte characters to convert at one time. */
--- 151,155 ----
    size_t wcnum;		/* Number of wide characters in WSBUF */
    mbstate_t state;	/* Conversion State */
!   size_t n, wcslength;	/* Number of wide characters produced by the conversion. */
    const char *end_or_backslash;
    size_t nms;	/* Number of multibyte characters to convert at one time. */
***************
*** 172,176 ****
        tmp_p = p;
        tmp_state = state;
!       wcslength = mbsnrtowcs(NULL, &tmp_p, nms, 0, &tmp_state);
  
        /* Conversion failed. */
--- 174,189 ----
        tmp_p = p;
        tmp_state = state;
! 
!       if (nms == 0 && *p == '\\')	/* special initial case */
! 	nms = wcslength = 1;
!       else
! 	wcslength = mbsnrtowcs (NULL, &tmp_p, nms, 0, &tmp_state);
! 
!       if (wcslength == 0)
! 	{
! 	  tmp_p = p;		/* will need below */
! 	  tmp_state = state;
! 	  wcslength = 1;	/* take a single byte */
! 	}
  
        /* Conversion failed. */
***************
*** 187,191 ****
  	  wchar_t *wstmp;
  
! 	  wsbuf_size = wcnum+wcslength+1;	/* 1 for the L'\0' or the potential L'\\' */
  
  	  wstmp = (wchar_t *) realloc (wsbuf, wsbuf_size * sizeof (wchar_t));
--- 200,205 ----
  	  wchar_t *wstmp;
  
! 	  while (wsbuf_size < wcnum+wcslength+1) /* 1 for the L'\0' or the potential L'\\' */
! 	    wsbuf_size += WSBUF_INC;
  
  	  wstmp = (wchar_t *) realloc (wsbuf, wsbuf_size * sizeof (wchar_t));
***************
*** 200,207 ****
  
        /* Perform the conversion. This is assumed to return 'wcslength'.
!        * It may set 'p' to NULL. */
!       mbsnrtowcs(wsbuf+wcnum, &p, nms, wsbuf_size-wcnum, &state);
  
!       wcnum += wcslength;
  
        if (mbsinit (&state) && (p != NULL) && (*p == '\\'))
--- 214,229 ----
  
        /* Perform the conversion. This is assumed to return 'wcslength'.
! 	 It may set 'p' to NULL. */
!       n = mbsnrtowcs(wsbuf+wcnum, &p, nms, wsbuf_size-wcnum, &state);
  
!       /* Compensate for taking single byte on wcs conversion failure above. */
!       if (wcslength == 1 && (n == 0 || n == (size_t)-1))
! 	{
! 	  state = tmp_state;
! 	  p = tmp_p;
! 	  wsbuf[wcnum++] = *p++;
! 	}
!       else
!         wcnum += wcslength;
  
        if (mbsinit (&state) && (p != NULL) && (*p == '\\'))
***************
*** 231,236 ****
     of DESTP and INDICESP are NULL. */
  
- #define WSBUF_INC 32
- 
  size_t
  xdupmbstowcs (destp, indicesp, src)
--- 253,256 ----
*** ../bash-4.2-patched/lib/glob/glob.c	2009-11-14 18:39:30.000000000 -0500
--- lib/glob/glob.c	2012-07-07 12:09:56.000000000 -0400
***************
*** 201,206 ****
    size_t pat_n, dn_n;
  
    pat_n = xdupmbstowcs (&pat_wc, NULL, pat);
!   dn_n = xdupmbstowcs (&dn_wc, NULL, dname);
  
    ret = 0;
--- 201,209 ----
    size_t pat_n, dn_n;
  
+   pat_wc = dn_wc = (wchar_t *)NULL;
+ 
    pat_n = xdupmbstowcs (&pat_wc, NULL, pat);
!   if (pat_n != (size_t)-1)
!     dn_n = xdupmbstowcs (&dn_wc, NULL, dname);
  
    ret = 0;
***************
*** 222,225 ****
--- 225,230 ----
  	ret = 1;
      }
+   else
+     ret = skipname (pat, dname, flags);
  
    FREE (pat_wc);
***************
*** 267,272 ****
    n = xdupmbstowcs (&wpathname, NULL, pathname);
    if (n == (size_t) -1)
!     /* Something wrong. */
!     return;
    orig_wpathname = wpathname;
  
--- 272,280 ----
    n = xdupmbstowcs (&wpathname, NULL, pathname);
    if (n == (size_t) -1)
!     {
!       /* Something wrong.  Fall back to single-byte */
!       udequote_pathname (pathname);
!       return;
!     }
    orig_wpathname = wpathname;
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 29
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 30
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-031

Bug-Reported-by:	Max Horn <max@quendi.de>
Bug-Reference-ID:	<20CC5C60-07C3-4E41-9817-741E48D407C5@quendi.de>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-readline/2012-06/msg00005.html

Bug-Description:

A change between bash-4.1 and bash-4.2 to prevent the readline input hook
from being called too frequently had the side effect of causing delays
when reading pasted input on systems such as Mac OS X.  This patch fixes
those delays while retaining the bash-4.2 behavior.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/readline/input.c	2010-05-30 18:33:01.000000000 -0400
--- lib/readline/input.c	2012-06-25 21:08:42.000000000 -0400
***************
*** 410,414 ****
  rl_read_key ()
  {
!   int c;
  
    rl_key_sequence_length++;
--- 412,416 ----
  rl_read_key ()
  {
!   int c, r;
  
    rl_key_sequence_length++;
***************
*** 430,441 ****
  	  while (rl_event_hook)
  	    {
! 	      if (rl_gather_tyi () < 0)	/* XXX - EIO */
  		{
  		  rl_done = 1;
  		  return ('\n');
  		}
  	      RL_CHECK_SIGNALS ();
- 	      if (rl_get_char (&c) != 0)
- 		break;
  	      if (rl_done)		/* XXX - experimental */
  		return ('\n');
--- 432,447 ----
  	  while (rl_event_hook)
  	    {
! 	      if (rl_get_char (&c) != 0)
! 		break;
! 		
! 	      if ((r = rl_gather_tyi ()) < 0)	/* XXX - EIO */
  		{
  		  rl_done = 1;
  		  return ('\n');
  		}
+ 	      else if (r == 1)			/* read something */
+ 		continue;
+ 
  	      RL_CHECK_SIGNALS ();
  	      if (rl_done)		/* XXX - experimental */
  		return ('\n');
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 30
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 31
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-032

Bug-Reported-by:	Ruediger Kuhlmann <RKuhlmann@orga-systems.com>
Bug-Reference-ID:	<OFDE975207.0C3622E5-ONC12579F3.00361A06-C12579F3.00365E39@orga-systems.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-05/msg00010.html

Bug-Description:

Bash-4.2 has problems with DEL characters in the expanded value of variables
used in the same quoted string as variables that expand to nothing.

Patch (apply with `patch -p0'):

*** ../bash-20120427/subst.c	2012-04-22 16:19:10.000000000 -0400
--- subst.c	2012-05-07 16:06:35.000000000 -0400
***************
*** 8152,8155 ****
--- 8152,8163 ----
  	  dispose_word_desc (tword);
  
+ 	  /* Kill quoted nulls; we will add them back at the end of
+ 	     expand_word_internal if nothing else in the string */
+ 	  if (had_quoted_null && temp && QUOTED_NULL (temp))
+ 	    {
+ 	      FREE (temp);
+ 	      temp = (char *)NULL;
+ 	    }
+ 
  	  goto add_string;
  	  break;
***************
*** 8556,8560 ****
        if (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES))
  	tword->flags |= W_QUOTED;
!       if (had_quoted_null)
  	tword->flags |= W_HASQUOTEDNULL;
        list = make_word_list (tword, (WORD_LIST *)NULL);
--- 8564,8568 ----
        if (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES))
  	tword->flags |= W_QUOTED;
!       if (had_quoted_null && QUOTED_NULL (istring))
  	tword->flags |= W_HASQUOTEDNULL;
        list = make_word_list (tword, (WORD_LIST *)NULL);
***************
*** 8587,8591 ****
  	  if (word->flags & W_NOEXPAND)
  	    tword->flags |= W_NOEXPAND;
! 	  if (had_quoted_null)
  	    tword->flags |= W_HASQUOTEDNULL;	/* XXX */
  	  list = make_word_list (tword, (WORD_LIST *)NULL);
--- 8595,8599 ----
  	  if (word->flags & W_NOEXPAND)
  	    tword->flags |= W_NOEXPAND;
! 	  if (had_quoted_null && QUOTED_NULL (istring))
  	    tword->flags |= W_HASQUOTEDNULL;	/* XXX */
  	  list = make_word_list (tword, (WORD_LIST *)NULL);
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 31
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 32
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-033

Bug-Reported-by:	David Leverton <levertond@googlemail.com>
Bug-Reference-ID:	<4FCCE737.1060603@googlemail.com>
Bug-Reference-URL:

Bug-Description:

Bash uses a static buffer when expanding the /dev/fd prefix for the test
and conditional commands, among other uses, when it should use a dynamic
buffer to avoid buffer overflow.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/sh/eaccess.c	2011-01-08 20:50:10.000000000 -0500
--- lib/sh/eaccess.c	2012-06-04 21:06:43.000000000 -0400
***************
*** 83,86 ****
--- 83,88 ----
       struct stat *finfo;
  {
+   static char *pbuf = 0;
+ 
    if (*path == '\0')
      {
***************
*** 107,111 ****
       On most systems, with the notable exception of linux, this is
       effectively a no-op. */
!       char pbuf[32];
        strcpy (pbuf, DEV_FD_PREFIX);
        strcat (pbuf, path + 8);
--- 109,113 ----
       On most systems, with the notable exception of linux, this is
       effectively a no-op. */
!       pbuf = xrealloc (pbuf, sizeof (DEV_FD_PREFIX) + strlen (path + 8));
        strcpy (pbuf, DEV_FD_PREFIX);
        strcat (pbuf, path + 8);
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 32
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 33
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-034

Bug-Reported-by:	"Davide Brini" <dave_br@gmx.com>
Bug-Reference-ID:	<20120604164154.69781EC04B@imaps.oficinas.atrapalo.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-06/msg00030.html

Bug-Description:

In bash-4.2, the history code would inappropriately add a semicolon to
multi-line compound array assignments when adding them to the history.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/parse.y	2011-11-21 18:03:36.000000000 -0500
--- parse.y	2012-06-07 12:48:47.000000000 -0400
***************
*** 4900,4905 ****
--- 4916,4924 ----
        return (current_command_line_count == 2 ? "\n" : "");
      }
  
+   if (parser_state & PST_COMPASSIGN)
+     return (" ");
+ 
    /* First, handle some special cases. */
    /*(*/
    /* If we just read `()', assume it's a function definition, and don't
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 33
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 34
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-035

Bug-Reported-by:	Dan Douglas <ormaaj@gmail.com>
Bug-Reference-ID:	<2766482.Ksm3GrSoYi@smorgbox>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-06/msg00071.html

Bug-Description:

When given a number of lines to read, `mapfile -n lines' reads one too many.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/mapfile.def	2010-05-29 22:09:47.000000000 -0400
--- builtins/mapfile.def	2012-06-20 09:48:33.000000000 -0400
***************
*** 196,206 ****
    interrupt_immediately++;
    for (array_index = origin, line_count = 1; 
!        zgetline (fd, &line, &line_length, unbuffered_read) != -1;
!        array_index++, line_count++) 
      {
-       /* Have we exceeded # of lines to store? */
-       if (line_count_goal != 0 && line_count > line_count_goal) 
- 	break;
- 
        /* Remove trailing newlines? */
        if (flags & MAPF_CHOP)
--- 196,202 ----
    interrupt_immediately++;
    for (array_index = origin, line_count = 1; 
!  	zgetline (fd, &line, &line_length, unbuffered_read) != -1;
! 	array_index++) 
      {
        /* Remove trailing newlines? */
        if (flags & MAPF_CHOP)
***************
*** 218,221 ****
--- 214,222 ----
  
        bind_array_element (entry, array_index, line, 0);
+ 
+       /* Have we exceeded # of lines to store? */
+       line_count++;
+       if (line_count_goal != 0 && line_count > line_count_goal) 
+ 	break;
      }
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 34
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 35
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-036

Bug-Reported-by:	gregrwm <backuppc-users@whitleymott.net>
Bug-Reference-ID:	<CAD+dB9B4JG+qUwZBQUwiQmVt0j6NDn=DDTxr9R+nkA8DL4KLJA@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-05/msg00108.html

Bug-Description:

Bash-4.2 produces incorrect word splitting results when expanding
double-quoted $@ in the same string as and adjacent to other variable
expansions.  The $@ should be split, the other expansions should not.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2012-05-02 12:02:33.000000000 -0400
--- subst.c	2012-07-08 21:19:32.000000000 -0400
***************
*** 7923,7927 ****
    /* State flags */
    int had_quoted_null;
!   int has_dollar_at;
    int tflag;
    int pflags;			/* flags passed to param_expand */
--- 7923,7927 ----
    /* State flags */
    int had_quoted_null;
!   int has_dollar_at, temp_has_dollar_at;
    int tflag;
    int pflags;			/* flags passed to param_expand */
***************
*** 8128,8138 ****
  	    *expanded_something = 1;
  
! 	  has_dollar_at = 0;
  	  pflags = (word->flags & W_NOCOMSUB) ? PF_NOCOMSUB : 0;
  	  if (word->flags & W_NOSPLIT2)
  	    pflags |= PF_NOSPLIT2;
  	  tword = param_expand (string, &sindex, quoted, expanded_something,
! 			       &has_dollar_at, &quoted_dollar_at,
  			       &had_quoted_null, pflags);
  
  	  if (tword == &expand_wdesc_error || tword == &expand_wdesc_fatal)
--- 8128,8139 ----
  	    *expanded_something = 1;
  
! 	  temp_has_dollar_at = 0;
  	  pflags = (word->flags & W_NOCOMSUB) ? PF_NOCOMSUB : 0;
  	  if (word->flags & W_NOSPLIT2)
  	    pflags |= PF_NOSPLIT2;
  	  tword = param_expand (string, &sindex, quoted, expanded_something,
! 			       &temp_has_dollar_at, &quoted_dollar_at,
  			       &had_quoted_null, pflags);
+ 	  has_dollar_at += temp_has_dollar_at;
  
  	  if (tword == &expand_wdesc_error || tword == &expand_wdesc_fatal)
***************
*** 8275,8281 ****
  	      temp = (char *)NULL;
  
! 	      has_dollar_at = 0;
  	      /* Need to get W_HASQUOTEDNULL flag through this function. */
! 	      list = expand_word_internal (tword, Q_DOUBLE_QUOTES, 0, &has_dollar_at, (int *)NULL);
  
  	      if (list == &expand_word_error || list == &expand_word_fatal)
--- 8276,8283 ----
  	      temp = (char *)NULL;
  
! 	      temp_has_dollar_at = 0;	/* XXX */
  	      /* Need to get W_HASQUOTEDNULL flag through this function. */
! 	      list = expand_word_internal (tword, Q_DOUBLE_QUOTES, 0, &temp_has_dollar_at, (int *)NULL);
! 	      has_dollar_at += temp_has_dollar_at;
  
  	      if (list == &expand_word_error || list == &expand_word_fatal)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 35
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 36
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-037

Bug-Reported-by:	Jakub Filak
Bug-Reference-ID:
Bug-Reference-URL:	https://bugzilla.redhat.com/show_bug.cgi?id=813289

Bug-Description:

Attempting to redo (using `.') the vi editing mode `cc', `dd', or `yy'
commands leads to an infinite loop.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/readline/vi_mode.c	2011-02-25 11:17:02.000000000 -0500
--- lib/readline/vi_mode.c	2012-06-02 12:24:47.000000000 -0400
***************
*** 1235,1243 ****
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
!   else if (vi_redoing)
      {
        _rl_vimvcxt->motion = _rl_vi_last_motion;
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
  #if defined (READLINE_CALLBACKS)
    else if (RL_ISSTATE (RL_STATE_CALLBACK))
--- 1297,1313 ----
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
!   else if (vi_redoing && _rl_vi_last_motion != 'd')	/* `dd' is special */
      {
        _rl_vimvcxt->motion = _rl_vi_last_motion;
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
+   else if (vi_redoing)		/* handle redoing `dd' here */
+     {
+       _rl_vimvcxt->motion = _rl_vi_last_motion;
+       rl_mark = rl_end;
+       rl_beg_of_line (1, key);
+       RL_UNSETSTATE (RL_STATE_VIMOTION);
+       r = vidomove_dispatch (_rl_vimvcxt);
+     }
  #if defined (READLINE_CALLBACKS)
    else if (RL_ISSTATE (RL_STATE_CALLBACK))
***************
*** 1317,1325 ****
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
!   else if (vi_redoing)
      {
        _rl_vimvcxt->motion = _rl_vi_last_motion;
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
  #if defined (READLINE_CALLBACKS)
    else if (RL_ISSTATE (RL_STATE_CALLBACK))
--- 1387,1403 ----
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
!   else if (vi_redoing && _rl_vi_last_motion != 'c')	/* `cc' is special */
      {
        _rl_vimvcxt->motion = _rl_vi_last_motion;
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
+   else if (vi_redoing)		/* handle redoing `cc' here */
+     {
+       _rl_vimvcxt->motion = _rl_vi_last_motion;
+       rl_mark = rl_end;
+       rl_beg_of_line (1, key);
+       RL_UNSETSTATE (RL_STATE_VIMOTION);
+       r = vidomove_dispatch (_rl_vimvcxt);
+     }
  #if defined (READLINE_CALLBACKS)
    else if (RL_ISSTATE (RL_STATE_CALLBACK))
***************
*** 1378,1381 ****
--- 1456,1472 ----
        r = rl_domove_motion_callback (_rl_vimvcxt);
      }
+   else if (vi_redoing && _rl_vi_last_motion != 'y')	/* `yy' is special */
+     {
+       _rl_vimvcxt->motion = _rl_vi_last_motion;
+       r = rl_domove_motion_callback (_rl_vimvcxt);
+     }
+   else if (vi_redoing)			/* handle redoing `yy' here */
+     {
+       _rl_vimvcxt->motion = _rl_vi_last_motion;
+       rl_mark = rl_end;
+       rl_beg_of_line (1, key);
+       RL_UNSETSTATE (RL_STATE_VIMOTION);
+       r = vidomove_dispatch (_rl_vimvcxt);
+     }
  #if defined (READLINE_CALLBACKS)
    else if (RL_ISSTATE (RL_STATE_CALLBACK))
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 36
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 37
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-038

Bug-Reported-by:	armandsl@gmail.com
Bug-Reference-ID:	<20120822112810.8D14920040@windmill.latviatours.lv>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-08/msg00049.html

Bug-Description:

If a backslash-newline (which is removed) with no other input is given as
input to `read', the shell tries to dereference a null pointer and seg faults.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/read.def	2012-03-11 17:52:44.000000000 -0400
--- builtins/read.def	2012-08-22 11:53:09.000000000 -0400
***************
*** 792,796 ****
  #endif
  
!   if (saw_escape)
      {
        t = dequote_string (input_string);
--- 847,851 ----
  #endif
  
!   if (saw_escape && input_string && *input_string)
      {
        t = dequote_string (input_string);
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 37
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 38
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-039

Bug-Reported-by:	Dan Douglas <ormaaj@gmail.com>
Bug-Reference-ID:	<1498458.MpVlmOXDB7@smorgbox>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-09/msg00008.html

Bug-Description:

Under certain circumstances, bash attempts to expand variables in arithmetic
expressions even when evaluation is being suppressed.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/expr.c	2011-11-21 18:03:35.000000000 -0500
--- expr.c	2012-09-09 16:31:18.000000000 -0400
***************
*** 1010,1013 ****
--- 1073,1082 ----
  #endif
  
+ /*itrace("expr_streval: %s: noeval = %d", tok, noeval);*/
+   /* If we are suppressing evaluation, just short-circuit here instead of
+      going through the rest of the evaluator. */
+   if (noeval)
+     return (0);
+ 
    /* [[[[[ */
  #if defined (ARRAY_VARS)
***************
*** 1183,1186 ****
--- 1256,1263 ----
  
        *cp = '\0';
+       /* XXX - watch out for pointer aliasing issues here */
+       if (curlval.tokstr && curlval.tokstr == tokstr)
+ 	init_lvalue (&curlval);
+ 
        FREE (tokstr);
        tokstr = savestring (tp);
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 38
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 39
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-040

Bug-Reported-by:	Andrey Zaitsev <jstcdr@gmail.com>
Bug-Reference-ID:	<CAEZVQT5PJ1Mb_Zh8LT5qz8sv+-9Q6hGfQ5DU9ZxdJ+gV7xBUaQ@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-04/msg00144.html

Bug-Description:

Output redirection applied to builtin commands missed I/O errors if
they happened when the file descriptor was closed, rather than on write
(e.g., like with an out-of-space error on a remote NFS file system).

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/redir.c	2011-01-02 16:00:31.000000000 -0500
--- redir.c	2012-04-24 20:42:12.000000000 -0400
***************
*** 1092,1099 ****
  #if defined (BUFFERED_INPUT)
  	  check_bash_input (redirector);
! 	  close_buffered_fd (redirector);
  #else /* !BUFFERED_INPUT */
! 	  close (redirector);
  #endif /* !BUFFERED_INPUT */
  	}
        break;
--- 1092,1101 ----
  #if defined (BUFFERED_INPUT)
  	  check_bash_input (redirector);
! 	  r = close_buffered_fd (redirector);
  #else /* !BUFFERED_INPUT */
! 	  r = close (redirector);
  #endif /* !BUFFERED_INPUT */
+ 	  if (r < 0 && (flags & RX_INTERNAL) && (errno == EIO || errno == ENOSPC))
+ 	    REDIRECTION_ERROR (r, errno, -1);
  	}
        break;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 39
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 40
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-041

Bug-Reported-by:	Andrey Borzenkov <arvidjaar@gmail.com>
Bug-Reference-ID:	<20121202205200.2134478e@opensuse.site>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-12/msg00008.html

Bug-Description:

Process substitution incorrectly inherited a flag that inhibited using the
(local) temporary environment for variable lookups if it was providing
the filename to a redirection.  The intent the flag is to enforce the
Posix command expansion ordering rules.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2012-07-14 15:53:20.000000000 -0400
--- subst.c	2012-12-02 22:26:54.000000000 -0500
***************
*** 5125,5128 ****
--- 5129,5136 ----
  #endif /* HAVE_DEV_FD */
  
+   /* subshells shouldn't have this flag, which controls using the temporary
+      environment for variable lookups. */
+   expanding_redir = 0;
+ 
    result = parse_and_execute (string, "process substitution", (SEVAL_NONINT|SEVAL_NOHIST));
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 40
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 41
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-042

Bug-Reported-by:	Adam Pippin <adam@gp-inc.ca>
Bug-Reference-ID:	<CAPYbNHr6ucZFOoWsRdUJj6KP3Ju0j1bkESa_cmb7iU+kZwdVpg@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2012-11/msg00087.html

Bug-Description:

Compilation failed after specifying the  `--enable-minimal-config' option to
configure (more specifically, specifying `--disable-alias').

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/parse.y	2012-07-08 21:53:33.000000000 -0400
--- parse.y	2012-10-14 20:20:34.000000000 -0400
***************
*** 2394,2397 ****
--- 2392,2396 ----
  	   to consume the quoted newline and move to the next character in
  	   the expansion. */
+ #if defined (ALIAS)
  	if (expanding_alias () && shell_input_line[shell_input_line_index+1] == '\0')
  	  {
***************
*** 2404,2408 ****
  	    goto next_alias_char;	/* and get next character */
  	  }
! 	else	    
  	  goto restart_read;
      }
--- 2403,2408 ----
  	    goto next_alias_char;	/* and get next character */
  	  }
! 	else
! #endif 
  	  goto restart_read;
      }

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 41
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 42
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-043

Bug-Reported-by:	konsolebox <konsolebox@gmail.com>
Bug-Reference-ID:	<CAJnmqwZuGKLgMsMwxRK4LL+2NN+HgvmKzrnode99QBGrcgX1Lw@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2013-01/msg00138.html

Bug-Description:

When SIGCHLD is trapped, and a SIGCHLD trap handler runs when a pending
`read -t' invocation times out and generates SIGALRM, bash can crash with
a segmentation fault.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/builtins/read.def	2012-10-31 21:22:51.000517000 -0400
--- builtins/read.def	2013-01-25 10:28:16.000038000 -0500
***************
*** 386,393 ****
  	  /* Tricky.  The top of the unwind-protect stack is the free of
  	     input_string.  We want to run all the rest and use input_string,
! 	     so we have to remove it from the stack. */
! 	  remove_unwind_protect ();
! 	  run_unwind_frame ("read_builtin");
  	  input_string[i] = '\0';	/* make sure it's terminated */
  	  retval = 128+SIGALRM;
  	  goto assign_vars;
--- 386,403 ----
  	  /* Tricky.  The top of the unwind-protect stack is the free of
  	     input_string.  We want to run all the rest and use input_string,
! 	     so we have to save input_string temporarily, run the unwind-
! 	     protects, then restore input_string so we can use it later. */
! 
  	  input_string[i] = '\0';	/* make sure it's terminated */
+ 	  if (i == 0)
+ 	    {
+ 	      t = (char *)xmalloc (1);
+ 	      t[0] = 0;
+ 	    }
+ 	  else
+ 	    t = savestring (input_string);
+ 
+ 	  run_unwind_frame ("read_builtin");
+ 	  input_string = t;
  	  retval = 128+SIGALRM;
  	  goto assign_vars;

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 42
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 43
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-044

Bug-Reported-by:	"Dashing" <dashing@hushmail.com>
Bug-Reference-ID:	<20130211175049.D90786F446@smtp.hushmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2013-02/msg00030.html

Bug-Description:

When converting a multibyte string to a wide character string as part of
pattern matching, bash does not handle the end of the string correctly,
causing the search for the NUL to go beyond the end of the string and
reference random memory.  Depending on the contents of that memory, bash
can produce errors or crash. 

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/lib/glob/xmbsrtowcs.c	2012-07-08 21:53:19.000000000 -0400
--- lib/glob/xmbsrtowcs.c	2013-02-12 12:00:39.000000000 -0500
***************
*** 217,220 ****
--- 217,226 ----
        n = mbsnrtowcs(wsbuf+wcnum, &p, nms, wsbuf_size-wcnum, &state);
  
+       if (n == 0 && p == 0)
+ 	{
+ 	  wsbuf[wcnum] = L'\0';
+ 	  break;
+ 	}
+ 
        /* Compensate for taking single byte on wcs conversion failure above. */
        if (wcslength == 1 && (n == 0 || n == (size_t)-1))
***************
*** 222,226 ****
  	  state = tmp_state;
  	  p = tmp_p;
! 	  wsbuf[wcnum++] = *p++;
  	}
        else
--- 228,238 ----
  	  state = tmp_state;
  	  p = tmp_p;
! 	  wsbuf[wcnum] = *p;
! 	  if (*p == 0)
! 	    break;
! 	  else
! 	    {
! 	      wcnum++; p++;
! 	    }
  	}
        else

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 43
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 44
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-045

Bug-Reported-by:	Stephane Chazelas <stephane.chazelas@gmail.com>
Bug-Reference-ID:	<20130218195539.GA9620@chaz.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2013-02/msg00080.html

Bug-Description:

The <&n- and >&n- redirections, which move one file descriptor to another,
leave the file descriptor closed when applied to builtins or compound
commands.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/redir.c	2013-01-30 11:56:09.000000000 -0500
--- redir.c	2013-02-19 09:38:36.000000000 -0500
***************
*** 1008,1011 ****
--- 1008,1021 ----
  	      REDIRECTION_ERROR (r, errno, -1);
  	    }
+ 	  if ((flags & RX_UNDOABLE) && (ri == r_move_input || ri == r_move_output))
+ 	    {
+ 	      /* r_move_input and r_move_output add an additional close()
+ 		 that needs to be undone */
+ 	      if (fcntl (redirector, F_GETFD, 0) != -1)
+ 		{
+ 		  r = add_undo_redirect (redir_fd, r_close_this, -1);
+ 		  REDIRECTION_ERROR (r, errno, -1);
+ 		}
+ 	    }
  #if defined (BUFFERED_INPUT)
  	  check_bash_input (redirector);

*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 44
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 45
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-046

Bug-Reported-by:	"Theodoros V. Kalamatianos" <thkala@gmail.com>
Bug-Reference-ID:	<20140112011131.GE17667@infinity.metashade.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2014-01/msg00044.html

Bug-Description:

Bash-4.2 patch 32 introduced a problem with "$@" and arrays expanding empty
positional parameters or array elements when using substring expansion,
pattern substitution, or case modfication.  The empty parameters or array
elements are removed instead of expanding to empty strings ("").

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/subst.c	2012-12-31 11:52:56.000000000 -0500
--- subst.c	2014-03-31 14:19:56.000000000 -0400
***************
*** 7243,7247 ****
        ret = alloc_word_desc ();
        ret->word = temp1;
!       if (temp1 && QUOTED_NULL (temp1) && (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES)))
  	ret->flags |= W_QUOTED|W_HASQUOTEDNULL;
        return ret;
--- 7243,7253 ----
        ret = alloc_word_desc ();
        ret->word = temp1;
!       /* We test quoted_dollar_atp because we want variants with double-quoted
! 	 "$@" to take a different code path. In fact, we make sure at the end
! 	 of expand_word_internal that we're only looking at these flags if
! 	 quoted_dollar_at == 0. */
!       if (temp1 && 
!           (quoted_dollar_atp == 0 || *quoted_dollar_atp == 0) &&
! 	  QUOTED_NULL (temp1) && (quoted & (Q_HERE_DOCUMENT|Q_DOUBLE_QUOTES)))
  	ret->flags |= W_QUOTED|W_HASQUOTEDNULL;
        return ret;
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 45
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 46
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-047

Bug-Reported-by:	Matthew Riley <mattdr@google.com>
Bug-Reference-ID:	<CA+NEdkwP3gw+gbcF5+xnR1pvcuzb1mDVzvmuJOpHRGHA9T7VFg@mail.gmail.com>
Bug-Reference-URL:	http://lists.gnu.org/archive/html/bug-bash/2013-03/msg00047.html

Bug-Description:

The function that shortens pathnames for $PS1 according to the value of
$PROMPT_DIRTRIM uses memcpy on potentially-overlapping regions of memory,
when it should use memmove.  The result is garbled pathnames in prompt
strings.

Patch (apply with `patch -p0'):

*** ../bash-4.2-patched/general.c	2010-12-12 15:06:27.000000000 -0500
--- general.c	2014-01-30 16:46:15.000000000 -0500
***************
*** 767,771 ****
  
    nlen = nend - ntail;
!   memcpy (nbeg, ntail, nlen);
    nbeg[nlen] = '\0';
  
--- 767,771 ----
  
    nlen = nend - ntail;
!   memmove (nbeg, ntail, nlen);
    nbeg[nlen] = '\0';
  
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 46
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 47
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-048

Bug-Reported-by:	Stephane Chazelas <stephane.chazelas@gmail.com>
Bug-Reference-ID:
Bug-Reference-URL:

Bug-Description:

Under certain circumstances, bash will execute user code while processing the
environment for exported function definitions.

Patch (apply with `patch -p0'):

*** ../bash-4.2.47/builtins/common.h	2010-05-30 18:31:51.000000000 -0400
--- builtins/common.h	2014-09-16 19:35:45.000000000 -0400
***************
*** 36,39 ****
--- 36,41 ----
  
  /* Flags for describe_command, shared between type.def and command.def */
+ #define SEVAL_FUNCDEF	0x080		/* only allow function definitions */
+ #define SEVAL_ONECMD	0x100		/* only allow a single command */
  #define CDESC_ALL		0x001	/* type -a */
  #define CDESC_SHORTDESC		0x002	/* command -V */
*** ../bash-4.2.47/builtins/evalstring.c	2010-11-23 08:22:15.000000000 -0500
--- builtins/evalstring.c	2014-09-16 19:35:45.000000000 -0400
***************
*** 262,265 ****
--- 262,273 ----
  	      struct fd_bitmap *bitmap;
  
+ 	      if ((flags & SEVAL_FUNCDEF) && command->type != cm_function_def)
+ 		{
+ 		  internal_warning ("%s: ignoring function definition attempt", from_file);
+ 		  should_jump_to_top_level = 0;
+ 		  last_result = last_command_exit_value = EX_BADUSAGE;
+ 		  break;
+ 		}
+ 
  	      bitmap = new_fd_bitmap (FD_BITMAP_SIZE);
  	      begin_unwind_frame ("pe_dispose");
***************
*** 322,325 ****
--- 330,336 ----
  	      dispose_fd_bitmap (bitmap);
  	      discard_unwind_frame ("pe_dispose");
+ 
+ 	      if (flags & SEVAL_ONECMD)
+ 		break;
  	    }
  	}
*** ../bash-4.2.47/variables.c	2011-03-01 16:15:20.000000000 -0500
--- variables.c	2014-09-16 19:35:45.000000000 -0400
***************
*** 348,357 ****
  	  strcpy (temp_string + char_index + 1, string);
  
! 	  parse_and_execute (temp_string, name, SEVAL_NONINT|SEVAL_NOHIST);
! 
! 	  /* Ancient backwards compatibility.  Old versions of bash exported
! 	     functions like name()=() {...} */
! 	  if (name[char_index - 1] == ')' && name[char_index - 2] == '(')
! 	    name[char_index - 2] = '\0';
  
  	  if (temp_var = find_function (name))
--- 348,355 ----
  	  strcpy (temp_string + char_index + 1, string);
  
! 	  /* Don't import function names that are invalid identifiers from the
! 	     environment. */
! 	  if (legal_identifier (name))
! 	    parse_and_execute (temp_string, name, SEVAL_NONINT|SEVAL_NOHIST|SEVAL_FUNCDEF|SEVAL_ONECMD);
  
  	  if (temp_var = find_function (name))
***************
*** 362,369 ****
  	  else
  	    report_error (_("error importing function definition for `%s'"), name);
- 
- 	  /* ( */
- 	  if (name[char_index - 1] == ')' && name[char_index - 2] == '\0')
- 	    name[char_index - 2] = '(';		/* ) */
  	}
  #if defined (ARRAY_VARS)
--- 360,363 ----
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 47
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 48
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-049

Bug-Reported-by:	Tavis Ormandy <taviso@cmpxchg8b.com>
Bug-Reference-ID:
Bug-Reference-URL:	http://twitter.com/taviso/statuses/514887394294652929

Bug-Description:

Under certain circumstances, bash can incorrectly save a lookahead character and
return it on a subsequent call, even when reading a new line.

Patch (apply with `patch -p0'):

*** ../bash-4.2.48/parse.y	2012-12-31 11:52:57.000000000 -0500
--- parse.y	2014-09-25 16:12:19.000000000 -0400
***************
*** 2851,2854 ****
--- 2851,2856 ----
    word_desc_to_read = (WORD_DESC *)NULL;
  
+   eol_ungetc_lookahead = 0;
+ 
    current_token = '\n';		/* XXX */
    last_read_token = '\n';
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 48
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 49
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-050

Bug-Reported-by:	Florian Weimer <fweimer@redhat.com>
Bug-Reference-ID:
Bug-Reference-URL:

Bug-Description:

This patch changes the encoding bash uses for exported functions to avoid
clashes with shell variables and to avoid depending only on an environment
variable's contents to determine whether or not to interpret it as a shell
function.

Patch (apply with `patch -p0'):

*** ../bash-4.2.49/variables.c	2014-09-16 19:35:45.000000000 -0400
--- variables.c	2014-09-27 20:54:00.000000000 -0400
***************
*** 80,83 ****
--- 80,88 ----
  #define ifsname(s)	((s)[0] == 'I' && (s)[1] == 'F' && (s)[2] == 'S' && (s)[3] == '\0')
  
+ #define BASHFUNC_PREFIX		"BASH_FUNC_"
+ #define BASHFUNC_PREFLEN	10	/* == strlen(BASHFUNC_PREFIX */
+ #define BASHFUNC_SUFFIX		"%%"
+ #define BASHFUNC_SUFFLEN	2	/* == strlen(BASHFUNC_SUFFIX) */
+ 
  extern char **environ;
  
***************
*** 269,273 ****
  static void dispose_temporary_env __P((sh_free_func_t *));     
  
! static inline char *mk_env_string __P((const char *, const char *));
  static char **make_env_array_from_var_list __P((SHELL_VAR **));
  static char **make_var_export_array __P((VAR_CONTEXT *));
--- 274,278 ----
  static void dispose_temporary_env __P((sh_free_func_t *));     
  
! static inline char *mk_env_string __P((const char *, const char *, int));
  static char **make_env_array_from_var_list __P((SHELL_VAR **));
  static char **make_var_export_array __P((VAR_CONTEXT *));
***************
*** 339,357 ****
        /* If exported function, define it now.  Don't import functions from
  	 the environment in privileged mode. */
!       if (privmode == 0 && read_but_dont_execute == 0 && STREQN ("() {", string, 4))
  	{
  	  string_length = strlen (string);
! 	  temp_string = (char *)xmalloc (3 + string_length + char_index);
  
! 	  strcpy (temp_string, name);
! 	  temp_string[char_index] = ' ';
! 	  strcpy (temp_string + char_index + 1, string);
  
  	  /* Don't import function names that are invalid identifiers from the
  	     environment. */
! 	  if (legal_identifier (name))
! 	    parse_and_execute (temp_string, name, SEVAL_NONINT|SEVAL_NOHIST|SEVAL_FUNCDEF|SEVAL_ONECMD);
  
! 	  if (temp_var = find_function (name))
  	    {
  	      VSETATTR (temp_var, (att_exported|att_imported));
--- 344,373 ----
        /* If exported function, define it now.  Don't import functions from
  	 the environment in privileged mode. */
!       if (privmode == 0 && read_but_dont_execute == 0 &&
! 	  STREQN (BASHFUNC_PREFIX, name, BASHFUNC_PREFLEN) &&
! 	  STREQ (BASHFUNC_SUFFIX, name + char_index - BASHFUNC_SUFFLEN) &&
! 	  STREQN ("() {", string, 4))
  	{
+ 	  size_t namelen;
+ 	  char *tname;		/* desired imported function name */
+ 
+ 	  namelen = char_index - BASHFUNC_PREFLEN - BASHFUNC_SUFFLEN;
+ 
+ 	  tname = name + BASHFUNC_PREFLEN;	/* start of func name */
+ 	  tname[namelen] = '\0';		/* now tname == func name */
+ 
  	  string_length = strlen (string);
! 	  temp_string = (char *)xmalloc (namelen + string_length + 2);
  
! 	  memcpy (temp_string, tname, namelen);
! 	  temp_string[namelen] = ' ';
! 	  memcpy (temp_string + namelen + 1, string, string_length + 1);
  
  	  /* Don't import function names that are invalid identifiers from the
  	     environment. */
! 	  if (absolute_program (tname) == 0 && (posixly_correct == 0 || legal_identifier (tname)))
! 	    parse_and_execute (temp_string, tname, SEVAL_NONINT|SEVAL_NOHIST|SEVAL_FUNCDEF|SEVAL_ONECMD);
  
! 	  if (temp_var = find_function (tname))
  	    {
  	      VSETATTR (temp_var, (att_exported|att_imported));
***************
*** 359,363 ****
  	    }
  	  else
! 	    report_error (_("error importing function definition for `%s'"), name);
  	}
  #if defined (ARRAY_VARS)
--- 375,382 ----
  	    }
  	  else
! 	    report_error (_("error importing function definition for `%s'"), tname);
! 
! 	  /* Restore original suffix */
! 	  tname[namelen] = BASHFUNC_SUFFIX[0];
  	}
  #if defined (ARRAY_VARS)
***************
*** 2538,2542 ****
  
    INVALIDATE_EXPORTSTR (var);
!   var->exportstr = mk_env_string (name, value);
  
    array_needs_making = 1;
--- 2557,2561 ----
  
    INVALIDATE_EXPORTSTR (var);
!   var->exportstr = mk_env_string (name, value, 0);
  
    array_needs_making = 1;
***************
*** 3390,3408 ****
  
  static inline char *
! mk_env_string (name, value)
       const char *name, *value;
  {
!   int name_len, value_len;
!   char	*p;
  
    name_len = strlen (name);
    value_len = STRLEN (value);
!   p = (char *)xmalloc (2 + name_len + value_len);
!   strcpy (p, name);
!   p[name_len] = '=';
    if (value && *value)
!     strcpy (p + name_len + 1, value);
    else
!     p[name_len + 1] = '\0';
    return (p);
  }
--- 3409,3448 ----
  
  static inline char *
! mk_env_string (name, value, isfunc)
       const char *name, *value;
+      int isfunc;
  {
!   size_t name_len, value_len;
!   char	*p, *q;
  
    name_len = strlen (name);
    value_len = STRLEN (value);
! 
!   /* If we are exporting a shell function, construct the encoded function
!      name. */
!   if (isfunc && value)
!     {
!       p = (char *)xmalloc (BASHFUNC_PREFLEN + name_len + BASHFUNC_SUFFLEN + value_len + 2);
!       q = p;
!       memcpy (q, BASHFUNC_PREFIX, BASHFUNC_PREFLEN);
!       q += BASHFUNC_PREFLEN;
!       memcpy (q, name, name_len);
!       q += name_len;
!       memcpy (q, BASHFUNC_SUFFIX, BASHFUNC_SUFFLEN);
!       q += BASHFUNC_SUFFLEN;
!     }
!   else
!     {
!       p = (char *)xmalloc (2 + name_len + value_len);
!       memcpy (p, name, name_len);
!       q = p + name_len;
!     }
! 
!   q[0] = '=';
    if (value && *value)
!     memcpy (q + 1, value, value_len + 1);
    else
!     q[1] = '\0';
! 
    return (p);
  }
***************
*** 3490,3494 ****
  	     using the cached exportstr... */
  	  list[list_index] = USE_EXPORTSTR ? savestring (value)
! 					   : mk_env_string (var->name, value);
  
  	  if (USE_EXPORTSTR == 0)
--- 3530,3534 ----
  	     using the cached exportstr... */
  	  list[list_index] = USE_EXPORTSTR ? savestring (value)
! 					   : mk_env_string (var->name, value, function_p (var));
  
  	  if (USE_EXPORTSTR == 0)
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 49
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 50
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-051

Bug-Reported-by:	Florian Weimer <fweimer@redhat.com>
Bug-Reference-ID:
Bug-Reference-URL:

Bug-Description:

There are two local buffer overflows in parse.y that can cause the shell
to dump core when given many here-documents attached to a single command
or many nested loops.

Patch (apply with `patch -p0'):

*** ../bash-4.2.50/parse.y	2014-09-27 12:18:53.000000000 -0400
--- parse.y	2014-09-30 19:24:19.000000000 -0400
***************
*** 168,171 ****
--- 168,174 ----
  static int reserved_word_acceptable __P((int));
  static int yylex __P((void));
+ 
+ static void push_heredoc __P((REDIRECT *));
+ static char *mk_alexpansion __P((char *));
  static int alias_expand_token __P((char *));
  static int time_command_acceptable __P((void));
***************
*** 265,269 ****
  /* Variables to manage the task of reading here documents, because we need to
     defer the reading until after a complete command has been collected. */
! static REDIRECT *redir_stack[10];
  int need_here_doc;
  
--- 268,274 ----
  /* Variables to manage the task of reading here documents, because we need to
     defer the reading until after a complete command has been collected. */
! #define HEREDOC_MAX 16
! 
! static REDIRECT *redir_stack[HEREDOC_MAX];
  int need_here_doc;
  
***************
*** 307,311 ****
     index is decremented after a case, select, or for command is parsed. */
  #define MAX_CASE_NEST	128
! static int word_lineno[MAX_CASE_NEST];
  static int word_top = -1;
  
--- 312,316 ----
     index is decremented after a case, select, or for command is parsed. */
  #define MAX_CASE_NEST	128
! static int word_lineno[MAX_CASE_NEST+1];
  static int word_top = -1;
  
***************
*** 520,524 ****
  			  redir.filename = $2;
  			  $$ = make_redirection (source, r_reading_until, redir, 0);
! 			  redir_stack[need_here_doc++] = $$;
  			}
  	|	NUMBER LESS_LESS WORD
--- 525,529 ----
  			  redir.filename = $2;
  			  $$ = make_redirection (source, r_reading_until, redir, 0);
! 			  push_heredoc ($$);
  			}
  	|	NUMBER LESS_LESS WORD
***************
*** 527,531 ****
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_reading_until, redir, 0);
! 			  redir_stack[need_here_doc++] = $$;
  			}
  	|	REDIR_WORD LESS_LESS WORD
--- 532,536 ----
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_reading_until, redir, 0);
! 			  push_heredoc ($$);
  			}
  	|	REDIR_WORD LESS_LESS WORD
***************
*** 534,538 ****
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_reading_until, redir, REDIR_VARASSIGN);
! 			  redir_stack[need_here_doc++] = $$;
  			}
  	|	LESS_LESS_MINUS WORD
--- 539,543 ----
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_reading_until, redir, REDIR_VARASSIGN);
! 			  push_heredoc ($$);
  			}
  	|	LESS_LESS_MINUS WORD
***************
*** 541,545 ****
  			  redir.filename = $2;
  			  $$ = make_redirection (source, r_deblank_reading_until, redir, 0);
! 			  redir_stack[need_here_doc++] = $$;
  			}
  	|	NUMBER LESS_LESS_MINUS WORD
--- 546,550 ----
  			  redir.filename = $2;
  			  $$ = make_redirection (source, r_deblank_reading_until, redir, 0);
! 			  push_heredoc ($$);
  			}
  	|	NUMBER LESS_LESS_MINUS WORD
***************
*** 548,552 ****
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_deblank_reading_until, redir, 0);
! 			  redir_stack[need_here_doc++] = $$;
  			}
  	|	REDIR_WORD  LESS_LESS_MINUS WORD
--- 553,557 ----
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_deblank_reading_until, redir, 0);
! 			  push_heredoc ($$);
  			}
  	|	REDIR_WORD  LESS_LESS_MINUS WORD
***************
*** 555,559 ****
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_deblank_reading_until, redir, REDIR_VARASSIGN);
! 			  redir_stack[need_here_doc++] = $$;
  			}
  	|	LESS_LESS_LESS WORD
--- 560,564 ----
  			  redir.filename = $3;
  			  $$ = make_redirection (source, r_deblank_reading_until, redir, REDIR_VARASSIGN);
! 			  push_heredoc ($$);
  			}
  	|	LESS_LESS_LESS WORD
***************
*** 2534,2537 ****
--- 2539,2557 ----
  static int esacs_needed_count;
  
+ static void
+ push_heredoc (r)
+      REDIRECT *r;
+ {
+   if (need_here_doc >= HEREDOC_MAX)
+     {
+       last_command_exit_value = EX_BADUSAGE;
+       need_here_doc = 0;
+       report_syntax_error (_("maximum here-document count exceeded"));
+       reset_parser ();
+       exit_shell (last_command_exit_value);
+     }
+   redir_stack[need_here_doc++] = r;
+ }
+ 
  void
  gather_here_documents ()
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 50
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 51
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-052

Bug-Reported-by:	Michal Zalewski <lcamtuf@coredump.cx>
Bug-Reference-ID:
Bug-Reference-URL:

Bug-Description:

When bash is parsing a function definition that contains a here-document
delimited by end-of-file (or end-of-string), it leaves the closing delimiter
uninitialized.  This can result in an invalid memory access when the parsed
function is later copied.

Patch (apply with `patch -p0'):

*** ../bash-4.2.51/make_cmd.c	2009-09-11 17:26:12.000000000 -0400
--- make_cmd.c	2014-10-02 11:26:58.000000000 -0400
***************
*** 690,693 ****
--- 690,694 ----
    temp->redirector = source;
    temp->redirectee = dest_and_filename;
+   temp->here_doc_eof = 0;
    temp->instruction = instruction;
    temp->flags = 0;
*** ../bash-4.2.51/copy_cmd.c	2009-09-11 16:28:02.000000000 -0400
--- copy_cmd.c	2014-10-02 11:26:58.000000000 -0400
***************
*** 127,131 ****
      case r_reading_until:
      case r_deblank_reading_until:
!       new_redirect->here_doc_eof = savestring (redirect->here_doc_eof);
        /*FALLTHROUGH*/
      case r_reading_string:
--- 127,131 ----
      case r_reading_until:
      case r_deblank_reading_until:
!       new_redirect->here_doc_eof = redirect->here_doc_eof ? savestring (redirect->here_doc_eof) : 0;
        /*FALLTHROUGH*/
      case r_reading_string:
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 51
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 52
  
  #endif /* _PATCHLEVEL_H_ */
			     BASH PATCH REPORT
			     =================

Bash-Release:	4.2
Patch-ID:	bash42-053

Bug-Reported-by:	Michal Zalewski <lcamtuf@coredump.cx>
Bug-Reference-ID:
Bug-Reference-URL:

Bug-Description:

A combination of nested command substitutions and function importing from
the environment can cause bash to execute code appearing in the environment
variable value following the function definition.

Patch (apply with `patch -p0'):

*** ../bash-4.2.52/builtins/evalstring.c	2014-09-16 19:35:45.000000000 -0400
--- builtins/evalstring.c	2014-10-04 15:00:26.000000000 -0400
***************
*** 262,271 ****
  	      struct fd_bitmap *bitmap;
  
! 	      if ((flags & SEVAL_FUNCDEF) && command->type != cm_function_def)
  		{
! 		  internal_warning ("%s: ignoring function definition attempt", from_file);
! 		  should_jump_to_top_level = 0;
! 		  last_result = last_command_exit_value = EX_BADUSAGE;
! 		  break;
  		}
  
--- 262,284 ----
  	      struct fd_bitmap *bitmap;
  
! 	      if (flags & SEVAL_FUNCDEF)
  		{
! 		  char *x;
! 
! 		  /* If the command parses to something other than a straight
! 		     function definition, or if we have not consumed the entire
! 		     string, or if the parser has transformed the function
! 		     name (as parsing will if it begins or ends with shell
! 		     whitespace, for example), reject the attempt */
! 		  if (command->type != cm_function_def ||
! 		      ((x = parser_remaining_input ()) && *x) ||
! 		      (STREQ (from_file, command->value.Function_def->name->word) == 0))
! 		    {
! 		      internal_warning (_("%s: ignoring function definition attempt"), from_file);
! 		      should_jump_to_top_level = 0;
! 		      last_result = last_command_exit_value = EX_BADUSAGE;
! 		      reset_parser ();
! 		      break;
! 		    }
  		}
  
***************
*** 332,336 ****
  
  	      if (flags & SEVAL_ONECMD)
! 		break;
  	    }
  	}
--- 345,352 ----
  
  	      if (flags & SEVAL_ONECMD)
! 		{
! 		  reset_parser ();
! 		  break;
! 		}
  	    }
  	}
*** ../bash-4.2.52/parse.y	2014-09-30 19:24:19.000000000 -0400
--- parse.y	2014-10-04 15:00:26.000000000 -0400
***************
*** 2436,2439 ****
--- 2436,2449 ----
  }
  
+ char *
+ parser_remaining_input ()
+ {
+   if (shell_input_line == 0)
+     return 0;
+   if (shell_input_line_index < 0 || shell_input_line_index >= shell_input_line_len)
+     return '\0';	/* XXX */
+   return (shell_input_line + shell_input_line_index);
+ }
+ 
  #ifdef INCLUDE_UNUSED
  /* Back the input pointer up by one, effectively `ungetting' a character. */
***************
*** 3891,3896 ****
    /* reset_parser clears shell_input_line and associated variables */
    restore_input_line_state (&ls);
!   if (interactive)
!     token_to_read = 0;
  
    /* Need to find how many characters parse_and_execute consumed, update
--- 3901,3906 ----
    /* reset_parser clears shell_input_line and associated variables */
    restore_input_line_state (&ls);
! 
!   token_to_read = 0;
  
    /* Need to find how many characters parse_and_execute consumed, update
*** ../bash-4.2.52/shell.h	2011-11-21 18:03:32.000000000 -0500
--- shell.h	2014-10-04 15:00:26.000000000 -0400
***************
*** 178,181 ****
--- 178,183 ----
  
  /* Let's try declaring these here. */
+ extern char *parser_remaining_input __P((void));
+ 
  extern sh_parser_state_t *save_parser_state __P((sh_parser_state_t *));
  extern void restore_parser_state __P((sh_parser_state_t *));
*** ../bash-4.2-patched/patchlevel.h	Sat Jun 12 20:14:48 2010
--- patchlevel.h	Thu Feb 24 21:41:34 2011
***************
*** 26,30 ****
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 52
  
  #endif /* _PATCHLEVEL_H_ */
--- 26,30 ----
     looks for to find the patch level (for the sccs version string). */
  
! #define PATCHLEVEL 53
  
  #endif /* _PATCHLEVEL_H_ */
