/* colorcy.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define END_MIN 1
#define END_MAX 255
#define END_STEP 1

#define SORT_MIN 1
#define SORT_MAX 7
#define SORT_STEP 1

#define START_MIN 0
#define START_MAX 254
#define START_STEP 1

#define STEP_MIN 1
#define STEP_MAX 127
#define STEP_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
PALETTE scr_pal;

int delayy, end, start, step;

static tkeyparse
  see_f2_0 = {K_0, keysee_f2_0}, /* colorcy.c specific */
  see_f2_1 = {K_1, keysee_f2_1},
  see_f2_2 = {K_2, keysee_f2_2},
  see_f2_3 = {K_3, keysee_f2_3},
  see_f2_4 = {K_4, keysee_f2_4},
  see_f2_5 = {K_5, keysee_f2_5},
  see_f2_6 = {K_6, keysee_f2_6},
  see_f2_7 = {K_7, keysee_f2_7},
  see_f2_8 = {K_8, keysee_f2_8},
  see_f2_9 = {K_9, keysee_f2_9},
  see_f2_A = {K_A, keysee_f2_A},
  see_f2_D = {K_D, keysee_f2_D},
  see_f2_M = {K_M, keysee_f2_M},
  see_f2_N = {K_N, keysee_f2_N},
  see_f2_O = {K_O, keysee_f2_O},
  see_f2_a = {K_a, keysee_f2_a},
  see_f2_d = {K_d, keysee_f2_d},
  see_f2_m = {K_m, keysee_f2_m},
  see_f2_n = {K_n, keysee_f2_n},
  see_f2_o = {K_o, keysee_f2_o}
;

tkeyparse* tkeyparsetbl_colorcy[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f2_0, /* colorcy.c specific */
  &see_f2_1,
  &see_f2_2,
  &see_f2_3,
  &see_f2_4,
  &see_f2_5,
  &see_f2_6,
  &see_f2_7,
  &see_f2_8,
  &see_f2_9,
  &see_f2_A,
  &see_f2_D,
  &see_f2_M,
  &see_f2_N,
  &see_f2_O,
  &see_f2_a,
  &see_f2_d,
  &see_f2_m,
  &see_f2_n,
  &see_f2_o,
  NULL
};

teffect eff_colorcy =
{
  colorcy_init,
  colorcy_effect,
  colorcy_loop_end,
  colorcy_done,
  tkeyparsetbl_colorcy,
  1
};
/*---------------------------------------------------------------------------*/
int colorcy_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_A:
    case K_D:
    case K_M:
    case K_N:
    case K_O:
    case K_a:
    case K_d:
    case K_m:
    case K_n:
    case K_o:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void colorcy_done()
{
}
/*---------------------------------------------------------------------------*/
void colorcy_effect(int asort)
{
  int i, mask = 0;
  RGB temp;

  switch (asort)
    {
    case 1: /* colorcycle all colors */
      mask = 0x07;
      break;
    case 2: /* colorcycle only red */
      mask = 0x04;
      break;
    case 3: /* colorcycle only green */
      mask = 0x02;
      break;
    case 4: /* colorcycle only blue */
      mask = 0x01;
      break;
    case 5: /* colorcycle only red and green */
      mask = 0x06;
      break;
    case 6: /* colorcycle only red and blue */
      mask = 0x05;
      break;
    case 7: /* colorcycle only green and blue */
      mask = 0x03;
      break;
    default:
      break;
    }
  if ((mask & 0x04) != 0)
    {
      temp.r = scr_pal[start].r;
    }
  if ((mask & 0x02) != 0)
    {
      temp.g = scr_pal[start].g;
    }
  if ((mask & 0x01) != 0)
    {
      temp.b = scr_pal[start].b;
    }
  /* end - step must be <= 255 */
  /* check on this when changing end or step */
  for (i = start; i <= (end - step); i += step)
    {
      if ((mask & 0x04) != 0)
	{
	  scr_pal[i].r = scr_pal[i + step].r;
	}
      if ((mask & 0x02) != 0)
	{
	  scr_pal[i].g = scr_pal[i + step].g;
	}
      if ((mask & 0x01) != 0)
	{
	  scr_pal[i].b = scr_pal[i + step].b;
	}
    }
  if ((mask & 0x04) != 0)
    {
      scr_pal[i].r = temp.r;
    }
  if ((mask & 0x02) != 0)
    {
      scr_pal[i].g = temp.g;
    }
  if ((mask & 0x01) != 0)
    {
      scr_pal[i].b = temp.b;
    }
  set_palette(scr_pal);
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void colorcy_init()
{
  set_palette(pal);
  get_palette(scr_pal);
  lastkey = K_d;
}
/*---------------------------------------------------------------------------*/
void colorcy_restore()
{
  set_palette(pal);
  get_palette(scr_pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_0()
{
  keysee_f2_gen("f2_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_1()
{
  keysee_f2_gen("f2_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_2()
{
  keysee_f2_gen("f2_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_3()
{
  keysee_f2_gen("f2_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_4()
{
  keysee_f2_gen("f2_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_5()
{
  keysee_f2_gen("f2_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_6()
{
  keysee_f2_gen("f2_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_7()
{
  keysee_f2_gen("f2_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_8()
{
  keysee_f2_gen("f2_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_9()
{
  keysee_f2_gen("f2_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_A()
{
  colorcy_restore();
  paraint(&eff_colorcy.asort, SORT_MIN, SORT_MAX, SORT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_M()
{
  paraint(&start, START_MIN, START_MAX, START_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_N()
{
  if (end - step > 255)
    {
      end = 255 + step;
    }
  paraint(&end, END_MIN, END_MAX, END_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_O()
{
  colorcy_restore();
  if (end - step > 255)
    {
      step = 255 + end;
    }
  paraint(&step, STEP_MIN, STEP_MAX, STEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_a()
{
  colorcy_restore();
  paraint(&eff_colorcy.asort, SORT_MIN, SORT_MAX, SORT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_gen(uchr s[256])
{
  int pi;
  char **tps;

  colorcy_restore();
  tps = get_config_argv("[See]", s, &pi);
  eff_colorcy.asort = atoi(tps[1]);
  delayy = atoi(tps[2]);
  start = atoi(tps[3]);
  end = atoi(tps[4]);
  step = atoi(tps[5]);
  do_effect(&eff_colorcy);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_m()
{
  paraint(&start, START_MIN, START_MAX, START_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_n()
{
  if (end - step > 255)
    {
      end = 255 + step;
    }
  paraint(&end, END_MIN, END_MAX, END_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_o()
{
  colorcy_restore();
  if (end - step > 255)
    {
      step = 255 + end;
    }
  paraint(&step, STEP_MIN, STEP_MAX, STEP_STEP, 0, 0);
}
